/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.LexiconEntry;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.RelatedSpellingsListConverter;
import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.MutableInteger;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

@XStreamAlias(value="LexiconLookupResult")
public class LexiconLookupResult
extends BaseResults {
    public String spelling;
    public String corpusConfig;
    public LexiconEntry lexiconEntry;
    @XStreamConverter(value=RelatedSpellingsListConverter.class)
    public List<String> relatedSpellings;

    public LexiconLookupResult() {
        this.spelling = "";
        this.corpusConfig = "";
        this.lexiconEntry = null;
        this.relatedSpellings = null;
    }

    public LexiconLookupResult(String spelling, String corpusConfig, LexiconEntry lexiconEntry, List<String> relatedSpellings) {
        this.spelling = spelling;
        this.corpusConfig = corpusConfig;
        this.lexiconEntry = lexiconEntry;
        this.relatedSpellings = relatedSpellings;
    }

    public String toString1() {
        StringBuffer sb = new StringBuffer();
        if (this.spelling.length() == 0) {
            return "No spelling provided.\n";
        }
        if (this.lexiconEntry == null) {
            return this.spelling + " does not appear in " + "the " + this.corpusConfig + " corpus training data.\n";
        }
        sb.append(this.spelling + " appears " + Formatters.formatIntegerWithCommas((int)this.lexiconEntry.entryCount) + " time" + (this.lexiconEntry.entryCount == 1 ? "" : "s") + " in the " + this.corpusConfig + " corpus training data.\n");
        sb.append("Part of Speech\tLemma\tCount\n");
        Iterator iterator = this.lexiconEntry.categoriesAndCounts.keySet().iterator();
        TreeSet<String> lemmata = new TreeSet<String>();
        while (iterator.hasNext()) {
            String posTag = (String)iterator.next();
            String lemma = (String)this.lexiconEntry.lemmata.get(posTag);
            lemmata.add(lemma);
            int count = ((MutableInteger)this.lexiconEntry.categoriesAndCounts.get(posTag)).intValue();
            sb.append(posTag);
            sb.append("\t");
            sb.append(lemma);
            sb.append("\t");
            sb.append(Formatters.formatIntegerWithCommas((int)count));
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString2() {
        StringBuffer sb = new StringBuffer();
        if (this.relatedSpellings != null && this.relatedSpellings.size() > 0) {
            sb.append("\nRelated spellings:\n");
            StringBuffer sb2 = new StringBuffer();
            sb2.append(this.relatedSpellings.get(0));
            for (int i = 1; i < this.relatedSpellings.size(); ++i) {
                sb2.append(", ");
                sb2.append(this.relatedSpellings.get(i));
            }
            sb.append(sb2.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toString1() + this.toString2();
    }

    @Override
    public String toHTML() {
        return LexiconLookupResult.tabularDataBaseResults(this.toString1(), false) + LexiconLookupResult.tabularDataBaseResults(this.toString2(), false);
    }
}

