/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.corpuslinguistics.lexicon.LexiconEntry;
import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.LexiconLookupResult;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MutableInteger;
import edu.northwestern.at.utils.StringUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class LexiconLookupResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Lexicon lookup resource");
        this.setDescription("Looks up information about word in corpus configuration training  data.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.lexiconLookup(queryParams), "MutableInteger", MutableInteger.class);
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.lexiconLookup(queryParams), "MutableInteger", MutableInteger.class);
    }

    public LexiconLookupResult lexiconLookup(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        LexiconEntry lexiconEntry = null;
        List relatedSpellings = null;
        if (spelling.length() > 0 && (lexiconEntry = adornerInfo.adorner.wordLexicon.getLexiconEntry(spelling)) != null) {
            Iterator<Object> iterator = lexiconEntry.categoriesAndCounts.keySet().iterator();
            TreeSet<String> lemmata = new TreeSet<String>();
            while (iterator.hasNext()) {
                String posTag = (String)iterator.next();
                String lemma = (String)lexiconEntry.lemmata.get(posTag);
                lemmata.add(lemma);
            }
            for (String theLemma : lemmata) {
                Set spellingsSet = (Set)adornerInfo.lemmaToSpellings.get((Object)theLemma);
                spellingsSet.remove(spelling);
                if (spellingsSet.size() <= 0) continue;
                if (relatedSpellings == null) {
                    relatedSpellings = ListFactory.createNewList();
                }
                relatedSpellings.addAll(spellingsSet);
            }
        }
        return new LexiconLookupResult(spelling, corpusConfig, lexiconEntry, relatedSpellings);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling to look up in corpus lexicon.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        return this.sortParams(params);
    }
}

