/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.LemmatizerResult;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class LemmatizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Lemmatizer resource");
        this.setDescription("Finds lemma form of a word.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.lemmatize(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.lemmatize(queryParams));
    }

    public LemmatizerResult lemmatize(Form queryParams) {
        String spelling;
        String standardSpelling = spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        String wordClass = StringUtils.safeString((String)queryParams.getFirstValue("wordClass")).trim();
        String wordClass2 = StringUtils.safeString((String)queryParams.getFirstValue("wordClass2")).trim();
        boolean standardize = LemmatizerResource.getBooleanValue(StringUtils.safeString((String)queryParams.getFirstValue("standardize")).trim(), false);
        String lemma = "";
        String lancasterStem = "";
        String porterStem = "";
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        if (spelling.length() > 0) {
            if (standardize) {
                standardSpelling = adornerInfo.adorner.spellingStandardizer.standardizeSpelling(spelling, "");
            }
            lemma = wordClass.length() > 0 ? (wordClass2.length() > 0 ? MorphAdornerServerData.lemmatizer.lemmatize(standardSpelling, wordClass + "," + wordClass2) : MorphAdornerServerData.lemmatizer.lemmatize(standardSpelling, wordClass)) : MorphAdornerServerData.lemmatizer.lemmatize(standardSpelling);
            porterStem = MorphAdornerServerData.porterStemmer.stem(standardSpelling);
            lancasterStem = MorphAdornerServerData.lancasterStemmer.stem(standardSpelling);
        }
        return new LemmatizerResult(spelling, standardize, standardSpelling, corpusConfig, wordClass, wordClass2, lemma, lancasterStem, porterStem);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling to lemmatize.");
        params.add(param);
        param = new ParameterInfo("standardize", true, WADLBOOLEAN, ParameterStyle.QUERY, "True to standard the spelling before lemmatization.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        param = new ParameterInfo("wordClass", true, WADLSTRING, ParameterStyle.QUERY, "Primary word class of spelling.");
        params.add(param);
        param = new ParameterInfo("wordClass2", true, WADLSTRING, ParameterStyle.QUERY, "Secondary word class of spelling.");
        params.add(param);
        return this.sortParams(params);
    }
}

