/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.ScoredLanguage;
import edu.northwestern.at.morphadorner.server.converters.LanguageListConverter;
import edu.northwestern.at.utils.Formatters;
import java.util.List;

@XStreamAlias(value="LanguageRecognizerResult")
public class LanguageRecognizerResult
extends BaseResults {
    public String text;
    @XStreamConverter(value=LanguageListConverter.class)
    public List<ScoredLanguage> languages;

    public LanguageRecognizerResult() {
        this.text = null;
        this.languages = null;
    }

    public LanguageRecognizerResult(String text, List<ScoredLanguage> languages) {
        this.text = text;
        this.languages = languages;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.languages.size()) {
            case 0: {
                sb.append("No language identified.\n");
                break;
            }
            case 1: {
                sb.append("1 language identified.\n");
                break;
            }
            default: {
                sb.append(this.languages.size() + " languages identified.\n");
            }
        }
        sb.append("Language\tScore\n");
        for (int i = 0; i < this.languages.size(); ++i) {
            String languageCode = this.languages.get(i).getLanguageCode();
            String languageName = this.languages.get(i).getLanguageName();
            String score = Formatters.formatDouble((double)this.languages.get(i).getScore(), (int)4);
            sb.append(languageCode);
            sb.append(" (");
            sb.append(languageName);
            sb.append(")\t");
            sb.append(score);
            sb.append("\n");
        }
        return sb.toString();
    }
}

