/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.LanguageRecognizerResult;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.ScoredLanguage;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import java.util.Locale;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class LanguageRecognizerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Language recognizer resource");
        this.setDescription("Recognizes language of text.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.recognizeLanguage(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.recognizeLanguage(queryParams));
    }

    public LanguageRecognizerResult recognizeLanguage(Form queryParams) {
        String text = StringUtils.safeString((String)queryParams.getFirstValue("text")).trim();
        boolean includeInputText = queryParams.getFirstValue("includeInputText") != null;
        String untaggedText = this.unTag(text);
        List languageList = null;
        if (untaggedText.length() > 0) {
            ScoredString[] languages = MorphAdornerServerData.languageRecognizer.recognizeLanguage(untaggedText);
            if (languages == null) {
                ScoredString unknown = new ScoredString("", 0.0);
                languages = new ScoredString[]{unknown};
            }
            languageList = ListFactory.createNewList();
            for (int i = 0; i < languages.length; ++i) {
                String langCode = languages[i].getString();
                Locale locale = new Locale(langCode);
                String langName = locale.getDisplayLanguage();
                if (langCode.equals("zh-cn") || langCode.equals("zh-tw")) {
                    langCode = "zh";
                    langName = "Chinese";
                }
                languageList.add(new ScoredLanguage(langCode, langName, languages[i].getScore()));
            }
        }
        return new LanguageRecognizerResult(includeInputText ? text : null, languageList);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("text", true, WADLSTRING, ParameterStyle.QUERY, "Text for which to recognize the language.");
        params.add(param);
        param = new ParameterInfo("includeInputText", true, WADLBOOLEAN, ParameterStyle.QUERY, "Include input text in response.");
        params.add(param);
        return this.sortParams(params);
    }
}

