/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.HyphenatorResult;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class HyphenatorResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Hyphenator resource");
        this.setDescription("Hyphenates words.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.hyphenate(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.hyphenate(queryParams));
    }

    public HyphenatorResult hyphenate(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        String sAmerican = StringUtils.safeString((String)queryParams.getFirstValue("american")).trim();
        boolean american = sAmerican.equals("1") || sAmerican.equals("true");
        String hyphenatedSpelling = "";
        if (spelling.length() > 0) {
            hyphenatedSpelling = this.hyphenate(spelling, american);
            hyphenatedSpelling = StringUtils.replaceAll((String)hyphenatedSpelling, (String)"\u00ad", (String)"-");
        }
        return new HyphenatorResult(spelling, american, hyphenatedSpelling);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling to hyphenate.");
        params.add(param);
        param = new ParameterInfo("american", true, WADLSTRING, ParameterStyle.QUERY, "Use American hyphenation rules instead of British.");
        params.add(param);
        return this.sortParams(params);
    }
}

