/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.converters.SuggestionsListConverter;
import java.util.List;

@XStreamAlias(value="GapFillerResult")
public class GapFillerResult
extends BaseResults {
    public String spelling;
    public String corpusConfig;
    @XStreamConverter(value=SuggestionsListConverter.class)
    public List<String> suggestions;

    public GapFillerResult() {
        this.spelling = "";
        this.corpusConfig = "";
        this.suggestions = null;
    }

    public GapFillerResult(String spelling, String corpusConfig, List<String> suggestions) {
        this.spelling = spelling;
        this.corpusConfig = corpusConfig;
        this.suggestions = suggestions;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        switch (this.suggestions.size()) {
            case 0: {
                sb.append("No suggestions found.\n");
                break;
            }
            case 1: {
                sb.append("1 suggestion found.\n");
                break;
            }
            default: {
                sb.append(this.suggestions.size() + " suggestions found.\n");
            }
        }
        sb.append("\n");
        for (int i = 0; i < this.suggestions.size(); ++i) {
            sb.append(this.suggestions.get(i));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String toHTML() {
        return GapFillerResult.tabularDataBaseResults(this.toString(), false);
    }
}

