/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.GapFillerResult;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.utils.CharUtils;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.StringUtils;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class GapFillerResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Gap filler resource");
        this.setDescription("Fills gap characters.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.fillGaps(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.fillGaps(queryParams));
    }

    public GapFillerResult fillGaps(Form queryParams) {
        String spelling = StringUtils.safeString((String)queryParams.getFirstValue("spelling")).trim();
        spelling = StringUtils.replaceAll((String)spelling, (String)"?", (String)"\u25cf");
        String corpusConfig = StringUtils.safeString((String)queryParams.getFirstValue("corpusConfig")).trim();
        MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
        List filteredSuggestions = ListFactory.createNewList();
        if (spelling.length() > 0 && CharUtils.hasGapCharacter((String)spelling)) {
            List suggestions = adornerInfo.gapFiller.getMatchingWords(spelling);
            for (String suggestion : suggestions) {
                if (CharUtils.hasGapCharacter((String)suggestion)) continue;
                filteredSuggestions.add(suggestion);
            }
        } else {
            filteredSuggestions.add(spelling);
        }
        return new GapFillerResult(spelling, corpusConfig, filteredSuggestions);
    }

    @Override
    protected List<ParameterInfo> describeParameters() {
        List<ParameterInfo> params = super.describeParameters();
        ParameterInfo param = new ParameterInfo("spelling", true, WADLSTRING, ParameterStyle.QUERY, "Spelling containing gaps to fill.");
        params.add(param);
        param = new ParameterInfo("corpusConfig", true, WADLSTRING, ParameterStyle.QUERY, "Corpus configuration.");
        params.add(param);
        return this.sortParams(params);
    }
}

