/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import edu.northwestern.at.morphadorner.server.BaseAdornerServerResource;
import edu.northwestern.at.morphadorner.server.CorpusConfigInfo;
import edu.northwestern.at.morphadorner.server.CorpusConfigResult;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.utils.ListFactory;
import java.util.List;
import org.restlet.data.Form;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class CorpusConfigResource
extends BaseAdornerServerResource {
    protected void doInit() throws ResourceException {
        this.setName("Corpus configuration resource");
        this.setDescription("Describes a corpus configuration.");
    }

    @Get(value="txt|html|xml|json")
    public Representation handleGet() {
        Form queryParams = new Form(this.getRequest().getOriginalRef().getQuery());
        return this.postResults(queryParams, this.corpusConfig(queryParams));
    }

    @Post(value="form:txt|html|xml|json")
    public Representation handlePost(Representation representation) {
        Form queryParams = new Form(representation);
        return this.postResults(queryParams, this.corpusConfig(queryParams));
    }

    public CorpusConfigResult corpusConfig(Form queryParams) {
        List corpusConfigInfoList = ListFactory.createNewList();
        for (String configName : MorphAdornerServerData.corpusConfigs.keySet()) {
            MorphAdornerServerInfo serverInfo = MorphAdornerServerData.corpusConfigs.get(configName);
            CorpusConfigInfo corpusConfigInfo = new CorpusConfigInfo(serverInfo.serverInfoName, serverInfo.serverInfoDescription);
            corpusConfigInfoList.add(corpusConfigInfo);
        }
        return new CorpusConfigResult(corpusConfigInfoList);
    }
}

