/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.server;

import com.thoughtworks.xstream.XStream;
import edu.northwestern.at.morphadorner.corpuslinguistics.sentencesplitter.ICU4JBreakIteratorSentenceSplitter;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.CanSplitAroundPeriods;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.ICU4JBreakIteratorWordTokenizer;
import edu.northwestern.at.morphadorner.corpuslinguistics.tokenizer.WordTokenizer;
import edu.northwestern.at.morphadorner.server.BaseResults;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerData;
import edu.northwestern.at.morphadorner.server.MorphAdornerServerInfo;
import edu.northwestern.at.morphadorner.server.WADLConverter;
import edu.northwestern.at.utils.ScoredString;
import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.html.HTMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.restlet.Message;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.ParameterInfo;
import org.restlet.ext.wadl.ParameterStyle;
import org.restlet.ext.wadl.ResponseInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.ext.xstream.XstreamRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Options;
import org.restlet.util.Series;

public class BaseAdornerServerResource
extends WadlServerResource {
    public static String WADLSTRING = "xsd:string";
    public static String WADLINT = "xsd:int";
    public static String WADLBOOLEAN = "xsd:boolean";
    protected static final String HEADERS_KEY = "org.restlet.http.headers";

    protected Series<Header> getMessageHeaders(Message message) {
        Series prev;
        ConcurrentMap attrs = message.getAttributes();
        Series headers = (Series)attrs.get(HEADERS_KEY);
        if (headers == null && (prev = attrs.putIfAbsent(HEADERS_KEY, headers = new Series(Header.class))) != null) {
            headers = prev;
        }
        return headers;
    }

    @Options
    public void doOptions(Representation entity) {
        Series<Header> responseHeaders = this.getMessageHeaders((Message)this.getResponse());
        responseHeaders.add("Access-Control-Allow-Origin", "*");
        responseHeaders.add("Access-Control-Allow-Methods", "GET, POST, OPTIONS");
        responseHeaders.add("Access-Control-Allow-Headers", "Content-Type");
        responseHeaders.add("Access-Control-Allow-Credentials", "true");
        responseHeaders.add("Access-Control-Max-Age", "120");
    }

    public void addCORSHeaders() {
        Series<Header> responseHeaders = this.getMessageHeaders((Message)this.getResponse());
        responseHeaders.add("Access-Control-Allow-Origin", "*");
    }

    protected List<ParameterInfo> describeParameters() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        ParameterInfo param = new ParameterInfo("media", false, WADLSTRING, ParameterStyle.QUERY, "Media type of response.");
        params.add(param);
        return params;
    }

    public String unTag(String text) {
        String result = text.trim();
        if (HTMLUtils.isHTMLTaggedText((String)result)) {
            result = HTMLUtils.stripHTMLTags((String)result);
        }
        result = result.replaceAll("\\s", " ");
        return result;
    }

    public static int getIntValue(String requestValue, int defaultValue) {
        int result = defaultValue;
        if (requestValue != null) {
            try {
                result = Integer.parseInt(requestValue);
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
        }
        return result;
    }

    public static boolean getBooleanValue(String requestValue, boolean defaultValue) {
        boolean result = defaultValue;
        if (requestValue != null) {
            try {
                result = Boolean.parseBoolean(requestValue);
            }
            catch (NumberFormatException e) {
                result = defaultValue;
            }
        }
        return result;
    }

    public String recognizeLanguage(String text, String defaultLangCode) {
        ScoredString[] languages;
        String result = defaultLangCode;
        if (text != null && text.length() > 0 && (languages = MorphAdornerServerData.languageRecognizer.recognizeLanguage(text)) != null) {
            result = languages[0].getString();
        }
        return result;
    }

    public String recognizeLanguage(String text) {
        return this.recognizeLanguage(text, "en");
    }

    public String hyphenate(String spelling, boolean american) {
        String result = "";
        result = american ? MorphAdornerServerData.americanHyphenator.hyphenate(spelling) : MorphAdornerServerData.britishHyphenator.hyphenate(spelling);
        return result;
    }

    public List<List<String>> extractSentences(String text, String langCode, String corpusConfig) {
        List sentences = null;
        if (langCode.length() > 0 && !langCode.equals("en")) {
            ICU4JBreakIteratorWordTokenizer tokenizer = new ICU4JBreakIteratorWordTokenizer(new Locale(langCode));
            ((CanSplitAroundPeriods)tokenizer).setSplitAroundPeriods(false);
            ICU4JBreakIteratorSentenceSplitter splitter = new ICU4JBreakIteratorSentenceSplitter(new Locale(langCode));
            sentences = splitter.extractSentences(text, (WordTokenizer)tokenizer);
        } else {
            MorphAdornerServerInfo adornerInfo = MorphAdornerServerData.getAdornerInfo(corpusConfig);
            sentences = adornerInfo.sentenceSplitter.extractSentences(text);
        }
        return sentences;
    }

    public <T extends BaseResults> Representation postResults(Form queryParams, T results, String aliasName, Class aliasClass, String aliasName2, Class aliasClass2, String aliasName3, Class aliasClass3) {
        this.addCORSHeaders();
        String media = StringUtils.safeString((String)queryParams.getFirstValue("media")).trim();
        if (media.equals("html")) {
            String html = results.toHTML();
            return new StringRepresentation((CharSequence)html, MediaType.TEXT_HTML);
        }
        if (media.equals("text")) {
            String text = results.toString();
            return new StringRepresentation((CharSequence)text, MediaType.TEXT_PLAIN);
        }
        XstreamRepresentation reprResult = new XstreamRepresentation(media.equals("json") ? MediaType.APPLICATION_JSON : MediaType.APPLICATION_XML, results);
        if (aliasName != null && aliasClass != null) {
            XStream xStream = null;
            try {
                xStream = reprResult.getXstream();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (xStream != null) {
                xStream.alias(aliasName, aliasClass);
                if (aliasName2 != null && aliasClass2 != null) {
                    xStream.alias(aliasName2, aliasClass2);
                }
                if (aliasName3 != null && aliasClass3 != null) {
                    xStream.alias(aliasName3, aliasClass3);
                }
            }
        }
        return reprResult;
    }

    public <T extends BaseResults> Representation postResults(Form queryParams, T results, String aliasName, Class aliasClass, String aliasName2, Class aliasClass2) {
        return this.postResults(queryParams, results, aliasName, aliasClass, aliasName2, aliasClass2, null, null);
    }

    public <T extends BaseResults> Representation postResults(Form queryParams, T results, String aliasName, Class aliasClass) {
        return this.postResults(queryParams, results, aliasName, aliasClass, null, null, null, null);
    }

    public <T extends BaseResults> Representation postResults(Form queryParams, T results) {
        return this.postResults(queryParams, results, null, null, null, null, null, null);
    }

    protected Representation createHtmlRepresentation(ApplicationInfo applicationInfo) {
        Representation result = null;
        try {
            result = WADLConverter.createHtmlRepresentation(this.createWadlRepresentation(applicationInfo).getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public List<ParameterInfo> sortParams(List<ParameterInfo> params) {
        Collections.sort(params, new ParameterInfoComparable());
        return params;
    }

    public void addStatusCodes(MethodInfo methodInfo) {
        ResponseInfo responseInfo = new ResponseInfo();
        responseInfo.getStatuses().add(new Status(400, "Bad request.", "Bad request.", null));
        methodInfo.getResponses().add(responseInfo);
        responseInfo = new ResponseInfo();
        responseInfo.getStatuses().add(new Status(200, "OK.", "OK.", null));
        methodInfo.getResponses().add(responseInfo);
    }

    protected void describeGet(MethodInfo methodInfo) {
        this.addStatusCodes(methodInfo);
        super.describeGet(methodInfo);
    }

    protected void describePost(MethodInfo methodInfo) {
        this.addStatusCodes(methodInfo);
        super.describePost(methodInfo);
    }

    public class ParameterInfoComparable
    implements Comparator<ParameterInfo> {
        @Override
        public int compare(ParameterInfo o1, ParameterInfo o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

