/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.javaspi;

import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ICULocaleServiceProvider {
    private static final String SPI_PROP_FILE = "com/ibm/icu/impl/javaspi/ICULocaleServiceProviderConfig.properties";
    private static final String SUFFIX_KEY = "com.ibm.icu.impl.javaspi.ICULocaleServiceProvider.icuVariantSuffix";
    private static final String ENABLE_VARIANTS_KEY = "com.ibm.icu.impl.javaspi.ICULocaleServiceProvider.enableIcuVariants";
    private static final String ENABLE_ISO3_LANG_KEY = "com.ibm.icu.impl.javaspi.ICULocaleServiceProvider.enableIso3Languages";
    private static final String USE_DECIMALFORMAT_KEY = "com.ibm.icu.impl.javaspi.ICULocaleServiceProvider.useDecimalFormat";
    private static boolean configLoaded = false;
    private static String suffix = "ICU4J";
    private static boolean enableVariants = true;
    private static boolean enableIso3Lang = true;
    private static boolean useDecimalFormat = false;
    private static final Locale[] SPECIAL_LOCALES = new Locale[]{new Locale("ja", "JP", "JP"), new Locale("no"), new Locale("no", "NO"), new Locale("no", "NO", "NY"), new Locale("sr", "CS"), new Locale("th", "TH", "TH")};
    private static Map<Locale, Locale> SPECIAL_LOCALES_MAP = null;
    private static Locale[] LOCALES = null;

    public static Locale[] getAvailableLocales() {
        Locale[] all = ICULocaleServiceProvider.getLocales();
        return Arrays.copyOf(all, all.length);
    }

    public static ULocale toULocaleNoSpecialVariant(Locale locale) {
        String orgID;
        int kwdIdx;
        Locale spLoc = ICULocaleServiceProvider.getSpecialLocalesMap().get(locale);
        if (spLoc != null) {
            return ULocale.forLocale((Locale)spLoc);
        }
        ULocale result = ULocale.forLocale((Locale)locale);
        String variant = result.getVariant();
        String suffix = ICULocaleServiceProvider.getIcuSuffix();
        String variantNoSuffix = null;
        if (variant.equals(suffix)) {
            variantNoSuffix = "";
        } else if (variant.endsWith(suffix) && variant.charAt(variant.length() - suffix.length() - 1) == '_') {
            variantNoSuffix = variant.substring(0, variant.length() - suffix.length() - 1);
        }
        if (variantNoSuffix == null) {
            return result;
        }
        StringBuilder id = new StringBuilder(result.getLanguage());
        String script = result.getScript();
        String country = result.getCountry();
        if (script.length() > 0) {
            id.append('_');
            id.append(script);
        }
        if (country.length() > 0 || variantNoSuffix.length() > 0) {
            id.append('_');
            id.append(country);
        }
        if (variantNoSuffix.length() > 0) {
            id.append('_');
            id.append(variantNoSuffix);
        }
        if ((kwdIdx = (orgID = result.getName()).indexOf(64)) >= 0) {
            id.append(orgID.substring(kwdIdx));
        }
        return new ULocale(id.toString());
    }

    public static boolean useDecimalFormat() {
        ICULocaleServiceProvider.loadConfiguration();
        return useDecimalFormat;
    }

    private static synchronized Map<Locale, Locale> getSpecialLocalesMap() {
        if (SPECIAL_LOCALES_MAP != null) {
            return SPECIAL_LOCALES_MAP;
        }
        HashMap<Locale, Locale> splocs = new HashMap<Locale, Locale>();
        for (Locale spLoc : SPECIAL_LOCALES) {
            String var = spLoc.getVariant();
            if (var.length() <= 0) continue;
            splocs.put(new Locale(spLoc.getLanguage(), spLoc.getCountry(), var + "_" + ICULocaleServiceProvider.getIcuSuffix()), spLoc);
        }
        SPECIAL_LOCALES_MAP = Collections.unmodifiableMap(splocs);
        return SPECIAL_LOCALES_MAP;
    }

    private static synchronized Locale[] getLocales() {
        ULocale[] icuLocales;
        if (LOCALES != null) {
            return LOCALES;
        }
        HashSet<Locale> localeSet = new HashSet<Locale>();
        for (ULocale uLocale : icuLocales = ICUResourceBundle.getAvailableULocales()) {
            String language = uLocale.getLanguage();
            if (language.length() >= 3 && !ICULocaleServiceProvider.enableIso3Languages()) continue;
            ICULocaleServiceProvider.addULocale(uLocale, localeSet);
            if (uLocale.getScript().length() <= 0 || uLocale.getCountry().length() <= 0) continue;
            ULocale.Builder locBld = new ULocale.Builder();
            try {
                locBld.setLocale(uLocale);
                locBld.setScript(null);
                ULocale ulocWithoutScript = locBld.build();
                ICULocaleServiceProvider.addULocale(ulocWithoutScript, localeSet);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (Locale locale : SPECIAL_LOCALES) {
            ICULocaleServiceProvider.addLocale(locale, localeSet);
        }
        LOCALES = localeSet.toArray(new Locale[0]);
        return LOCALES;
    }

    private static void addLocale(Locale loc, Set<Locale> locales) {
        locales.add(loc);
        if (ICULocaleServiceProvider.enableIcuVariants()) {
            String language = loc.getLanguage();
            String country = loc.getCountry();
            String variant = loc.getVariant();
            StringBuilder var = new StringBuilder(variant);
            if (var.length() != 0) {
                var.append("_");
            }
            var.append(ICULocaleServiceProvider.getIcuSuffix());
            locales.add(new Locale(language, country, var.toString()));
        }
    }

    private static void addULocale(ULocale uloc, Set<Locale> locales) {
        if (uloc.getLanguage().equals("nn") && uloc.getScript().length() == 0) {
            Locale locNN = new Locale(uloc.getLanguage(), uloc.getCountry(), uloc.getVariant());
            ICULocaleServiceProvider.addLocale(locNN, locales);
            return;
        }
        locales.add(uloc.toLocale());
        if (ICULocaleServiceProvider.enableIcuVariants()) {
            StringBuilder var = new StringBuilder(uloc.getVariant());
            if (var.length() != 0) {
                var.append("_");
            }
            var.append(ICULocaleServiceProvider.getIcuSuffix());
            ULocale.Builder locBld = new ULocale.Builder();
            try {
                locBld.setLocale(uloc);
                locBld.setVariant(var.toString());
                ULocale ulocWithVar = locBld.build();
                locales.add(ulocWithVar.toLocale());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static boolean enableIso3Languages() {
        return enableIso3Lang;
    }

    private static boolean enableIcuVariants() {
        ICULocaleServiceProvider.loadConfiguration();
        return enableVariants;
    }

    private static String getIcuSuffix() {
        ICULocaleServiceProvider.loadConfiguration();
        return suffix;
    }

    private static synchronized void loadConfiguration() {
        if (configLoaded) {
            return;
        }
        Properties spiConfigProps = new Properties();
        try {
            InputStream is = ClassLoader.getSystemResourceAsStream(SPI_PROP_FILE);
            spiConfigProps.load(is);
            String val = (String)spiConfigProps.get(SUFFIX_KEY);
            if (val != null && val.length() > 0) {
                suffix = val;
            }
            enableVariants = ICULocaleServiceProvider.parseBooleanString((String)spiConfigProps.get(ENABLE_VARIANTS_KEY), enableVariants);
            enableIso3Lang = ICULocaleServiceProvider.parseBooleanString((String)spiConfigProps.get(ENABLE_ISO3_LANG_KEY), enableIso3Lang);
            useDecimalFormat = ICULocaleServiceProvider.parseBooleanString((String)spiConfigProps.get(USE_DECIMALFORMAT_KEY), useDecimalFormat);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        configLoaded = true;
    }

    private static boolean parseBooleanString(String str, boolean defaultVal) {
        if (str == null) {
            return defaultVal;
        }
        if (str.equalsIgnoreCase("true")) {
            return true;
        }
        if (str.equalsIgnoreCase("false")) {
            return false;
        }
        return defaultVal;
    }
}

