/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.RetrievalException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class SampleSentenceData {
    private static final char KEY_TERMINATOR = ' ';
    private Map typeMaps = new HashMap();
    private ResourceBundle bundle;

    protected SampleSentenceData() {
    }

    protected Object getValue(SynsetType type, Object key) {
        Map subMap = this.getSubMap(type);
        return subMap != null ? subMap.get(key) : null;
    }

    private synchronized Map getSubMap(SynsetType type) throws RetrievalException {
        Map subMap;
        if (!this.typeMaps.containsKey(type)) {
            subMap = this.loadData(type);
            this.typeMaps.put(type, subMap);
        } else {
            subMap = (Map)this.typeMaps.get(type);
        }
        return subMap;
    }

    private Map loadData(SynsetType type) throws RetrievalException {
        Map subMap = null;
        String fileName = this.getFileName(type);
        if (fileName != null) {
            try {
                subMap = this.createMap(fileName);
            }
            catch (IOException ioe) {
                throw new RetrievalException("Error reading file " + fileName + ": " + ioe.getMessage(), ioe);
            }
        }
        return subMap;
    }

    private String getFileName(SynsetType type) {
        String fileName;
        ResourceBundle bundle = this.getBundle();
        try {
            fileName = bundle.getString(Integer.toString(type.getCode()));
        }
        catch (MissingResourceException mre) {
            fileName = null;
        }
        return fileName;
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle(this.getResourceBundleName());
        }
        return this.bundle;
    }

    protected String getResourceBundleName() {
        return this.getClass().getName();
    }

    private Map createMap(String fileName) throws IOException {
        HashMap keySentences = new HashMap();
        File file = new File(System.getProperty("wordnet.database.dir", "."), fileName);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String line = reader.readLine();
        while (line != null) {
            int index = line.indexOf(32);
            String key = line.substring(0, index);
            String value = line.substring(index + 1).trim();
            this.putKeyValuePair(keySentences, key, value);
            line = reader.readLine();
        }
        reader.close();
        return keySentences;
    }

    protected void putKeyValuePair(Map map, String key, String value) {
        map.put(key, value);
    }
}

