/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

public class RelationshipType {
    public static final RelationshipType ANTONYM = new RelationshipType("!");
    public static final RelationshipType HYPONYM = new RelationshipType("~");
    public static final RelationshipType HYPERNYM = new RelationshipType("@");
    public static final RelationshipType INSTANCE_HYPONYM = new RelationshipType("~i");
    public static final RelationshipType INSTANCE_HYPERNYM = new RelationshipType("@i");
    public static final RelationshipType PART_HOLONYM = new RelationshipType("#p");
    public static final RelationshipType MEMBER_HOLONYM = new RelationshipType("#m");
    public static final RelationshipType SUBSTANCE_HOLONYM = new RelationshipType("#s");
    public static final RelationshipType MEMBER_MERONYM = new RelationshipType("%m");
    public static final RelationshipType SUBSTANCE_MERONYM = new RelationshipType("%s");
    public static final RelationshipType PART_MERONYM = new RelationshipType("%p");
    public static final RelationshipType ATTRIBUTE = new RelationshipType("=");
    public static final RelationshipType RELATED_FORM = new RelationshipType("+");
    public static final RelationshipType DOMAIN_TOPIC = new RelationshipType(";c");
    public static final RelationshipType MEMBER_OF_DOMAIN_TOPIC = new RelationshipType("-c");
    public static final RelationshipType DOMAIN_REGION = new RelationshipType(";r");
    public static final RelationshipType MEMBER_OF_DOMAIN_REGION = new RelationshipType("-r");
    public static final RelationshipType DOMAIN_USAGE = new RelationshipType(";u");
    public static final RelationshipType MEMBER_OF_DOMAIN_USAGE = new RelationshipType("-u");
    public static final RelationshipType ENTAILMENT = new RelationshipType("*");
    public static final RelationshipType CAUSE = new RelationshipType(">");
    public static final RelationshipType ALSO_SEE = new RelationshipType("^");
    public static final RelationshipType VERB_GROUP = new RelationshipType("$");
    public static final RelationshipType SIMILAR = new RelationshipType("&");
    public static final RelationshipType PARTICIPLE = new RelationshipType("<");
    public static final RelationshipType PERTAINYM = new RelationshipType("\\");
    public static final RelationshipType[] ALL_TYPES = new RelationshipType[]{ANTONYM, HYPERNYM, INSTANCE_HYPERNYM, HYPONYM, INSTANCE_HYPONYM, MEMBER_HOLONYM, SUBSTANCE_HOLONYM, PART_HOLONYM, MEMBER_MERONYM, SUBSTANCE_MERONYM, PART_MERONYM, ATTRIBUTE, RELATED_FORM, DOMAIN_TOPIC, MEMBER_OF_DOMAIN_TOPIC, DOMAIN_REGION, MEMBER_OF_DOMAIN_REGION, DOMAIN_USAGE, MEMBER_OF_DOMAIN_USAGE, ENTAILMENT, CAUSE, ALSO_SEE, VERB_GROUP, SIMILAR, PARTICIPLE, PERTAINYM};
    private String symbol;

    public static RelationshipType getRelationshipType(String symbol) {
        RelationshipType match = null;
        for (int i = 0; i < ALL_TYPES.length; ++i) {
            if (!symbol.equals(ALL_TYPES[i].getSymbol())) continue;
            match = ALL_TYPES[i];
            break;
        }
        return match;
    }

    private RelationshipType(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof RelationshipType) {
            RelationshipType target = (RelationshipType)o;
            isEqual = this.symbol.equals(target.getSymbol());
        }
        return isEqual;
    }

    public String toString() {
        return this.getSymbol();
    }
}

