/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.Synset;
import edu.smu.tspell.wordnet.WordSense;
import edu.smu.tspell.wordnet.impl.file.RelationshipType;
import java.util.HashMap;
import java.util.Map;

public class RelationshipReferences {
    private static final String SYNSET_KEY = "*";
    private Map sourceMaps = new HashMap();

    public void putSemanticRelationships(RelationshipType type, Synset[] synsets) {
        Map subMap = this.getSubMap(type, true);
        subMap.put(SYNSET_KEY, synsets);
    }

    public Synset[] getSemanticRelationships(RelationshipType type) {
        Map subMap = this.getSubMap(type, false);
        return subMap != null ? (Synset[])subMap.get(SYNSET_KEY) : null;
    }

    public void putLexicalRelationships(String wordForm, RelationshipType type, WordSense[] senses) {
        Map subMap = this.getSubMap(wordForm, true);
        subMap.put(type, senses);
    }

    public WordSense[] getLexicalRelationships(String wordForm, RelationshipType type) {
        Map subMap = this.getSubMap(wordForm, false);
        return subMap != null ? (WordSense[])subMap.get(type) : null;
    }

    private Map getSubMap(Object sourceKey, boolean shouldCreate) {
        HashMap subMap = (HashMap)this.sourceMaps.get(sourceKey);
        if (subMap == null && shouldCreate) {
            subMap = new HashMap();
            this.sourceMaps.put(sourceKey, subMap);
        }
        return subMap;
    }
}

