/*
 * Decompiled with CFR 0.152.
 */
package edu.smu.tspell.wordnet.impl.file;

import edu.smu.tspell.wordnet.SynsetType;
import edu.smu.tspell.wordnet.impl.file.DetachmentRules;
import edu.smu.tspell.wordnet.impl.file.InflectionData;

public class Morphology {
    private static Morphology instance;

    public static synchronized Morphology getInstance() {
        if (instance == null) {
            instance = new Morphology();
        }
        return instance;
    }

    private Morphology() {
    }

    public String[] getBaseFormCandidates(String inflection, SynsetType type) {
        InflectionData inflections = InflectionData.getInstance();
        String[] exceptions = inflections.getBaseForms(inflection, type);
        DetachmentRules rules = DetachmentRules.getInstance();
        String[] detachments = rules.getCandidateForms(inflection, type);
        String[] candidates = new String[exceptions.length + detachments.length];
        System.arraycopy(exceptions, 0, candidates, 0, exceptions.length);
        System.arraycopy(detachments, 0, candidates, exceptions.length, detachments.length);
        return candidates;
    }
}

