/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import net.sf.jlinkgrammar.AndData;
import net.sf.jlinkgrammar.AndList;
import net.sf.jlinkgrammar.CList;
import net.sf.jlinkgrammar.CONList;
import net.sf.jlinkgrammar.CONNode;
import net.sf.jlinkgrammar.Clause;
import net.sf.jlinkgrammar.Cms;
import net.sf.jlinkgrammar.Connector;
import net.sf.jlinkgrammar.ConnectorSet;
import net.sf.jlinkgrammar.DISNode;
import net.sf.jlinkgrammar.DTypeList;
import net.sf.jlinkgrammar.DictNode;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.GlobalBean;
import net.sf.jlinkgrammar.ImageNode;
import net.sf.jlinkgrammar.LabelNode;
import net.sf.jlinkgrammar.Link;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.LinkageInfo;
import net.sf.jlinkgrammar.LinksToPatch;
import net.sf.jlinkgrammar.ListOfLinks;
import net.sf.jlinkgrammar.MatchNode;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.PPKnowledge;
import net.sf.jlinkgrammar.PPLinkset;
import net.sf.jlinkgrammar.PPLinksetNode;
import net.sf.jlinkgrammar.PPNode;
import net.sf.jlinkgrammar.PPRule;
import net.sf.jlinkgrammar.ParseInfo;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.ParseSet;
import net.sf.jlinkgrammar.PatchElement;
import net.sf.jlinkgrammar.Postprocessor;
import net.sf.jlinkgrammar.Sublinkage;
import net.sf.jlinkgrammar.TableConnector;
import net.sf.jlinkgrammar.Word;
import net.sf.jlinkgrammar.XNode;
import net.sf.jlinkgrammar.XTableConnector;

public class Sentence {
    public Dictionary dict;
    public ArrayList<Word> word = new ArrayList();
    public boolean[][] deletable;
    public int[][] effective_dist;
    public int num_linkages_found;
    public int num_linkages_alloced;
    public int num_linkages_post_processed;
    public int num_valid_linkages;
    public int null_count;
    public ParseInfo parse_info;
    public LinkageInfo[] link_info;
    public AndData and_data;
    public boolean q_pruned_rules;
    public int[] post_quote = new int[250];
    public PatchElement[] patch_array;
    public static boolean null_links;
    public static int ctable_size;
    public static TableConnector[] ctable;
    public static int match_cost;
    public static int[] match_l_table_size;
    public static int[] match_r_table_size;
    public static MatchNode[][] match_l_table;
    public static MatchNode[][] match_r_table;
    public static boolean structure_violation;
    public static boolean[] visited;
    public static int[] and_element_sizes;
    public static int[] and_element;
    public static int N_and_elements;
    public static int[] outside_word;
    public static int N_outside_words;
    public static boolean[] has_fat_down;
    public static ImageNode[] image_array;
    public static int s_table_size;
    public static Connector[] table;
    public static int power_cost;
    public static int power_prune_mode;
    public static int N_changed;
    public static int[] power_l_table_size;
    public static int[] power_r_table_size;
    public static CList[][] power_l_table;
    public static CList[][] power_r_table;
    public static final int CMS_SIZE = 2048;
    public static Cms[] cms_table;

    public Sentence(String input_string, Dictionary dict, ParseOptions opts) {
        dict.lookup_list = null;
        this.dict = dict;
        this.num_linkages_found = 0;
        this.num_linkages_alloced = 0;
        this.num_linkages_post_processed = 0;
        this.num_valid_linkages = 0;
        this.link_info = null;
        this.deletable = null;
        this.effective_dist = null;
        this.num_valid_linkages = 0;
        this.null_count = 0;
        this.parse_info = null;
        this.and_data = new AndData();
        if (!this.separate_sentence(input_string, opts)) {
            throw new RuntimeException("Problem: can't tokenize");
        }
        this.q_pruned_rules = false;
        this.set_is_conjunction();
        this.initialize_conjunction_tables();
        if (!(dict.unknown_word_defined && dict.use_unknown_word || this.sentence_in_dictionary())) {
            throw new RuntimeException("Problem: unknown words");
        }
        this.build_sentence_expressions(opts);
        this.patch_array = new PatchElement[497];
        for (int i = 0; i < this.patch_array.length; ++i) {
            this.patch_array[i] = new PatchElement();
        }
    }

    private boolean sentence_in_dictionary() {
        StringBuffer temp = new StringBuffer();
        boolean ok_so_far = true;
        for (int w = 0; w < this.word.size(); ++w) {
            String s = this.word.get((int)w).string;
            if (this.dict.boolean_dictionary_lookup(s) || Character.isUpperCase(s.charAt(0)) && Dictionary.is_s_word(s) && this.dict.pl_capitalized_word_defined || Character.isUpperCase(s.charAt(0)) && this.dict.capitalized_word_defined || Dictionary.ishyphenated(s) && this.dict.hyphenated_word_defined || Dictionary.is_number(s) && this.dict.number_word_defined || Dictionary.is_ing_word(s) && this.dict.ing_word_defined || Dictionary.is_s_word(s) && this.dict.s_word_defined || Dictionary.is_ed_word(s) && this.dict.ed_word_defined || Dictionary.is_ly_word(s) && this.dict.ly_word_defined) continue;
            if (ok_so_far) {
                temp.append("The following words are not in the dictionary:");
                ok_so_far = false;
            }
            temp.append(" \"");
            temp.append(this.word.get((int)w).string);
            temp.append("\"");
        }
        if (!ok_so_far) {
            throw new RuntimeException(temp.toString());
        }
        return ok_so_far;
    }

    public boolean separate_sentence(String s, ParseOptions opts) {
        int k;
        for (int i = 0; i < 250; ++i) {
            this.post_quote[i] = 0;
        }
        if (this.dict.left_wall_defined && !this.issue_sentence_word("LEFT-WALL")) {
            return false;
        }
        boolean is_first = true;
        int j = 0;
        do {
            boolean quote_found = false;
            while (j < s.length() && (Character.isWhitespace(s.charAt(j)) || s.charAt(j) == '\"')) {
                if (s.charAt(j) == '\"') {
                    quote_found = true;
                }
                ++j;
            }
            if (j >= s.length()) break;
            for (k = j; k < s.length() && !Character.isWhitespace(s.charAt(k)) && s.charAt(k) != '\"'; ++k) {
            }
            if (!this.separate_word(s.substring(j), k - j, is_first, quote_found, opts)) {
                return false;
            }
            is_first = false;
        } while ((j = k) < s.length());
        if (this.dict.right_wall_defined && !this.issue_sentence_word("RIGHT-WALL")) {
            return false;
        }
        return this.word.size() > (this.dict.left_wall_defined ? 1 : 0) + (this.dict.right_wall_defined ? 1 : 0);
    }

    private boolean separate_word(String w, int wend, boolean is_first_word, boolean quote_found, ParseOptions opts) {
        int len;
        int j;
        int i;
        int r_strippable = 0;
        int l_strippable = 0;
        int s_strippable = 0;
        int p_strippable = 0;
        int[] r_stripped = new int[10];
        String[] strip_left = null;
        String[] strip_right = null;
        String[] prefix = null;
        String[] suffix = null;
        StringBuffer word = new StringBuffer();
        StringBuffer newword = new StringBuffer();
        String rpunc_con = "RPUNC";
        String lpunc_con = "LPUNC";
        String suf_con = "SUF";
        String pre_con = "PRE";
        if (this.dict.affix_table != null) {
            DictNode start_dn;
            DictNode dn = start_dn = DictNode.list_whole_dictionary(this.dict.affix_table.root, null);
            while (dn != null) {
                if (dn.word_has_connector(rpunc_con, 0)) {
                    ++r_strippable;
                }
                if (dn.word_has_connector(lpunc_con, 0)) {
                    ++l_strippable;
                }
                if (dn.word_has_connector(suf_con, 0)) {
                    ++s_strippable;
                }
                if (dn.word_has_connector(pre_con, 0)) {
                    ++p_strippable;
                }
                dn = dn.right;
            }
            strip_right = new String[r_strippable];
            strip_left = new String[l_strippable];
            suffix = new String[s_strippable];
            prefix = new String[p_strippable];
            i = 0;
            j = 0;
            int k = 0;
            int l = 0;
            dn = start_dn;
            while (dn != null) {
                DictNode dn2;
                if (dn.word_has_connector(rpunc_con, 0)) {
                    strip_right[i] = dn.string;
                    ++i;
                }
                if (dn.word_has_connector(lpunc_con, 0)) {
                    strip_left[j] = dn.string;
                    ++j;
                }
                if (dn.word_has_connector(suf_con, 0)) {
                    suffix[k] = dn.string;
                    ++k;
                }
                if (dn.word_has_connector(pre_con, 0)) {
                    prefix[l] = dn.string;
                    ++l;
                }
                dn = dn2 = dn.right;
            }
        }
        block2: do {
            for (i = 0; i < l_strippable; ++i) {
                if (!w.startsWith((String)strip_left[i])) continue;
                if (!this.issue_sentence_word((String)strip_left[i])) {
                    return false;
                }
                w = w.substring(strip_left[i].length());
                wend -= strip_left[i].length();
                continue block2;
            }
        } while (i != l_strippable);
        for (int n_r_stripped = 0; n_r_stripped < 10 && (word = new StringBuffer(w.substring(0, wend))).length() != 0 && !this.dict.boolean_dictionary_lookup(word.toString()) && !Dictionary.is_initials_word(word.toString()); ++n_r_stripped) {
            if (is_first_word && Character.isUpperCase(word.charAt(0))) {
                word.setCharAt(0, Character.toLowerCase(word.charAt(0)));
                if (this.dict.boolean_dictionary_lookup(word.toString())) {
                    word.setCharAt(0, Character.toUpperCase(word.charAt(0)));
                    break;
                }
                word.setCharAt(0, Character.toUpperCase(word.charAt(0)));
            }
            for (i = 0; i < r_strippable; ++i) {
                len = strip_right[i].length();
                if (wend < len || !word.toString().endsWith(strip_right[i])) continue;
                r_stripped[n_r_stripped] = i;
                wend -= len;
                break;
            }
            if (i == r_strippable) break;
        }
        int s_stripped = -1;
        word = new StringBuffer(w.substring(0, wend));
        boolean word_is_in_dict = false;
        if (this.dict.boolean_dictionary_lookup(word.toString()) || Dictionary.is_initials_word(word.toString())) {
            word_is_in_dict = true;
        }
        if (is_first_word && Character.isUpperCase(word.charAt(0))) {
            word.setCharAt(0, Character.toLowerCase(word.charAt(0)));
            if (this.dict.boolean_dictionary_lookup(word.toString())) {
                word_is_in_dict = true;
            }
            word.setCharAt(0, Character.toUpperCase(word.charAt(0)));
        }
        if (!word_is_in_dict) {
            j = 0;
            for (i = 0; i <= s_strippable; ++i) {
                boolean s_ok = false;
                if (i < s_strippable) {
                    len = suffix[i].length();
                    if (wend < len) continue;
                    if (word.toString().endsWith(suffix[i])) {
                        s_ok = true;
                    }
                } else {
                    len = 0;
                }
                if (!s_ok && i != s_strippable) continue;
                newword = new StringBuffer(word.substring(0, wend - len));
                if (this.dict.boolean_dictionary_lookup(newword.toString())) {
                    if (opts.verbosity > 1 && i < s_strippable) {
                        opts.out.println("Splitting word into two: " + newword.toString() + "-" + suffix[i]);
                    }
                    s_stripped = i;
                    wend -= len;
                    word = newword;
                    break;
                }
                for (j = 0; j < p_strippable; ++j) {
                    if (!newword.toString().startsWith(prefix[j])) continue;
                    newword.delete(0, prefix[j].length());
                    if (!this.dict.boolean_dictionary_lookup(newword.toString())) continue;
                    if (opts.verbosity > 1 && i < s_strippable) {
                        opts.out.println("Splitting word into three: " + prefix[j] + "-" + newword.toString() + "-" + suffix[i]);
                    }
                    if (!this.issue_sentence_word(prefix[j])) {
                        return false;
                    }
                    if (i < s_strippable) {
                        s_stripped = i;
                    }
                    wend -= len;
                    word = newword;
                    break;
                }
                if (j != p_strippable) break;
            }
        }
        if (quote_found) {
            this.post_quote[this.word.size()] = 1;
        }
        if (!this.issue_sentence_word(word.toString())) {
            return false;
        }
        if (s_stripped != -1 && !this.issue_sentence_word(suffix[s_stripped])) {
            return false;
        }
        for (i = n_r_stripped - 1; i >= 0; --i) {
            if (this.issue_sentence_word(strip_right[r_stripped[i]])) continue;
            return false;
        }
        return true;
    }

    private boolean issue_sentence_word(String s) {
        if (s.length() == 0) {
            return true;
        }
        if (s.length() > 60) {
            throw new RuntimeException(". The word \"" + s + "\" is too long.\n" + "A word can have a maximum of " + 60 + " characters.\n");
        }
        if (this.word.size() == 250) {
            throw new RuntimeException(". The sentence has too many words.\n");
        }
        this.word.add(new Word(s, this.dict));
        this.word.get((int)(this.word.size() - 1)).firstupper = Character.isUpperCase(s.charAt(0));
        return true;
    }

    public void build_sentence_expressions(ParseOptions opts) {
        int first_word = this.dict.left_wall_defined ? 1 : 0;
        for (int i = 0; i < this.word.size(); ++i) {
            XNode e;
            String s;
            if (i != first_word && (i <= 0 || !":".equals(this.word.get((int)(i - 1)).string)) && this.post_quote[i] != 1 || !Character.isUpperCase((s = this.word.get((int)i).string).charAt(0))) continue;
            StringBuffer temp_word = new StringBuffer(s);
            temp_word.setCharAt(0, Character.toLowerCase(temp_word.charAt(0)));
            String u = temp_word.toString();
            if (!this.dict.boolean_dictionary_lookup(u)) continue;
            if (this.dict.boolean_dictionary_lookup(s)) {
                e = Word.build_word_expressions(u, this.dict);
                this.word.get((int)i).x = XNode.catenate_XNodes(this.word.get((int)i).x, e);
                continue;
            }
            temp_word = new StringBuffer(s);
            temp_word.setCharAt(0, Character.toLowerCase(temp_word.charAt(0)));
            this.word.get((int)i).string = temp_word.toString();
            this.word.get((int)i).x = e = Word.build_word_expressions(this.word.get((int)i).string, this.dict);
        }
    }

    public int size() {
        return this.word.size();
    }

    public void initialize_conjunction_tables() {
        this.and_data.LT_bound = 0;
        this.and_data.LT_size = 0;
        this.and_data.label_table = null;
        for (int i = 0; i < 1024; ++i) {
            this.and_data.hash_table[i] = null;
        }
    }

    public void set_is_conjunction() {
        for (int w = 0; w < this.word.size(); ++w) {
            String s = this.word.get((int)w).string;
            this.word.get((int)w).is_conjunction = s.equals("and") || s.equals("or") || s.equals("but") || s.equals("nor");
        }
    }

    public int sentence_length() {
        return this.word.size();
    }

    public void prepare_to_parse(ParseOptions opts) {
        int i;
        this.build_sentence_disjuncts(opts, opts.disjunct_cost);
        if (opts.verbosity > 2) {
            opts.out.println("After expanding expressions into disjuncts:");
            this.print_disjunct_counts(opts);
        }
        opts.print_time("Built disjuncts");
        for (i = 0; i < this.word.size(); ++i) {
            this.word.get((int)i).d = Disjunct.eliminate_duplicate_disjuncts(opts, this.word.get((int)i).d);
        }
        opts.print_time("Eliminated duplicate disjuncts");
        if (opts.verbosity > 2) {
            opts.out.println();
            opts.out.println("After expression pruning and duplicate elimination:");
            this.print_disjunct_counts(opts);
        }
        null_links = opts.min_null_count > 0;
        boolean has_conjunction = this.sentence_contains_conjunction();
        this.set_connector_length_limits(opts);
        this.build_deletable(has_conjunction);
        this.build_effective_dist(has_conjunction);
        if (!has_conjunction) {
            this.pp_and_power_prune(0, opts);
        } else {
            this.pp_and_power_prune(1, opts);
            this.conjunction_prune(opts);
            if (opts.verbosity > 2) {
                opts.out.println();
                opts.out.println("After conjunction pruning:");
                this.print_disjunct_counts(opts);
            }
            opts.print_time("Done conjunction pruning");
            this.build_conjunction_tables();
            this.install_fat_connectors();
            this.install_special_conjunctive_connectors();
            this.checkDuplicate("5");
            if (opts.verbosity > 2) {
                opts.out.print("After conjunctions, disjuncts counts:");
                this.print_disjunct_counts(opts);
            }
            this.set_connector_length_limits(opts);
            this.checkDuplicate("6");
            opts.print_time("Constructed fat disjuncts");
            this.prune(opts);
            this.checkDuplicate("7");
            opts.print_time("Pruned fat disjuncts");
            for (i = 0; i < this.word.size(); ++i) {
                this.word.get((int)i).d = Disjunct.eliminate_duplicate_disjuncts(opts, this.word.get((int)i).d);
            }
            if (opts.verbosity > 2) {
                opts.out.println("After pruning and duplicate elimination:");
                this.print_disjunct_counts(opts);
            }
            opts.print_time("Eliminated duplicate disjuncts (again)");
            if (opts.verbosity > 2) {
                this.print_AND_statistics(opts);
            }
            this.power_prune(0, opts);
        }
    }

    private void checkDuplicate(String label) {
        HashSet<Disjunct> disj = new HashSet<Disjunct>();
        HashSet<Connector> conn = new HashSet<Connector>();
        for (int i = 0; i < this.word.size(); ++i) {
            Disjunct d = this.word.get((int)i).d;
            while (d != null) {
                if (disj.contains(d)) {
                    throw new RuntimeException(label + " dup disj w=" + this.word.get(i) + " d=" + d.string);
                }
                disj.add(d);
                Connector c = d.left;
                while (c != null) {
                    if (conn.contains(c)) {
                        throw new RuntimeException(label + " dup conn w=" + this.word.get(i) + " d=" + d.string + " c=" + c.string + "-");
                    }
                    conn.add(c);
                    c = c.next;
                }
                c = d.right;
                while (c != null) {
                    if (conn.contains(c)) {
                        throw new RuntimeException(label + " dup conn w=" + this.word.get(i) + " d=" + d.string + " c=" + c.string + "+");
                    }
                    conn.add(c);
                    c = c.next;
                }
                d = d.next;
            }
        }
    }

    public void conjunction_prune(ParseOptions opts) {
        Disjunct d;
        int w;
        for (w = 0; w < this.word.size(); ++w) {
            d = this.word.get((int)w).d;
            while (d != null) {
                d.marked = false;
                d = d.next;
            }
        }
        this.init_fast_matcher();
        this.init_table();
        boolean bl = null_links = opts.min_null_count > 0;
        if (null_links) {
            this.mark_region(-1, this.word.size(), null, null);
        } else {
            for (w = 0; w < this.word.size(); ++w) {
                if (!this.deletable[0][w]) continue;
                d = this.word.get((int)w).d;
                while (d != null) {
                    if (d.left == null && this.region_valid(w, this.word.size(), d.right, null) > 0) {
                        this.mark_region(w, this.word.size(), d.right, null);
                        d.marked = true;
                    }
                    d = d.next;
                }
            }
        }
        this.delete_unmarked_disjuncts();
        if (opts.verbosity > 1) {
            opts.out.println("" + match_cost + " Match cost");
        }
    }

    public int region_valid(int lw, int rw, Connector le, Connector re) {
        boolean left_valid = false;
        boolean right_valid = false;
        int i = Sentence.table_lookup(lw, rw, le, re, 0);
        if (i >= 0) {
            return i;
        }
        if (le == null && re == null && this.deletable[lw + 1][rw]) {
            Sentence.table_store(lw, rw, le, re, 0, 1);
            return 1;
        }
        int start_word = le == null ? lw + 1 : le.word;
        int end_word = re == null ? rw - 1 : re.word;
        int found = 0;
        for (int w = start_word; w <= end_word; ++w) {
            MatchNode m = Sentence.form_match_list(w, le, lw, re, rw);
            while (m != null) {
                Disjunct d = m.d;
                boolean bl = left_valid = le != null && d.left != null && Connector.prune_match(this, le, d.left, lw, w) && (this.region_valid(lw, w, le.next, d.left.next) > 0 || le.multi && this.region_valid(lw, w, le, d.left.next) > 0 || d.left.multi && this.region_valid(lw, w, le.next, d.left) > 0 || le.multi && d.left.multi && this.region_valid(lw, w, le, d.left) > 0);
                if (left_valid && this.region_valid(w, rw, d.right, re) > 0) {
                    found = 1;
                    break;
                }
                boolean bl2 = right_valid = d.right != null && re != null && Connector.prune_match(this, d.right, re, w, rw) && (this.region_valid(w, rw, d.right.next, re.next) > 0 || d.right.multi && this.region_valid(w, rw, d.right, re.next) > 0 || re.multi && this.region_valid(w, rw, d.right.next, re) > 0 || d.right.multi && re.multi && this.region_valid(w, rw, d.right, re) > 0);
                if (left_valid && right_valid || right_valid && this.region_valid(lw, w, le, d.left) > 0) {
                    found = 1;
                    break;
                }
                m = m.next;
            }
            if (found != 0) break;
        }
        Sentence.table_store(lw, rw, le, re, 0, found);
        return found;
    }

    public static MatchNode form_match_list(int w, Connector lc, int lw, Connector rc, int rw) {
        MatchNode my;
        MatchNode ml = lc != null ? match_l_table[w][Sentence.fast_match_hash(lc) & match_l_table_size[w] - 1] : null;
        MatchNode mr = rc != null ? match_r_table[w][Sentence.fast_match_hash(rc) & match_r_table_size[w] - 1] : null;
        MatchNode front = null;
        MatchNode mx = ml;
        while (mx != null && mx.d.left.word >= lw) {
            my = Sentence.get_match_node();
            my.d = mx.d;
            my.next = front;
            front = my;
            mx = mx.next;
        }
        ml = front;
        front = null;
        mx = mr;
        while (mx != null && mx.d.right.word <= rw) {
            my = Sentence.get_match_node();
            my.d = mx.d;
            my.next = front;
            front = my;
            mx = mx.next;
        }
        mr = front;
        MatchNode free_later = null;
        front = null;
        mx = mr;
        while (mx != null) {
            MatchNode mz = mx.next;
            ++match_cost;
            my = ml;
            while (my != null) {
                ++match_cost;
                if (mx.d == my.d) break;
                my = my.next;
            }
            if (my != null) {
                mx.next = free_later;
                free_later = mx;
            }
            if (my == null) {
                mx.next = front;
                front = mx;
            }
            mx = mz;
        }
        mr = front;
        if (mr == null) {
            return ml;
        }
        mx = mr;
        while (mx.next != null) {
            mx = mx.next;
        }
        mx.next = ml;
        return mr;
    }

    static MatchNode get_match_node() {
        return new MatchNode();
    }

    void table_update(int lw, int rw, Connector le, Connector re, int cost, int count) {
        TableConnector t = Sentence.table_pointer(lw, rw, le, re, cost);
        if (t == null) {
            throw new RuntimeException("This entry is supposed to be in the table.");
        }
        t.count = count;
    }

    void mark_region(int lw, int rw, Connector le, Connector re) {
        int i = this.region_valid(lw, rw, le, re);
        if (i == 0 || i == 2) {
            return;
        }
        this.table_update(lw, rw, le, re, 0, 2);
        if (le == null && re == null && null_links && rw != 1 + lw) {
            int w = lw + 1;
            Disjunct d = this.word.get((int)w).d;
            while (d != null) {
                if (d.left == null && this.region_valid(w, rw, d.right, null) > 0) {
                    d.marked = true;
                    this.mark_region(w, rw, d.right, null);
                }
                d = d.next;
            }
            this.mark_region(w, rw, null, null);
            return;
        }
        int start_word = le == null ? lw + 1 : le.word;
        int end_word = re == null ? rw - 1 : re.word;
        for (int w = start_word; w <= end_word; ++w) {
            MatchNode m = Sentence.form_match_list(w, le, lw, re, rw);
            while (m != null) {
                boolean right_valid;
                Disjunct d = m.d;
                boolean left_valid = le != null && d.left != null && Connector.prune_match(this, le, d.left, lw, w) && (this.region_valid(lw, w, le.next, d.left.next) > 0 || le.multi && this.region_valid(lw, w, le, d.left.next) > 0 || d.left.multi && this.region_valid(lw, w, le.next, d.left) > 0 || le.multi && d.left.multi && this.region_valid(lw, w, le, d.left) > 0);
                boolean bl = right_valid = d.right != null && re != null && Connector.prune_match(this, d.right, re, w, rw) && (this.region_valid(w, rw, d.right.next, re.next) > 0 || d.right.multi && this.region_valid(w, rw, d.right, re.next) > 0 || re.multi && this.region_valid(w, rw, d.right.next, re) > 0 || d.right.multi && re.multi && this.region_valid(w, rw, d.right, re) > 0);
                if (left_valid && this.region_valid(w, rw, d.right, re) > 0) {
                    d.marked = true;
                    this.mark_region(w, rw, d.right, re);
                    this.mark_region(lw, w, le.next, d.left.next);
                    if (le.multi) {
                        this.mark_region(lw, w, le, d.left.next);
                    }
                    if (d.left.multi) {
                        this.mark_region(lw, w, le.next, d.left);
                    }
                    if (le.multi && d.left.multi) {
                        this.mark_region(lw, w, le, d.left);
                    }
                }
                if (right_valid && this.region_valid(lw, w, le, d.left) > 0) {
                    d.marked = true;
                    this.mark_region(lw, w, le, d.left);
                    this.mark_region(w, rw, d.right.next, re.next);
                    if (d.right.multi) {
                        this.mark_region(w, rw, d.right, re.next);
                    }
                    if (re.multi) {
                        this.mark_region(w, rw, d.right.next, re);
                    }
                    if (d.right.multi && re.multi) {
                        this.mark_region(w, rw, d.right, re);
                    }
                }
                if (left_valid && right_valid) {
                    d.marked = true;
                    this.mark_region(lw, w, le.next, d.left.next);
                    if (le.multi) {
                        this.mark_region(lw, w, le, d.left.next);
                    }
                    if (d.left.multi) {
                        this.mark_region(lw, w, le.next, d.left);
                    }
                    if (le.multi && d.left.multi) {
                        this.mark_region(lw, w, le, d.left);
                    }
                    this.mark_region(w, rw, d.right.next, re.next);
                    if (d.right.multi) {
                        this.mark_region(w, rw, d.right, re.next);
                    }
                    if (re.multi) {
                        this.mark_region(w, rw, d.right.next, re);
                    }
                    if (d.right.multi && re.multi) {
                        this.mark_region(w, rw, d.right, re);
                    }
                }
                m = m.next;
            }
        }
    }

    Disjunct explode_disjunct_list(Disjunct d) {
        Disjunct d1 = null;
        while (d != null) {
            d1 = Disjunct.catenate_disjuncts(d1, this.build_fat_link_substitutions(d));
            d = d.next;
        }
        return d1;
    }

    Disjunct build_COMMA_disjunct_list() {
        Connector work_connector1 = new Connector();
        Connector work_connector2 = new Connector();
        Connector work_connector3 = new Connector();
        Connector c1 = work_connector1;
        c1.init_connector();
        Connector c2 = work_connector2;
        c2.init_connector();
        Connector c3 = work_connector3;
        c3.init_connector();
        Disjunct wd = new Disjunct();
        Disjunct d1 = null;
        c1.next = null;
        c2.next = c3;
        c3.next = null;
        c3.priority = 2;
        c1.priority = 2;
        c2.priority = 1;
        c3.multi = false;
        c2.multi = false;
        c1.multi = false;
        wd.left = c1;
        wd.right = c2;
        wd.string = ",";
        wd.next = null;
        wd.cost = 0;
        for (int lab = 0; lab < this.and_data.LT_size; ++lab) {
            Disjunct d = this.and_data.label_table[lab];
            while (d != null) {
                c2.string = c3.string = d.string;
                c1.string = c3.string;
                c2.label = c3.label = lab;
                c1.label = c3.label;
                Disjunct d2 = Disjunct.copy_disjunct(wd);
                d2.next = d1;
                d1 = d2;
                d = d.next;
            }
        }
        return d1;
    }

    void install_fat_connectors() {
        for (int i = 0; i < this.word.size(); ++i) {
            if (this.word.get((int)i).is_conjunction) {
                this.word.get((int)i).d = Disjunct.catenate_disjuncts(this.word.get((int)i).d, this.build_AND_disjunct_list(this.word.get((int)i).string));
                continue;
            }
            this.word.get((int)i).d = Disjunct.catenate_disjuncts(this.word.get((int)i).d, this.explode_disjunct_list(this.word.get((int)i).d));
            if (!this.word.get((int)i).string.equals(",")) continue;
            this.word.get((int)i).d = Disjunct.catenate_disjuncts(this.word.get((int)i).d, this.build_COMMA_disjunct_list());
        }
    }

    Disjunct build_fat_link_substitutions(Disjunct d) {
        Disjunct d1;
        Connector tr;
        Connector work_connector = new Connector();
        Disjunct work_disjunct = new Disjunct();
        if (d == null) {
            return null;
        }
        Disjunct wd = work_disjunct;
        Connector wc = work_connector;
        wc.init_connector();
        Disjunct d_list = null;
        wd.next = d.next;
        wd.cost = d.cost;
        wd.marked = d.marked;
        wd.string = d.string;
        wd.left = d.left;
        wd.right = d.right;
        Connector tl = d.left;
        d.left = null;
        Connector cr = d.right;
        while (cr != null) {
            tr = cr.next;
            cr.next = null;
            if (this.is_appropriate(d)) {
                this.connector_for_disjunct(d, wc);
                wd.left = tl;
                wd.right = wc;
                wc.next = tr;
                d1 = Disjunct.copy_disjunct(wd);
                d1.next = d_list;
                d_list = d1;
                wd.left = wc;
                wc.next = tl;
                wd.right = tr;
                d1 = Disjunct.copy_disjunct(wd);
                d1.next = d_list;
                d_list = d1;
            }
            cr = cr.next = tr;
        }
        d.left = tl;
        tr = d.right;
        d.right = null;
        Connector cl = d.left;
        while (cl != null) {
            tl = cl.next;
            cl.next = null;
            if (this.is_appropriate(d)) {
                this.connector_for_disjunct(d, wc);
                wd.left = tl;
                wd.right = wc;
                wc.next = tr;
                d1 = Disjunct.copy_disjunct(wd);
                d1.next = d_list;
                d_list = d1;
                wd.left = wc;
                wc.next = tl;
                wd.right = tr;
                d1 = Disjunct.copy_disjunct(wd);
                d1.next = d_list;
                d_list = d1;
            }
            cl = cl.next = tl;
        }
        d.right = tr;
        cl = d.left;
        while (cl != null) {
            cr = d.right;
            while (cr != null) {
                tl = cl.next;
                tr = cr.next;
                cr.next = null;
                cl.next = null;
                if (this.is_appropriate(d)) {
                    this.connector_for_disjunct(d, wc);
                    wd.left = tl;
                    wd.right = wc;
                    wc.next = tr;
                    d1 = Disjunct.copy_disjunct(wd);
                    d1.next = d_list;
                    d_list = d1;
                    wd.left = wc;
                    wc.next = tl;
                    wd.right = tr;
                    d1 = Disjunct.copy_disjunct(wd);
                    d1.next = d_list;
                    d_list = d1;
                }
                cl.next = tl;
                cr = cr.next = tr;
            }
            cl = cl.next;
        }
        return d_list;
    }

    public void connector_for_disjunct(Disjunct d, Connector c) {
        Disjunct d1 = null;
        int h = d.and_hash_disjunct();
        LabelNode lp = this.and_data.hash_table[h];
        while (lp != null && !d.disjunct_types_equal(d1 = this.and_data.label_table[lp.label])) {
            lp = lp.next;
        }
        if (lp == null) {
            throw new RuntimeException("A disjunct I inserted was not there. (1)");
        }
        while (d1 != null && !d1.disjuncts_equal_AND(d)) {
            d1 = d1.next;
        }
        if (d1 == null) {
            throw new RuntimeException("A disjunct I inserted was not there. (2)");
        }
        c.label = lp.label;
        c.string = d1.string;
        c.priority = 1;
        c.multi = false;
    }

    public Disjunct build_AND_disjunct_list(String s) {
        Disjunct d_list;
        block20: {
            Connector c1;
            Disjunct d1;
            block19: {
                d_list = null;
                for (int lab = 0; lab < this.and_data.LT_size; ++lab) {
                    Disjunct d = this.and_data.label_table[lab];
                    while (d != null) {
                        d1 = this.build_fat_link_substitutions(d);
                        Disjunct d_copy = Disjunct.copy_disjunct(d);
                        d_copy.next = d1;
                        d1 = d_copy;
                        while (d1 != null) {
                            Connector c3;
                            Disjunct d3 = d1.next;
                            c1 = new Connector();
                            c1.init_connector();
                            Connector c2 = new Connector();
                            c2.init_connector();
                            c1.next = null;
                            c2.next = null;
                            c2.priority = 2;
                            c1.priority = 2;
                            c2.multi = false;
                            c1.multi = false;
                            c1.string = c2.string = d.string;
                            c1.label = c2.label = lab;
                            d1.string = s;
                            if (d1.right == null) {
                                d1.right = c2;
                            } else {
                                c3 = d1.right;
                                while (c3.next != null) {
                                    c3 = c3.next;
                                }
                                c3.next = c2;
                            }
                            if (d1.left == null) {
                                d1.left = c1;
                            } else {
                                c3 = d1.left;
                                while (c3.next != null) {
                                    c3 = c3.next;
                                }
                                c3.next = c1;
                            }
                            d1.next = d_list;
                            d_list = d1;
                            d1 = d3;
                        }
                        d = d.next;
                    }
                }
                if (!s.equals("and")) break block19;
                d1 = d_list;
                while (d1 != null) {
                    c1 = d1.right;
                    while (c1 != null) {
                        if (c1.string.length() >= 1 && c1.string.charAt(0) == 'S' && (c1.string.length() == 1 || c1.string.charAt(1) == '^' || c1.string.charAt(1) == 's' || c1.string.charAt(1) == 'p')) {
                            c1.string = "Sp";
                        }
                        c1 = c1.next;
                    }
                    c1 = d1.left;
                    while (c1 != null) {
                        if (c1.string.length() >= 2 && c1.string.charAt(0) == 'S' && c1.string.charAt(1) == 'I' && (c1.string.length() == 2 || c1.string.charAt(2) == '^' || c1.string.charAt(2) == 's' || c1.string.charAt(2) == 'p')) {
                            c1.string = "SIp";
                        }
                        c1 = c1.next;
                    }
                    d1 = d1.next;
                }
                break block20;
            }
            if (!s.equals("nor") && !s.equals("or")) break block20;
            d1 = d_list;
            while (d1 != null) {
                c1 = d1.right;
                while (c1 != null) {
                    if (c1.string.length() >= 2 && c1.string.charAt(0) == 'S' && (c1.string.charAt(1) == '^' || c1.string.charAt(1) == 's' || c1.string.charAt(1) == 'p')) {
                        c1.string = "S";
                    }
                    c1 = c1.next;
                }
                c1 = d1.left;
                while (c1 != null) {
                    if (c1.string.length() >= 3 && c1.string.charAt(0) == 'S' && c1.string.charAt(1) == 'I' && (c1.string.charAt(2) == '^' || c1.string.charAt(2) == 's' || c1.string.charAt(2) == 'p')) {
                        c1.string = "SI";
                    }
                    c1 = c1.next;
                }
                d1 = d1.next;
            }
        }
        return d_list;
    }

    public void build_conjunction_tables() {
        this.init_HT();
        this.init_LT();
        GlobalBean.STAT_calls_to_equality_test = 0;
        GlobalBean.STAT_N_disjuncts = 0;
        for (int w = 0; w < this.word.size(); ++w) {
            Disjunct d = this.word.get((int)w).d;
            while (d != null) {
                this.extract_all_fat_links(d);
                d = d.next;
            }
        }
        for (int k = 0; k < this.and_data.LT_size; ++k) {
            this.compute_matchers_for_a_label(k);
        }
    }

    public void compute_matchers_for_a_label(int k) {
        int i;
        Disjunct d = this.and_data.label_table[k];
        int N_connectors = 0;
        Connector c = d.left;
        while (c != null) {
            ++N_connectors;
            c = c.next;
        }
        c = d.right;
        while (c != null) {
            ++N_connectors;
            c = c.next;
        }
        int[] lengths = new int[N_connectors];
        for (i = 0; i < N_connectors; ++i) {
            lengths[i] = 0;
        }
        while (d != null) {
            int j;
            String s;
            i = 0;
            c = d.left;
            while (c != null) {
                s = c.string;
                for (j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
                }
                j = s.length() - j;
                if (j > lengths[i]) {
                    lengths[i] = j;
                }
                ++i;
                c = c.next;
            }
            c = d.right;
            while (c != null) {
                s = c.string;
                for (j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
                }
                j = s.length() - j;
                if (j > lengths[i]) {
                    lengths[i] = j;
                }
                ++i;
                c = c.next;
            }
            d = d.next;
        }
        int tot_len = 0;
        for (i = 0; i < N_connectors; ++i) {
            tot_len += lengths[i] + 1;
        }
        d = this.and_data.label_table[k];
        while (d != null) {
            i = 0;
            StringBuffer os = new StringBuffer(tot_len);
            c = d.left;
            while (c != null) {
                this.stick_in_one_connector(os, c, lengths[i]);
                ++i;
                c = c.next;
            }
            c = d.right;
            while (c != null) {
                this.stick_in_one_connector(os, c, lengths[i]);
                ++i;
                c = c.next;
            }
            d.string = os.toString();
            d = d.next;
        }
    }

    public void stick_in_one_connector(StringBuffer s, Connector c, int len) {
        int i;
        for (i = 0; i < c.string.length() && Character.isUpperCase(c.string.charAt(i)); ++i) {
        }
        while (i < c.string.length()) {
            s.append(c.string.charAt(i));
            ++i;
            --len;
        }
        while (len > 0) {
            s.append('*');
            --len;
        }
        if (c.multi) {
            s.append('*');
        } else {
            s.append('^');
        }
    }

    public void extract_all_fat_links(Disjunct d) {
        Connector tr;
        Connector tl = d.left;
        d.left = null;
        Connector cr = d.right;
        while (cr != null) {
            tr = cr.next;
            cr.next = null;
            if (this.is_appropriate(d)) {
                this.put_disjunct_into_table(d);
            }
            cr = cr.next = tr;
        }
        d.left = tl;
        tr = d.right;
        d.right = null;
        Connector cl = d.left;
        while (cl != null) {
            tl = cl.next;
            cl.next = null;
            if (this.is_appropriate(d)) {
                this.put_disjunct_into_table(d);
            }
            cl = cl.next = tl;
        }
        d.right = tr;
        cl = d.left;
        while (cl != null) {
            cr = d.right;
            while (cr != null) {
                tl = cl.next;
                tr = cr.next;
                cr.next = null;
                cl.next = null;
                if (this.is_appropriate(d)) {
                    this.put_disjunct_into_table(d);
                }
                cl.next = tl;
                cr = cr.next = tr;
            }
            cl = cl.next;
        }
    }

    public void put_disjunct_into_table(Disjunct d) {
        Disjunct d1 = null;
        int h = d.and_hash_disjunct();
        LabelNode lp = this.and_data.hash_table[h];
        while (lp != null && !d.disjunct_types_equal(d1 = this.and_data.label_table[lp.label])) {
            lp = lp.next;
        }
        if (lp != null) {
            Disjunct di;
            while (d1 != null) {
                if (d1.disjuncts_equal_AND(d)) {
                    return;
                }
                d1 = d1.next;
            }
            Disjunct d_copy = Disjunct.copy_disjunct(d);
            d_copy.cost = 0;
            int k = lp.label;
            Disjunct d2 = null;
            d1 = this.and_data.label_table[k];
            while (d1 != null) {
                di = d_copy.intersect_disjuncts(d1);
                di.next = d2;
                d2 = di;
                d1 = d1.next;
            }
            d_copy.next = this.and_data.label_table[k];
            this.and_data.label_table[k] = d_copy;
            while (d2 != null) {
                di = d2.next;
                d1 = this.and_data.label_table[k];
                while (d1 != null && !d1.disjuncts_equal_AND(d2)) {
                    d1 = d1.next;
                }
                if (d1 == null) {
                    ++GlobalBean.STAT_N_disjuncts;
                    d2.next = this.and_data.label_table[k];
                    this.and_data.label_table[k] = d2;
                } else {
                    d2.next = null;
                }
                d2 = di;
            }
        } else {
            Disjunct d_copy = Disjunct.copy_disjunct(d);
            d_copy.cost = 0;
            d_copy.next = null;
            if (this.and_data.LT_size == this.and_data.LT_bound) {
                this.grow_LT();
            }
            lp = new LabelNode();
            lp.next = this.and_data.hash_table[h];
            this.and_data.hash_table[h] = lp;
            lp.label = this.and_data.LT_size;
            this.and_data.label_table[this.and_data.LT_size] = d_copy;
            ++this.and_data.LT_size;
            ++GlobalBean.STAT_N_disjuncts;
        }
    }

    void grow_LT() {
        this.and_data.LT_bound = 3 * this.and_data.LT_bound / 2;
        Disjunct[] old = this.and_data.label_table;
        this.and_data.label_table = new Disjunct[this.and_data.LT_bound];
        System.arraycopy(old, 0, this.and_data.label_table, 0, old.length);
    }

    public boolean is_appropriate(Disjunct d) {
        if (this.dict.andable_connector_set == null) {
            return true;
        }
        Connector c = d.right;
        while (c != null) {
            if (!c.match_in_connector_set(this, this.dict.andable_connector_set, 43)) {
                return false;
            }
            c = c.next;
        }
        c = d.left;
        while (c != null) {
            if (!c.match_in_connector_set(this, this.dict.andable_connector_set, 45)) {
                return false;
            }
            c = c.next;
        }
        return true;
    }

    public void init_HT() {
        for (int i = 0; i < 1024; ++i) {
            this.and_data.hash_table[i] = null;
        }
    }

    public void init_LT() {
        this.and_data.LT_bound = 20;
        this.and_data.LT_size = 0;
        this.and_data.label_table = new Disjunct[this.and_data.LT_bound];
    }

    public void print_AND_statistics(ParseOptions opts) {
        opts.out.println("Number of disjunct types (labels): " + this.and_data.LT_size);
        opts.out.println("Number of disjuncts in the table: " + GlobalBean.STAT_N_disjuncts);
        if (this.and_data.LT_size != 0) {
            opts.out.println("average list word.size(): " + (float)GlobalBean.STAT_N_disjuncts / (float)this.and_data.LT_size);
        }
        opts.out.println("Number of equality tests: " + GlobalBean.STAT_calls_to_equality_test);
    }

    public void build_effective_dist(boolean has_conjunction) {
        int j;
        int i;
        this.effective_dist = new int[this.word.size()][];
        for (i = 0; i < this.word.size(); ++i) {
            this.effective_dist[i] = new int[this.word.size() + 1];
        }
        for (i = 0; i < this.word.size(); ++i) {
            for (j = 0; j <= i; ++j) {
                this.effective_dist[i][j] = j - i;
            }
        }
        if (null_links) {
            for (i = 0; i < this.word.size(); ++i) {
                for (j = 0; j <= this.word.size(); ++j) {
                    this.effective_dist[i][j] = j - i;
                }
            }
        } else {
            for (int diff = 1; diff < this.word.size(); ++diff) {
                i = 0;
                while (i + diff <= this.word.size()) {
                    j = i + diff;
                    this.effective_dist[i][j] = this.deletable[i + 1][j] ? 1 : 1 + Math.min(this.effective_dist[i][j - 1], this.effective_dist[i + 1][j]);
                    ++i;
                }
            }
            for (i = 0; i < this.word.size(); ++i) {
                for (j = i + 1; j < this.word.size(); ++j) {
                    if (!this.word.get((int)i).is_conjunction && !this.word.get((int)j).is_conjunction) continue;
                    this.effective_dist[i][j] = 1;
                }
            }
        }
    }

    public void build_deletable(boolean has_conjunction) {
        if (this.word.size() >= 250) {
            throw new RuntimeException("sent.word.size() too big");
        }
        this.deletable = new boolean[this.word.size() + 1][];
        for (int i = -1; i < this.word.size(); ++i) {
            this.deletable[i + 1] = new boolean[this.word.size() + 1];
            for (int j = 0; j <= this.word.size(); ++j) {
                if (j == i + 1) {
                    this.deletable[i + 1][j] = true;
                    continue;
                }
                if (null_links) {
                    this.deletable[i + 1][j] = true;
                    continue;
                }
                if (!has_conjunction) {
                    this.deletable[i + 1][j] = false;
                    continue;
                }
                if (j > i + 2 && (this.word.get((int)(i + 1)).is_conjunction || this.word.get((int)(j - 1)).is_conjunction || this.word.get((int)(i + 1)).string.equals(",") && this.conj_in_range(i + 2, j - 1) || this.word.get((int)(j - 1)).string.equals(",") && this.conj_in_range(j, this.word.size() - 1))) {
                    this.deletable[i + 1][j] = true;
                    continue;
                }
                if (j > i) {
                    int k;
                    for (k = i + 1; k < j && ("either".equals(this.word.get((int)k).string) || "neither".equals(this.word.get((int)k).string) || "both".equals(this.word.get((int)k).string) || "not".equals(this.word.get((int)k).string) || "only".equals(this.word.get((int)k).string) && k > i + 1 && "not".equals(this.word.get((int)(k - 1)).string)); ++k) {
                    }
                    this.deletable[i + 1][j] = k == j;
                    continue;
                }
                this.deletable[i + 1][j] = false;
            }
        }
    }

    public boolean conj_in_range(int lw, int rw) {
        while (lw <= rw) {
            if (this.word.get((int)lw).is_conjunction) {
                return true;
            }
            ++lw;
        }
        return false;
    }

    private void set_connector_length_limits(ParseOptions opts) {
        int len = opts.short_length;
        if (len > 255) {
            len = 255;
        }
        for (int i = 0; i < this.word.size(); ++i) {
            Disjunct d = this.word.get((int)i).d;
            while (d != null) {
                this.set_connector_list_length_limit(d.left, this.dict.unlimited_connector_set, len, opts);
                this.set_connector_list_length_limit(d.right, this.dict.unlimited_connector_set, len, opts);
                d = d.next;
            }
        }
    }

    private void set_connector_list_length_limit(Connector c, ConnectorSet conset, int short_len, ParseOptions opts) {
        while (c != null) {
            c.length_limit = opts.parse_options_get_all_short_connectors() ? short_len : (conset == null || c.match_in_connector_set(this, conset, 43) ? 255 : short_len);
            c = c.next;
        }
    }

    public int sentence_parse(ParseOptions opts) {
        this.expression_prune(opts);
        opts.print_time("Finished expression pruning");
        this.prepare_to_parse(opts);
        this.init_fast_matcher();
        this.init_table();
        opts.print_time("Initialized fast matcher and hash table");
        this.free_parse_set();
        this.init_x_table();
        int nl = opts.min_null_count;
        while (nl <= opts.max_null_count) {
            this.null_count = nl++;
            this.num_linkages_found = this.parse(this.null_count, opts);
            opts.print_time("Counted parses");
            this.post_process_linkages(opts);
            if (this.num_valid_linkages > 0) break;
        }
        if (opts.verbosity > 1) {
            opts.out.println("" + match_cost + " Match cost");
        }
        opts.print_time("Finished parse");
        return this.num_valid_linkages;
    }

    public int parse(int cost, ParseOptions opts) {
        int total = this.count(-1, this.word.size(), null, null, cost + 1, opts);
        if (opts.verbosity > 1) {
            opts.out.println("Total count with " + cost + " null links:   " + total);
        }
        if (total < 0) {
            opts.out.println("WARNING: Overflow in count!");
        }
        return total;
    }

    public int count(int lw, int rw, Connector le, Connector re, int cost, ParseOptions opts) {
        if (cost < 0) {
            return 0;
        }
        TableConnector t = Sentence.table_pointer(lw, rw, le, re, cost);
        if (t != null) {
            return t.count;
        }
        t = Sentence.table_store(lw, rw, le, re, cost, 0);
        if (rw == 1 + lw) {
            t.count = le == null && re == null && cost == 0 ? 1 : 0;
            return t.count;
        }
        if (le == null && re == null) {
            if (!opts.islands_ok && lw != -1) {
                t.count = cost == (rw - lw - 1 + opts.null_block - 1) / opts.null_block ? 1 : 0;
                return t.count;
            }
            if (cost == 0) {
                t.count = 0;
            } else {
                int total = 0;
                int w = lw + 1;
                Disjunct d = this.word.get((int)w).d;
                while (d != null) {
                    if (d.left == null) {
                        total += this.count(w, rw, d.right, null, cost - 1, opts);
                    }
                    d = d.next;
                }
                t.count = total += this.count(w, rw, null, null, cost - 1, opts);
            }
            return t.count;
        }
        int start_word = le == null ? lw + 1 : le.word;
        int end_word = re == null ? rw - 1 : re.word;
        int total = 0;
        for (int w = start_word; w <= end_word; ++w) {
            MatchNode m = Sentence.form_match_list(w, le, lw, re, rw);
            while (m != null) {
                Disjunct d = m.d;
                for (int lcost = 0; lcost <= cost; ++lcost) {
                    int rcost = cost - lcost;
                    boolean Lmatch = le != null && d.left != null && Connector.match(this, le, d.left, lw, w);
                    boolean Rmatch = d.right != null && re != null && Connector.match(this, d.right, re, w, rw);
                    int leftcount = 0;
                    int rightcount = 0;
                    if (Lmatch) {
                        leftcount = this.pseudocount(lw, w, le.next, d.left.next, lcost);
                        if (le.multi) {
                            leftcount += this.pseudocount(lw, w, le, d.left.next, lcost);
                        }
                        if (d.left.multi) {
                            leftcount += this.pseudocount(lw, w, le.next, d.left, lcost);
                        }
                        if (le.multi && d.left.multi) {
                            leftcount += this.pseudocount(lw, w, le, d.left, lcost);
                        }
                    }
                    if (Rmatch) {
                        rightcount = this.pseudocount(w, rw, d.right.next, re.next, rcost);
                        if (d.right.multi) {
                            rightcount += this.pseudocount(w, rw, d.right, re.next, rcost);
                        }
                        if (re.multi) {
                            rightcount += this.pseudocount(w, rw, d.right.next, re, rcost);
                        }
                        if (d.right.multi && re.multi) {
                            rightcount += this.pseudocount(w, rw, d.right, re, rcost);
                        }
                    }
                    int pseudototal = leftcount * rightcount;
                    if (leftcount > 0) {
                        pseudototal += leftcount * this.pseudocount(w, rw, d.right, re, rcost);
                    }
                    if (le == null && rightcount > 0) {
                        pseudototal += rightcount * this.pseudocount(lw, w, le, d.left, lcost);
                    }
                    if (pseudototal == 0) continue;
                    leftcount = 0;
                    rightcount = 0;
                    if (Lmatch) {
                        leftcount = this.count(lw, w, le.next, d.left.next, lcost, opts);
                        if (le.multi) {
                            leftcount += this.count(lw, w, le, d.left.next, lcost, opts);
                        }
                        if (d.left.multi) {
                            leftcount += this.count(lw, w, le.next, d.left, lcost, opts);
                        }
                        if (le.multi && d.left.multi) {
                            leftcount += this.count(lw, w, le, d.left, lcost, opts);
                        }
                    }
                    if (Rmatch) {
                        rightcount = this.count(w, rw, d.right.next, re.next, rcost, opts);
                        if (d.right.multi) {
                            rightcount += this.count(w, rw, d.right, re.next, rcost, opts);
                        }
                        if (re.multi) {
                            rightcount += this.count(w, rw, d.right.next, re, rcost, opts);
                        }
                        if (d.right.multi && re.multi) {
                            rightcount += this.count(w, rw, d.right, re, rcost, opts);
                        }
                    }
                    total += leftcount * rightcount;
                    if (leftcount > 0) {
                        total += leftcount * this.count(w, rw, d.right, re, rcost, opts);
                    }
                    if (le != null || rightcount <= 0) continue;
                    total += rightcount * this.count(lw, w, le, d.left, lcost, opts);
                }
                m = m.next;
            }
        }
        t.count = total;
        return total;
    }

    public int pseudocount(int lw, int rw, Connector le, Connector re, int cost) {
        int count = Sentence.table_lookup(lw, rw, le, re, cost);
        if (count == 0) {
            return 0;
        }
        return 1;
    }

    public void init_x_table() {
        if (this.parse_info != null) {
            throw new RuntimeException("ParseInfo is not null");
        }
        ParseInfo pi = this.parse_info = new ParseInfo();
        pi.N_words = this.word.size();
        int x_table_size = pi.N_words >= 10 ? 16384 : (pi.N_words >= 4 ? 1 << pi.N_words : 16);
        pi.x_table_size = x_table_size;
        pi.x_table = new XTableConnector[x_table_size];
        for (int i = 0; i < x_table_size; ++i) {
            pi.x_table[i] = null;
        }
    }

    public void init_table() {
        ctable_size = this.word.size() >= 10 ? 65536 : (this.word.size() >= 4 ? 1 << 6 * (this.word.size() - 4) / 6 + 4 : 16);
        ctable = new TableConnector[ctable_size];
        for (int i = 0; i < ctable_size; ++i) {
            Sentence.ctable[i] = null;
        }
    }

    public static int table_lookup(int lw, int rw, Connector le, Connector re, int cost) {
        TableConnector t = Sentence.table_pointer(lw, rw, le, re, cost);
        if (t == null) {
            return -1;
        }
        return t.count;
    }

    public static int hash(int lw, int rw, Connector le, Connector re, int cost) {
        int i = 0;
        i = i + (i << 1) + MyRandom.randtable[lw + i & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[rw + i & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[((le == null ? 0 : le.hashCode()) + i) % (ctable_size + 1) & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[((re == null ? 0 : re.hashCode()) + i) % (ctable_size + 1) & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[cost + i & 0xFF];
        return i & ctable_size - 1;
    }

    public static TableConnector table_pointer(int lw, int rw, Connector le, Connector re, int cost) {
        TableConnector t = ctable[Sentence.hash(lw, rw, le, re, cost)];
        while (t != null) {
            if (t.lw == lw && t.rw == rw && t.le == le && t.re == re && t.cost == cost) {
                return t;
            }
            t = t.next;
        }
        return null;
    }

    public static TableConnector table_store(int lw, int rw, Connector le, Connector re, int cost, int count) {
        TableConnector t;
        TableConnector n = new TableConnector();
        n.count = count;
        n.lw = lw;
        n.rw = rw;
        n.le = le;
        n.re = re;
        n.cost = cost;
        int h = Sentence.hash(lw, rw, le, re, cost);
        n.next = t = ctable[h];
        Sentence.ctable[h] = n;
        return n;
    }

    public void init_fast_matcher() {
        match_cost = 0;
        for (int w = 0; w < this.word.size(); ++w) {
            int i;
            int size;
            int len = Sentence.left_disjunct_list_length(this.word.get((int)w).d);
            Sentence.match_l_table_size[w] = size = MyRandom.next_power_of_two_up(len);
            Sentence.match_l_table[w] = new MatchNode[size];
            MatchNode[] t = Sentence.match_l_table[w];
            for (i = 0; i < size; ++i) {
                t[i] = null;
            }
            Disjunct d = this.word.get((int)w).d;
            while (d != null) {
                if (d.left != null) {
                    Sentence.put_into_match_table(size, t, d, d.left, -1);
                }
                d = d.next;
            }
            len = Sentence.right_disjunct_list_length(this.word.get((int)w).d);
            Sentence.match_r_table_size[w] = size = MyRandom.next_power_of_two_up(len);
            Sentence.match_r_table[w] = new MatchNode[size];
            t = Sentence.match_r_table[w];
            for (i = 0; i < size; ++i) {
                t[i] = null;
            }
            d = this.word.get((int)w).d;
            while (d != null) {
                if (d.right != null) {
                    Sentence.put_into_match_table(size, t, d, d.right, 1);
                }
                d = d.next;
            }
        }
    }

    public static int left_disjunct_list_length(Disjunct d) {
        int i = 0;
        while (d != null) {
            if (d.left != null) {
                ++i;
            }
            d = d.next;
        }
        return i;
    }

    public static int right_disjunct_list_length(Disjunct d) {
        int i = 0;
        while (d != null) {
            if (d.right != null) {
                ++i;
            }
            d = d.next;
        }
        return i;
    }

    public static void put_into_match_table(int size, MatchNode[] t, Disjunct d, Connector c, int dir) {
        int h = Sentence.fast_match_hash(c) & size - 1;
        MatchNode m = new MatchNode();
        m.next = null;
        m.d = d;
        t[h] = dir == 1 ? Sentence.add_to_right_table_list(m, t[h]) : Sentence.add_to_left_table_list(m, t[h]);
    }

    public static int fast_match_hash(Connector c) {
        int i = MyRandom.randtable[c.label & 0xFF];
        String s = c.string;
        for (int j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s.charAt(j) + i & 0xFF];
        }
        return i;
    }

    public static MatchNode add_to_right_table_list(MatchNode m, MatchNode l) {
        if (l == null) {
            return m;
        }
        if (m.d.right.word <= l.d.right.word) {
            m.next = l;
            return m;
        }
        l.next = Sentence.add_to_right_table_list(m, l.next);
        return l;
    }

    public static MatchNode add_to_left_table_list(MatchNode m, MatchNode l) {
        if (l == null) {
            return m;
        }
        if (m.d.left.word >= l.d.left.word) {
            m.next = l;
            return m;
        }
        l.next = Sentence.add_to_left_table_list(m, l.next);
        return l;
    }

    public boolean build_parse_set(int cost, ParseOptions opts) {
        ParseSet whole_set = this.parse_info.parse_set(this, null, null, -1, this.word.size(), null, null, cost + 1, opts);
        if (whole_set != null && whole_set.current != null) {
            whole_set.current = whole_set.first;
        }
        this.parse_info.parse_set = whole_set;
        return this.parse_info.verify_set();
    }

    public void build_sentence_disjuncts(ParseOptions opts, int cost_cutoff) {
        for (int w = 0; w < this.word.size(); ++w) {
            Disjunct d = null;
            XNode x = this.word.get((int)w).x;
            while (x != null) {
                Disjunct dd = this.build_disjuncts_for_XNode(opts, x, cost_cutoff);
                d = Disjunct.catenate_disjuncts(dd, d);
                x = x.next;
            }
            this.word.get((int)w).d = d;
        }
    }

    public Disjunct build_disjuncts_for_XNode(ParseOptions opts, XNode x, int cost_cutoff) {
        Clause c = x.exp.build_Clause(cost_cutoff);
        Disjunct dis = Clause.build_disjunct(c, x.string, cost_cutoff);
        return dis;
    }

    public boolean sentence_contains_conjunction() {
        for (int w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).is_conjunction) continue;
            return true;
        }
        return false;
    }

    public void print_disjunct_counts(ParseOptions opts) {
        for (int i = 0; i < this.word.size(); ++i) {
            int c = 0;
            Disjunct d = this.word.get((int)i).d;
            while (d != null) {
                ++c;
                d = d.next;
            }
            opts.out.print(this.word.get((int)i).string + "(" + c + ") ");
        }
        opts.out.println();
        opts.out.println();
    }

    public void post_process_linkages(ParseOptions opts) {
        boolean only_canonical_allowed;
        int in;
        int N_linkages_alloced;
        this.link_info = null;
        boolean overflowed = this.build_parse_set(this.null_count, opts);
        opts.print_time("Built parse set");
        if (overflowed) {
            this.num_linkages_found = opts.linkage_limit;
            if (opts.verbosity > 1) {
                opts.out.println("Warning: Count overflow.\nConsidering a random subset of " + opts.linkage_limit + " of an unknown and large number of linkages");
            }
        }
        int N_linkages_found = this.num_linkages_found;
        if (this.num_linkages_found == 0) {
            this.num_linkages_alloced = 0;
            this.num_linkages_post_processed = 0;
            this.num_valid_linkages = 0;
            this.link_info = null;
            return;
        }
        if (N_linkages_found > opts.linkage_limit) {
            N_linkages_alloced = opts.linkage_limit;
            if (opts.verbosity > 1) {
                opts.out.println("Warning: Considering a random subset of " + N_linkages_alloced + " of " + N_linkages_found + " linkages");
            }
        } else {
            N_linkages_alloced = N_linkages_found;
        }
        this.link_info = new LinkageInfo[N_linkages_alloced];
        int N_valid_linkages = 0;
        int N_linkages_post_processed = 0;
        int[] indices = new int[N_linkages_alloced];
        if (overflowed) {
            for (in = 0; in < N_linkages_alloced; ++in) {
                indices[in] = -(in + 1);
            }
        } else {
            MyRandom.my_random_initialize(N_linkages_found + this.word.size());
            for (in = 0; in < N_linkages_alloced; ++in) {
                double denom = N_linkages_alloced;
                int block_bottom = (int)((double)in * (double)N_linkages_found / denom);
                int block_top = (int)((double)(in + 1) * (double)N_linkages_found / denom);
                indices[in] = block_bottom + MyRandom.my_random() % (block_top - block_bottom);
            }
            MyRandom.my_random_finalize();
        }
        boolean bl = only_canonical_allowed = !overflowed && N_linkages_found <= 2 * opts.linkage_limit;
        if (this.word.size() >= opts.twopass_length) {
            for (in = 0; in < N_linkages_alloced; ++in) {
                Linkage.extract_links(indices[in], this.null_count, this.parse_info);
                if (this.set_has_fat_down()) {
                    if (only_canonical_allowed && !this.is_canonical_linkage()) continue;
                    this.analyze_fat_linkage(opts, 1);
                    continue;
                }
                this.analyze_thin_linkage(opts, 1);
            }
        }
        for (in = 0; in < N_linkages_alloced; ++in) {
            Linkage.extract_links(indices[in], this.null_count, this.parse_info);
            if (this.set_has_fat_down()) {
                boolean canonical = this.is_canonical_linkage();
                if (only_canonical_allowed && !canonical) continue;
                this.link_info[N_linkages_post_processed] = this.analyze_fat_linkage(opts, 2);
                this.link_info[N_linkages_post_processed].fat = true;
                this.link_info[N_linkages_post_processed].canonical = canonical;
            } else {
                this.link_info[N_linkages_post_processed] = this.analyze_thin_linkage(opts, 2);
                this.link_info[N_linkages_post_processed].fat = false;
                this.link_info[N_linkages_post_processed].canonical = true;
            }
            if (this.link_info[N_linkages_post_processed].N_violations == 0) {
                ++N_valid_linkages;
            }
            this.link_info[N_linkages_post_processed].index = indices[in];
            ++N_linkages_post_processed;
        }
        opts.print_time("Postprocessed all linkages");
        Arrays.sort(this.link_info, 0, N_linkages_post_processed, opts.cost_model);
        if (N_linkages_post_processed == 0 && N_linkages_found > 0 && N_linkages_found < opts.linkage_limit) {
            throw new RuntimeException("None of the linkages is canonical");
        }
        if (opts.verbosity > 1) {
            opts.out.println("" + N_valid_linkages + " of " + N_linkages_post_processed + " linkages with no P.P. violations");
        }
        opts.print_time("Sorted all linkages");
        this.num_linkages_alloced = N_linkages_alloced;
        this.num_linkages_post_processed = N_linkages_post_processed;
        this.num_valid_linkages = N_valid_linkages;
    }

    public void fill_patch_array_DIS(DISNode dn, LinksToPatch ltp) {
        ListOfLinks lol = dn.lol;
        while (lol != null) {
            this.patch_array[lol.link].used = true;
            lol = lol.next;
        }
        if (dn.cl == null || dn.cl.cn.word != dn.word) {
            while (ltp != null) {
                LinksToPatch ltpx = ltp.next;
                this.patch_array[ltp.link].changed = true;
                if (ltp.dir == 'l') {
                    this.patch_array[ltp.link].newl = dn.word;
                } else {
                    this.patch_array[ltp.link].newr = dn.word;
                }
                ltp = ltpx;
            }
        }
        CONList cl = dn.cl;
        while (cl != null) {
            this.fill_patch_array_CON(cl.cn, ltp);
            ltp = null;
            cl = cl.next;
        }
    }

    public void fill_patch_array_CON(CONNode cn, LinksToPatch ltp) {
        ListOfLinks lol = ParseInfo.word_links[cn.word];
        while (lol != null) {
            if (lol.dir == 0) {
                LinksToPatch ltpx = new LinksToPatch();
                ltpx.next = ltp;
                ltp = ltpx;
                ltp.newValue = cn.word;
                ltp.link = lol.link;
                ltp.dir = lol.word > cn.word ? (char)108 : (char)114;
            }
            lol = lol.next;
        }
        this.fill_patch_array_DIS(cn.current.dn, ltp);
    }

    /*
     * Unable to fully structure code
     */
    public LinkageInfo analyze_fat_linkage(ParseOptions opts, int analyze_pass) {
        li = new LinkageInfo();
        pi = this.parse_info;
        accum = new PPNode();
        sublinkage = new Sublinkage(pi);
        postprocessor = this.dict.postprocessor;
        pi.build_digraph();
        Sentence.structure_violation = false;
        d_root = pi.build_DIS_CON_tree();
        li.N_violations = 0;
        li.improper_fat_linkage = Sentence.structure_violation;
        li.inconsistent_domains = false;
        li.unused_word_cost = pi.unused_word_cost();
        li.disjunct_cost = pi.disjunct_cost();
        li.null_cost = pi.null_cost();
        li.link_cost = pi.link_cost();
        if (Sentence.structure_violation) {
            ++li.N_violations;
            li.and_cost = 0;
            li.andlist = null;
            return li;
        }
        if (analyze_pass == 2) {
            li.andlist = this.build_andlist();
            li.and_cost = li.andlist.cost;
        } else {
            li.and_cost = 0;
        }
        this.compute_link_names();
        for (i = 0; i < pi.N_links; ++i) {
            accum.d_type_array[i] = null;
        }
        do lbl-1000:
        // 4 sources

        {
            block14: {
                for (i = 0; i < pi.N_links; ++i) {
                    this.patch_array[i].changed = false;
                    this.patch_array[i].used = false;
                    this.patch_array[i].newl = pi.link_array[i].l;
                    this.patch_array[i].newr = pi.link_array[i].r;
                    sublinkage.link[i] = new Link();
                    sublinkage.link[i].l = pi.link_array[i].l;
                    sublinkage.link[i].lc = pi.link_array[i].lc;
                    sublinkage.link[i].r = pi.link_array[i].r;
                    sublinkage.link[i].rc = pi.link_array[i].rc;
                    sublinkage.link[i].name = pi.link_array[i].name;
                }
                this.fill_patch_array_DIS(d_root, null);
                for (i = 0; i < pi.N_links; ++i) {
                    if (this.patch_array[i].changed || this.patch_array[i].used) {
                        sublinkage.link[i].l = this.patch_array[i].newl;
                        sublinkage.link[i].r = this.patch_array[i].newr;
                        continue;
                    }
                    if (ParseInfo.dfs_root_word[pi.link_array[i].l] == -1 || ParseInfo.dfs_root_word[pi.link_array[i].r] == -1) continue;
                    sublinkage.link[i].l = -1;
                }
                this.compute_pp_link_array_connectors(sublinkage);
                this.compute_pp_link_names(sublinkage);
                if (analyze_pass != 1) break block14;
                this.post_process_scan_linkage(postprocessor, opts, sublinkage);
                if (d_root.advance_DIS()) ** GOTO lbl-1000
                break;
            }
            pp = this.post_process(postprocessor, opts, sublinkage, true);
            if (pp == null) {
                if (postprocessor == null) continue;
                li.N_violations = 1;
                continue;
            }
            if (pp.violation == null) {
                for (i = 0; i < pi.N_links; ++i) {
                    if (sublinkage.link[i].l == -1) continue;
                    if (accum.d_type_array[i] == null) {
                        accum.d_type_array[i] = Sentence.copy_d_type(pp.d_type_array[i]);
                        continue;
                    }
                    dtl0 = pp.d_type_array[i];
                    dtl1 = accum.d_type_array[i];
                    while (dtl0 != null && dtl1 != null && dtl0.type == dtl1.type) {
                        dtl0 = dtl0.next;
                        dtl1 = dtl1.next;
                    }
                    if (dtl0 != null || dtl1 != null) break;
                }
                if (i == pi.N_links) continue;
                ++li.N_violations;
                li.inconsistent_domains = true;
                continue;
            }
            if (pp.violation == null) continue;
            ++li.N_violations;
        } while (d_root.advance_DIS());
        return li;
    }

    public void post_process_scan_linkage(Postprocessor pp, ParseOptions opts, Sublinkage sublinkage) {
        if (pp == null) {
            return;
        }
        if (this.word.size() < opts.twopass_length) {
            return;
        }
        for (int i = 0; i < sublinkage.num_links; ++i) {
            if (sublinkage.link[i].l == -1) continue;
            String p = sublinkage.link[i].name;
            PPLinkset.PPLinkset_add(pp.set_of_links_of_sentence, p);
        }
    }

    public void prune_irrelevant_rules(ParseOptions opts, Postprocessor pp) {
        PPRule rule;
        int rcoIDX = 0;
        int rcnIDX = 0;
        if (PPLinkset.PPLinkset_population(pp.set_of_links_of_sentence) == 0) {
            return;
        }
        int coIDX = 0;
        while (true) {
            rule = pp.knowledge.contains_one_rules[coIDX];
            if (rule.msg == null) break;
            if (PPLinkset.PPLinkset_match_bw(pp.set_of_links_of_sentence, rule.selector)) {
                pp.relevant_contains_one_rules[rcoIDX++] = coIDX;
                PPLinkset.PPLinkset_add(pp.set_of_links_in_an_active_rule, rule.selector);
            }
            ++coIDX;
        }
        pp.relevant_contains_one_rules[rcoIDX] = -1;
        int cnIDX = 0;
        while (true) {
            rule = pp.knowledge.contains_none_rules[cnIDX];
            if (rule.msg == null) break;
            if (PPLinkset.PPLinkset_match_bw(pp.set_of_links_of_sentence, rule.selector)) {
                pp.relevant_contains_none_rules[rcnIDX++] = cnIDX;
                PPLinkset.PPLinkset_add(pp.set_of_links_in_an_active_rule, rule.selector);
            }
            ++cnIDX;
        }
        pp.relevant_contains_none_rules[rcnIDX] = -1;
        if (opts.verbosity > 1) {
            opts.out.println("Saw " + PPLinkset.PPLinkset_population(pp.set_of_links_of_sentence) + " unique link names in all linkages.");
            opts.out.println("Using " + rcoIDX + " 'contains one' rules and " + rcnIDX + " 'contains none' rules");
        }
    }

    public PPNode post_process(Postprocessor pp, ParseOptions opts, Sublinkage sublinkage, boolean cleanup) {
        String[] msg = new String[1];
        if (pp == null) {
            return null;
        }
        pp.pp_data.links_to_ignore = null;
        pp.pp_data.length = this.word.size();
        Postprocessor.reset_pp_node(pp);
        if (!this.q_pruned_rules && this.word.size() >= opts.twopass_length) {
            this.prune_irrelevant_rules(opts, pp);
        }
        this.q_pruned_rules = true;
        switch (Postprocessor.internal_process(pp, sublinkage, msg)) {
            case -1: {
                ++pp.n_global_rules_firing;
                pp.pp_node.violation = msg[0];
                return pp.pp_node;
            }
            case 1: {
                ++pp.n_local_rules_firing;
                pp.pp_node.violation = msg[0];
                break;
            }
            case 0: {
                pp.pp_node.violation = null;
            }
        }
        Postprocessor.build_type_array(pp);
        if (cleanup) {
            Postprocessor.post_process_free_data(pp.pp_data);
        }
        return pp.pp_node;
    }

    public void compute_pp_link_array_connectors(Sublinkage sublinkage) {
        ParseInfo pi = this.parse_info;
        for (int end = -1; end <= 1; end += 2) {
            for (int link = 0; link < pi.N_links; ++link) {
                Connector con;
                Connector mycon;
                Connector clist;
                Disjunct mydis;
                Disjunct dis;
                Connector this_end_con;
                int word;
                if (sublinkage.link[link].l == -1) continue;
                if (end < 0) {
                    word = pi.link_array[link].l;
                    if (!has_fat_down[word]) continue;
                    this_end_con = pi.link_array[link].lc;
                    dis = pi.chosen_disjuncts[word];
                    mydis = pi.chosen_disjuncts[sublinkage.link[link].l];
                    clist = dis.right;
                } else {
                    word = pi.link_array[link].r;
                    if (!has_fat_down[word]) continue;
                    this_end_con = pi.link_array[link].rc;
                    dis = pi.chosen_disjuncts[word];
                    mydis = pi.chosen_disjuncts[sublinkage.link[link].r];
                    clist = dis.left;
                }
                if (this_end_con.label != -1) continue;
                int place = 0;
                Connector upcon = dis.left != null && dis.left.priority == 1 ? dis.left : (dis.right != null && dis.right.priority == 1 ? dis.right : null);
                if (upcon != null) {
                    Disjunct updis = this.and_data.label_table[upcon.label];
                    Connector updiscon = end > 0 ? updis.left : updis.right;
                    while (updiscon != null) {
                        ++place;
                        updiscon = updiscon.next;
                    }
                }
                while (clist != this_end_con) {
                    if (clist.label < 0) {
                        ++place;
                    }
                    clist = clist.next;
                }
                if (mydis.left != null && mydis.left.priority == 1) {
                    mycon = mydis.left;
                } else if (mydis.right != null && mydis.right.priority == 1) {
                    mycon = mydis.right;
                } else {
                    throw new RuntimeException("There should be a fat UP link here. word = " + word + " fat link: [" + pi.link_array[link].l + ", " + pi.link_array[link].r + "]" + " thin link: [" + sublinkage.link[link].l + ", " + sublinkage.link[link].r + "]");
                }
                dis = this.and_data.label_table[mycon.label];
                while (dis != null && dis.string != mycon.string) {
                    dis = dis.next;
                }
                if (dis == null) {
                    throw new RuntimeException("Should have found this connector string");
                }
                if (end < 0) {
                    con = dis.right;
                    while (place > 0) {
                        --place;
                        con = con.next;
                    }
                    sublinkage.link[link].lc = Connector.copy_connectors(con);
                    continue;
                }
                con = dis.left;
                while (place > 0) {
                    --place;
                    con = con.next;
                }
                sublinkage.link[link].rc = Connector.copy_connectors(con);
            }
        }
    }

    public void compute_pp_link_names(Sublinkage sublinkage) {
        ParseInfo pi = this.parse_info;
        for (int i = 0; i < pi.N_links; ++i) {
            if (sublinkage.link[i].l == -1) continue;
            if (!Connector.x_match(this, sublinkage.link[i].lc, sublinkage.link[i].rc)) {
                sublinkage.link[i].replace_link_name(pi.link_array[i].name);
                continue;
            }
            String s = Sentence.intersect_strings(sublinkage.link[i].lc.string, sublinkage.link[i].rc.string);
            if (Sentence.strictly_smaller_name(s, pi.link_array[i].name)) {
                sublinkage.link[i].replace_link_name(pi.link_array[i].name);
                continue;
            }
            sublinkage.link[i].replace_link_name(s);
        }
    }

    public static DTypeList copy_d_type(DTypeList dtl) {
        DTypeList dtlcurr = null;
        DTypeList dtlhead = null;
        while (dtl != null) {
            DTypeList dtlx = new DTypeList(dtl);
            if (dtlhead == null) {
                dtlhead = dtlx;
                dtlcurr = dtlx;
            } else {
                dtlcurr.next = dtlx;
                dtlcurr = dtlx;
            }
            dtl = dtl.next;
        }
        return dtlhead;
    }

    private void and_dfs_commas(int w) {
        if (visited[w]) {
            return;
        }
        Sentence.visited[w] = true;
        ListOfLinks lol = ParseInfo.word_links[w];
        while (lol != null) {
            if (lol.dir == 1) {
                if (this.word.get((int)lol.word).string.equals(",")) {
                    this.and_dfs_commas(lol.word);
                } else {
                    Sentence.and_element[Sentence.N_and_elements] = lol.word;
                    this.and_dfs_full(lol.word);
                    ++N_and_elements;
                }
            }
            if (lol.dir == 0) {
                Sentence.outside_word[Sentence.N_outside_words] = lol.word;
                ++N_outside_words;
            }
            lol = lol.next;
        }
    }

    private void and_dfs_full(int w) {
        if (visited[w]) {
            return;
        }
        Sentence.visited[w] = true;
        int n = N_and_elements;
        and_element_sizes[n] = and_element_sizes[n] + 1;
        ListOfLinks lol = ParseInfo.word_links[w];
        while (lol != null) {
            if (lol.dir >= 0) {
                this.and_dfs_full(lol.word);
            }
            lol = lol.next;
        }
    }

    public AndList build_andlist() {
        ParseInfo pi = this.parse_info;
        AndList old_andlist = null;
        int cost = 0;
        for (int w = 0; w < pi.N_words; ++w) {
            int i;
            if (!this.word.get((int)w).is_conjunction) continue;
            N_and_elements = 0;
            N_outside_words = 0;
            for (i = 0; i < pi.N_words; ++i) {
                Sentence.visited[i] = false;
                Sentence.and_element_sizes[i] = 0;
            }
            if (this.dict.left_wall_defined) {
                Sentence.visited[0] = true;
            }
            this.and_dfs_commas(w);
            if (N_and_elements == 0) continue;
            AndList new_andlist = new AndList();
            new_andlist.num_elements = N_and_elements;
            new_andlist.num_outside_words = N_outside_words;
            for (i = 0; i < N_and_elements; ++i) {
                new_andlist.element[i] = and_element[i];
            }
            for (i = 0; i < N_outside_words; ++i) {
                new_andlist.outside_word[i] = outside_word[i];
            }
            new_andlist.conjunction = w;
            new_andlist.next = old_andlist;
            old_andlist = new_andlist;
            if (N_and_elements <= 0) continue;
            int min = 250;
            int max = 0;
            for (i = 0; i < N_and_elements; ++i) {
                int j = and_element_sizes[i];
                if (j < min) {
                    min = j;
                }
                if (j <= max) continue;
                max = j;
            }
            cost += max - min;
        }
        old_andlist.cost = cost;
        return old_andlist;
    }

    public LinkageInfo analyze_thin_linkage(ParseOptions opts, int analyze_pass) {
        LinkageInfo li = new LinkageInfo();
        ParseInfo pi = this.parse_info;
        pi.build_digraph();
        Sublinkage sublinkage = new Sublinkage(pi);
        Postprocessor postprocessor = this.dict.postprocessor;
        this.compute_link_names();
        for (int i = 0; i < pi.N_links; ++i) {
            sublinkage.link[i] = pi.link_array[i];
        }
        if (analyze_pass == 1) {
            this.post_process_scan_linkage(postprocessor, opts, sublinkage);
            return li;
        }
        li.N_violations = 0;
        li.and_cost = 0;
        PPNode pp = this.post_process(postprocessor, opts, sublinkage, true);
        li.unused_word_cost = pi.unused_word_cost();
        li.improper_fat_linkage = false;
        li.inconsistent_domains = false;
        li.disjunct_cost = pi.disjunct_cost();
        li.null_cost = pi.null_cost();
        li.link_cost = pi.link_cost();
        li.andlist = null;
        if (pp == null) {
            if (postprocessor != null) {
                li.N_violations = 1;
            }
        } else if (pp.violation != null) {
            ++li.N_violations;
        }
        return li;
    }

    public boolean is_canonical_linkage() {
        int w;
        int d_label = 0;
        ParseInfo pi = this.parse_info;
        Connector dummy_connector = new Connector();
        dummy_connector.priority = 1;
        dummy_connector.init_connector();
        this.build_image_array();
        for (w = 0; w < pi.N_words; ++w) {
            if (!has_fat_down[w]) continue;
            Disjunct chosen_d = pi.chosen_disjuncts[w];
            Connector d_c = chosen_d.left;
            while (d_c != null) {
                if (d_c.priority == 2) {
                    d_label = d_c.label;
                    break;
                }
                d_c = d_c.next;
            }
            if (d_c == null) {
                throw new RuntimeException("Should have found the down link.");
            }
            Connector upcon = chosen_d.left != null && chosen_d.left.priority == 1 ? chosen_d.left : (chosen_d.right != null && chosen_d.right.priority == 1 ? chosen_d.right : null);
            Disjunct dis = this.and_data.label_table[d_label];
            while (dis != null) {
                if (this.strictly_smaller(dis.string, d_c.string)) {
                    ImageNode in = image_array[w];
                    while (in != null) {
                        Connector c;
                        int place = in.place;
                        if (place == 0) {
                            if (upcon == null) {
                                throw new RuntimeException("Should have found an up link");
                            }
                            dummy_connector.label = upcon.label;
                            dummy_connector.string = upcon.label == d_label ? dis.string : this.find_subdisjunct((Disjunct)dis, (int)upcon.label).string;
                            if (!Connector.x_match(this, dummy_connector, in.c)) {
                                break;
                            }
                        } else if (place > 0) {
                            c = dis.right;
                            while (place > 1) {
                                c = c.next;
                                --place;
                            }
                            if (!Connector.x_match(this, c, in.c)) {
                                break;
                            }
                        } else {
                            c = dis.left;
                            while (place < -1) {
                                c = c.next;
                                ++place;
                            }
                            if (!Connector.x_match(this, c, in.c)) break;
                        }
                        in = in.next;
                    }
                    if (in == null) break;
                }
                dis = dis.next;
            }
            if (dis != null) break;
        }
        return w == pi.N_words;
    }

    public boolean strictly_smaller(String s, String t) {
        int strictness = 0;
        int i = 0;
        while (i < s.length() && i < t.length()) {
            if (s.charAt(i) == t.charAt(i)) continue;
            if (t.charAt(i) == '*' || s.charAt(i) == '^') {
                ++strictness;
            } else {
                return false;
            }
            ++i;
        }
        if (i != s.length() || i != t.length()) {
            throw new RuntimeException("s and t should be the same word.size()!");
        }
        return strictness > 0;
    }

    public Disjunct find_subdisjunct(Disjunct dis, int label) {
        Disjunct d = this.and_data.label_table[label];
        while (d != null) {
            Connector cx = d.left;
            Connector cy = dis.left;
            while (cx != null && cx.string.equals(cy.string) && cx.multi == cy.multi) {
                cx = cx.next;
                cy = cy.next;
            }
            if (cx == null) {
                cx = d.right;
                cy = dis.right;
                while (cx != null && cx.string.equals(cy.string) && cx.multi == cy.multi) {
                    cx = cx.next;
                    cy = cy.next;
                }
                if (cx == null) break;
            }
            d = d.next;
        }
        if (d == null) {
            throw new RuntimeException("Never found subdisjunct");
        }
        return d;
    }

    public void build_image_array() {
        int word;
        ParseInfo pi = this.parse_info;
        for (word = 0; word < pi.N_words; ++word) {
            Sentence.image_array[word] = null;
        }
        for (int end = -1; end <= 1; end += 2) {
            for (int link = 0; link < pi.N_links; ++link) {
                Connector clist;
                Disjunct dis;
                Connector other_end_con;
                Connector this_end_con;
                if (end < 0) {
                    word = pi.link_array[link].l;
                    if (!has_fat_down[word]) continue;
                    this_end_con = pi.link_array[link].lc;
                    other_end_con = pi.link_array[link].rc;
                    dis = pi.chosen_disjuncts[word];
                    clist = dis.right;
                } else {
                    word = pi.link_array[link].r;
                    if (!has_fat_down[word]) continue;
                    this_end_con = pi.link_array[link].rc;
                    other_end_con = pi.link_array[link].lc;
                    dis = pi.chosen_disjuncts[word];
                    clist = dis.left;
                }
                if (this_end_con.priority == 2 || this_end_con.label != -1 && this_end_con.label < 0) continue;
                ImageNode in = new ImageNode();
                in.next = image_array[word];
                Sentence.image_array[word] = in;
                in.c = other_end_con;
                if (this_end_con.priority == 1) {
                    in.place = 0;
                    continue;
                }
                in.place = 1;
                Connector upcon = dis.left != null && dis.left.priority == 1 ? dis.left : (dis.right != null && dis.right.priority == 1 ? dis.right : null);
                if (upcon != null) {
                    Disjunct updis = this.and_data.label_table[upcon.label];
                    Connector updiscon = end > 0 ? updis.left : updis.right;
                    while (updiscon != null) {
                        ++in.place;
                        updiscon = updiscon.next;
                    }
                }
                while (clist != this_end_con) {
                    if (clist.label < 0) {
                        ++in.place;
                    }
                    clist = clist.next;
                }
                in.place *= -end;
            }
        }
    }

    public int size_of_sentence_expressions() {
        int size = 0;
        for (int w = 0; w < this.word.size(); ++w) {
            XNode x = this.word.get((int)w).x;
            while (x != null) {
                size += x.exp.size_of_expression();
                x = x.next;
            }
        }
        return size;
    }

    public void clean_up_expressions(int w) {
        XNode head_node;
        XNode d = head_node = new XNode();
        d.next = this.word.get((int)w).x;
        while (d.next != null) {
            if (d.next.exp == null) {
                XNode d1 = d.next;
                d.next = d1.next;
                continue;
            }
            d = d.next;
        }
        this.word.get((int)w).x = head_node.next;
    }

    public void expression_prune(ParseOptions opts) {
        s_table_size = MyRandom.next_power_of_two_up(this.size_of_sentence_expressions());
        table = new Connector[s_table_size];
        Sentence.zero_S();
        int N_deleted = 1;
        while (true) {
            XNode x;
            int w;
            for (w = 0; w < this.word.size(); ++w) {
                x = this.word.get((int)w).x;
                while (x != null) {
                    N_deleted += x.exp.mark_dead_connectors(this, '-');
                    x = x.next;
                }
                x = this.word.get((int)w).x;
                while (x != null) {
                    x.exp = x.exp.purge_Exp();
                    x = x.next;
                }
                this.clean_up_expressions(w);
                x = this.word.get((int)w).x;
                while (x != null) {
                    x.exp.insert_connectors(43);
                    x = x.next;
                }
            }
            if (opts.verbosity > 2) {
                opts.out.println("l->r pass removed " + N_deleted);
                this.print_expression_sizes(opts);
            }
            Sentence.free_S();
            if (N_deleted == 0) break;
            N_deleted = 0;
            for (w = this.word.size() - 1; w >= 0; --w) {
                x = this.word.get((int)w).x;
                while (x != null) {
                    N_deleted += x.exp.mark_dead_connectors(this, '+');
                    x = x.next;
                }
                x = this.word.get((int)w).x;
                while (x != null) {
                    x.exp = x.exp.purge_Exp();
                    x = x.next;
                }
                this.clean_up_expressions(w);
                x = this.word.get((int)w).x;
                while (x != null) {
                    x.exp.insert_connectors(45);
                    x = x.next;
                }
            }
            if (opts.verbosity > 2) {
                opts.out.println("r->l pass removed " + N_deleted);
                this.print_expression_sizes(opts);
            }
            Sentence.free_S();
            if (N_deleted == 0) break;
            N_deleted = 0;
        }
    }

    public void print_expression_sizes(ParseOptions opts) {
        for (int w = 0; w < this.word.size(); ++w) {
            int size = 0;
            XNode x = this.word.get((int)w).x;
            while (x != null) {
                size += x.exp.size_of_expression();
                x = x.next;
            }
            opts.out.print(this.word.get((int)w).string + "[" + size + "] ");
        }
        opts.out.println();
        opts.out.println();
    }

    public static void zero_S() {
        for (int i = 0; i < s_table_size; ++i) {
            Sentence.table[i] = null;
        }
    }

    public static void free_S() {
        for (int i = 0; i < s_table_size; ++i) {
            Sentence.table[i] = null;
        }
    }

    public static void insert_S(Connector c) {
        int h = Sentence.hash_S(c);
        Connector e = table[h];
        while (e != null) {
            if (c.string.equals(e.string) && c.label == e.label && c.priority == e.priority) {
                return;
            }
            e = e.next;
        }
        e = new Connector(c);
        e.next = table[h];
        Sentence.table[h] = e;
    }

    public static int hash_S(Connector c) {
        int i = c.label;
        String s = c.string;
        for (int j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s.charAt(j) + i & 0xFF];
        }
        return i & s_table_size - 1;
    }

    public void print_parse_statistics(ParseOptions opts) {
        if (this.sentence_num_linkages_found() > 0) {
            if (this.sentence_num_linkages_found() > opts.parse_options_get_linkage_limit()) {
                opts.out.print("Found " + this.sentence_num_linkages_found() + " linkage" + (this.sentence_num_linkages_found() == 1 ? "" : "s") + " (" + this.sentence_num_valid_linkages() + " of " + this.sentence_num_linkages_post_processed() + " random linkages had no P.P. violations)");
            } else {
                opts.out.print("Found " + this.sentence_num_linkages_post_processed() + " linkage" + (this.sentence_num_linkages_found() == 1 ? "" : "s") + " (" + this.sentence_num_valid_linkages() + " had no P.P. violations)");
            }
            if (this.sentence_null_count() > 0) {
                opts.out.print(" at null count " + this.sentence_null_count());
            }
            opts.out.println();
        }
    }

    public boolean matches_S(Connector c, int dir) {
        int h = Sentence.hash_S(c);
        if (dir == 45) {
            Connector e = table[h];
            while (e != null) {
                if (Connector.x_prune_match(this, e, c)) {
                    return true;
                }
                e = e.next;
            }
        } else {
            Connector e = table[h];
            while (e != null) {
                if (Connector.x_prune_match(this, c, e)) {
                    return true;
                }
                e = e.next;
            }
        }
        return false;
    }

    public String sentence_get_word(int index) {
        return this.word.get((int)index).string;
    }

    public int sentence_null_count() {
        return this.null_count;
    }

    public int sentence_num_linkages_found() {
        return this.num_linkages_found;
    }

    public int sentence_num_valid_linkages() {
        return this.num_valid_linkages;
    }

    public int sentence_num_linkages_post_processed() {
        return this.num_linkages_post_processed;
    }

    public int sentence_num_violations(int i) {
        return this.link_info[i].N_violations;
    }

    public int sentence_disjunct_cost(int i) {
        return this.link_info[i].disjunct_cost;
    }

    public boolean set_has_fat_down() {
        boolean[] has_fat_down = new boolean[250];
        ParseInfo pi = this.parse_info;
        int N_fat = 0;
        for (int w = 0; w < pi.N_words; ++w) {
            has_fat_down[w] = false;
        }
        for (int link = 0; link < pi.N_links; ++link) {
            if (pi.link_array[link].lc.priority == 2) {
                ++N_fat;
                has_fat_down[pi.link_array[link].l] = true;
                continue;
            }
            if (pi.link_array[link].rc.priority != 2) continue;
            ++N_fat;
            has_fat_down[pi.link_array[link].r] = true;
        }
        return N_fat > 0;
    }

    public void compute_link_names() {
        ParseInfo pi = this.parse_info;
        for (int i = 0; i < pi.N_links; ++i) {
            pi.link_array[i].name = Sentence.intersect_strings(pi.link_array[i].lc.string, pi.link_array[i].rc.string);
        }
    }

    public static boolean strictly_smaller_name(String s, String t) {
        int strictness = 0;
        int i = 0;
        int j = 0;
        while (i < s.length() || j < t.length()) {
            int tt;
            int ss;
            if (i >= s.length()) {
                ss = 42;
            } else {
                ss = s.charAt(i);
                ++i;
            }
            if (j >= t.length()) {
                tt = 42;
            } else {
                tt = t.charAt(j);
                ++j;
            }
            if (ss == tt) continue;
            if (tt == 42 || ss == 94) {
                ++strictness;
                continue;
            }
            return false;
        }
        return strictness > 0;
    }

    public static String intersect_strings(String s, String t) {
        int len;
        int d = 0;
        if (s.equals(t)) {
            return s;
        }
        int i = s.length();
        int j = t.length();
        if (j > i) {
            String u0 = s;
            s = t;
            t = u0;
            len = j;
        } else {
            len = i;
        }
        StringBuffer u = new StringBuffer(len);
        for (i = 0; i < t.length(); ++i) {
            if (s.charAt(i) == t.charAt(i) || t.charAt(i) == '*') {
                u.append(s.charAt(i));
                continue;
            }
            ++d;
            if (s.charAt(i) == '*') {
                u.append(t.charAt(i));
                continue;
            }
            u.append('^');
        }
        if (d == 0) {
            return s;
        }
        if (i < s.length()) {
            u.append(s.substring(i));
        }
        return u.toString();
    }

    public void free_sentence_disjuncts() {
        for (int i = 0; i < this.word.size(); ++i) {
            this.word.get((int)i).d = null;
        }
        if (this.sentence_contains_conjunction()) {
            this.free_AND_tables();
        }
    }

    public void free_HT() {
        for (int i = 0; i < 1024; ++i) {
            this.and_data.hash_table[i] = null;
        }
    }

    public void free_LT() {
        this.and_data.LT_bound = 0;
        this.and_data.LT_size = 0;
        this.and_data.label_table = null;
    }

    public void free_AND_tables() {
        this.free_LT();
        this.free_HT();
    }

    public void free_parse_set() {
        this.parse_info = null;
    }

    private void construct_comma() {
        for (int w = 0; w < this.word.size() - 1; ++w) {
            if (!this.word.get((int)w).string.equals(",") || !this.word.get((int)(w + 1)).is_conjunction) continue;
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-2, 43, "", ","), this.word.get((int)w).d);
            this.word.get((int)(w + 1)).d = Sentence.glom_comma_connector(this.word.get((int)(w + 1)).d);
        }
    }

    private void construct_either() {
        int w;
        if (!this.sentence_contains("either")) {
            return;
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("either")) continue;
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-3, 43, "", "either"), this.word.get((int)w).d);
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("or")) continue;
            this.word.get((int)w).d = Sentence.glom_aux_connector(this.word.get((int)w).d, -3, false);
        }
    }

    private void construct_neither() {
        int w;
        if (!this.sentence_contains("neither")) {
            return;
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("neither")) continue;
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-4, 43, "", "neither"), this.word.get((int)w).d);
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("nor")) continue;
            this.word.get((int)w).d = Sentence.glom_aux_connector(this.word.get((int)w).d, -4, true);
        }
    }

    private void construct_notonlybut() {
        int w;
        if (!this.sentence_contains("not")) {
            return;
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("not")) continue;
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-5, 43, "", "not"), this.word.get((int)w).d);
            if (w >= this.word.size() - 1 || !this.word.get((int)(w + 1)).string.equals("only")) continue;
            this.word.get((int)(w + 1)).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-6, 45, "", "only"), this.word.get((int)(w + 1)).d);
            Disjunct d = Sentence.special_disjunct(-6, 43, "", "not");
            d = Sentence.add_one_connector(-5, 43, "", d);
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(d, this.word.get((int)w).d);
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("but")) continue;
            this.word.get((int)w).d = Sentence.glom_aux_connector(this.word.get((int)w).d, -5, false);
        }
    }

    private void construct_both() {
        int w;
        if (!this.sentence_contains("both")) {
            return;
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("both")) continue;
            this.word.get((int)w).d = Disjunct.catenate_disjuncts(Sentence.special_disjunct(-7, 43, "", "both"), this.word.get((int)w).d);
        }
        for (w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals("and")) continue;
            this.word.get((int)w).d = Sentence.glom_aux_connector(this.word.get((int)w).d, -7, false);
        }
    }

    public void install_special_conjunctive_connectors() {
        this.construct_either();
        this.checkDuplicate("A");
        this.construct_neither();
        this.checkDuplicate("B");
        this.construct_notonlybut();
        this.checkDuplicate("C");
        this.construct_both();
        this.checkDuplicate("D");
        this.construct_comma();
        this.checkDuplicate("E");
    }

    public boolean sentence_contains(String s) {
        for (int w = 0; w < this.word.size(); ++w) {
            if (!this.word.get((int)w).string.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static Disjunct glom_comma_connector(Disjunct d) {
        Disjunct d_list = null;
        Disjunct d1 = d;
        while (d1 != null) {
            if (d1.left != null) {
                Connector c = d1.left;
                while (c.next != null) {
                    c = c.next;
                }
                if (c.label >= 0) {
                    Disjunct d2 = Disjunct.copy_disjunct(d1);
                    d2.next = d_list;
                    d_list = d2;
                    Connector c1 = new Connector();
                    c1.init_connector();
                    c1.string = "";
                    c1.label = -2;
                    c1.priority = 0;
                    c1.multi = false;
                    c1.next = null;
                    c.next = c1;
                }
            }
            d1 = d1.next;
        }
        return Disjunct.catenate_disjuncts(d, d_list);
    }

    public static Disjunct glom_aux_connector(Disjunct d, int label, boolean necessary) {
        Disjunct d_list = null;
        Disjunct d1 = d;
        while (d1 != null) {
            if (d1.left != null) {
                Connector c = d1.left;
                while (c.next != null) {
                    c = c.next;
                }
                if (c.label >= 0) {
                    if (!necessary) {
                        Disjunct d2 = Disjunct.copy_disjunct(d1);
                        d2.next = d_list;
                        d_list = d2;
                    }
                    Connector c1 = new Connector();
                    c1.init_connector();
                    c1.string = "";
                    c1.label = label;
                    c1.priority = 0;
                    c1.multi = false;
                    c1.next = c;
                    if (d1.left == c) {
                        d1.left = c1;
                    } else {
                        Connector c2 = d1.left;
                        while (c2.next != c) {
                            c2 = c2.next;
                        }
                        c2.next = c1;
                    }
                }
            }
            d1 = d1.next;
        }
        return Disjunct.catenate_disjuncts(d, d_list);
    }

    public static Disjunct add_one_connector(int label, int dir, String cs, Disjunct d) {
        Connector c = new Connector();
        c.init_connector();
        c.string = cs;
        c.label = label;
        c.priority = 0;
        c.multi = false;
        c.next = null;
        if (dir == 43) {
            c.next = d.right;
            d.right = c;
        } else {
            c.next = d.left;
            d.left = c;
        }
        return d;
    }

    public static Disjunct special_disjunct(int label, int dir, String cs, String ds) {
        Connector c = new Connector();
        Disjunct d1 = new Disjunct();
        d1.cost = 0;
        d1.string = ds;
        d1.next = null;
        c.init_connector();
        c.string = cs;
        c.label = label;
        c.priority = 0;
        c.multi = false;
        c.next = null;
        if (dir == 43) {
            d1.left = null;
            d1.right = c;
        } else {
            d1.right = null;
            d1.left = c;
        }
        return d1;
    }

    public int pp_prune(ParseOptions opts) {
        Connector c;
        int dir;
        Disjunct d;
        int w;
        if (this.dict.postprocessor == null) {
            return 0;
        }
        PPKnowledge knowledge = this.dict.postprocessor.knowledge;
        this.init_cms_table();
        for (w = 0; w < this.word.size(); ++w) {
            d = this.word.get((int)w).d;
            while (d != null) {
                d.marked = true;
                for (dir = 0; dir < 2; ++dir) {
                    Connector connector = c = dir == 1 ? d.left : d.right;
                    while (c != null) {
                        this.insert_in_cms_table(c.string);
                        c = c.next;
                    }
                }
                d = d.next;
            }
        }
        int total_deleted = 0;
        int change = 1;
        while (change > 0) {
            change = 0;
            int N_deleted = 0;
            for (w = 0; w < this.word.size(); ++w) {
                d = this.word.get((int)w).d;
                while (d != null) {
                    if (d.marked) {
                        boolean deleteme = false;
                        for (dir = 0; dir < 2; ++dir) {
                            Connector connector = c = dir == 1 ? d.left : d.right;
                            while (c != null) {
                                for (int i = 0; i < knowledge.n_contains_one_rules; ++i) {
                                    PPRule rule = knowledge.contains_one_rules[i];
                                    String selector = rule.selector;
                                    PPLinkset link_set = rule.link_set;
                                    if (selector.indexOf(42) >= 0 || !Postprocessor.post_process_match(selector, c.string)) continue;
                                    if (!this.rule_satisfiable(link_set)) {
                                        deleteme = true;
                                    }
                                    if (deleteme) break;
                                }
                                if (deleteme) break;
                                c = c.next;
                            }
                            if (deleteme) break;
                        }
                        if (deleteme) {
                            ++N_deleted;
                            ++total_deleted;
                            d.marked = false;
                            for (dir = 0; dir < 2; ++dir) {
                                Connector connector = c = dir == 1 ? d.left : d.right;
                                while (c != null) {
                                    change += this.delete_from_cms_table(c.string);
                                    c = c.next;
                                }
                            }
                        }
                    }
                    d = d.next;
                }
            }
            if (opts.verbosity <= 2) continue;
            opts.out.println("pp_prune pass deleted " + N_deleted);
        }
        this.delete_unmarked_disjuncts();
        if (opts.verbosity > 2) {
            opts.out.println();
            opts.out.println("After pp_pruning:");
            this.print_disjunct_counts(opts);
        }
        opts.print_time("pp pruning");
        return total_deleted;
    }

    public void pp_and_power_prune(int mode, ParseOptions opts) {
        this.power_prune(mode, opts);
        while (this.pp_prune(opts) != 0 && this.power_prune(mode, opts) != 0) {
        }
    }

    public void delete_unmarked_disjuncts() {
        for (int w = 0; w < this.word.size(); ++w) {
            Disjunct d_head = null;
            Disjunct d = this.word.get((int)w).d;
            while (d != null) {
                Disjunct dx = d.next;
                if (d.marked) {
                    d.next = d_head;
                    d_head = d;
                } else {
                    d.next = null;
                }
                d = dx;
            }
            this.word.get((int)w).d = d_head;
        }
    }

    public void clean_up(int w) {
        Disjunct head_disjunct;
        Disjunct d = head_disjunct = new Disjunct();
        d.next = this.word.get((int)w).d;
        while (d.next != null) {
            if (d.next.left == null && d.next.right == null) {
                Disjunct d1 = d.next;
                d.next = d1.next;
                continue;
            }
            d = d.next;
        }
        this.word.get((int)w).d = head_disjunct.next;
    }

    public int count_disjuncts_in_sentence() {
        int count = 0;
        for (int w = 0; w < this.word.size(); ++w) {
            count += Disjunct.count_disjuncts(this.word.get((int)w).d);
        }
        return count;
    }

    public int power_prune(int mode, ParseOptions opts) {
        power_prune_mode = mode;
        null_links = opts.min_null_count > 0;
        this.init_power();
        power_cost = 0;
        Disjunct free_later = null;
        N_changed = 1;
        int N_deleted = 0;
        int total_deleted = 0;
        while (true) {
            Disjunct dx;
            Disjunct nd;
            Connector c;
            Disjunct d;
            int w;
            for (w = 0; w < this.word.size(); ++w) {
                d = this.word.get((int)w).d;
                while (d != null) {
                    if (d.left != null && this.left_connector_list_update(d.left, w, w, true) < 0) {
                        c = d.left;
                        while (c != null) {
                            c.word = 251;
                            c = c.next;
                        }
                        c = d.right;
                        while (c != null) {
                            c.word = 251;
                            c = c.next;
                        }
                        ++N_deleted;
                        ++total_deleted;
                    }
                    d = d.next;
                }
                this.clean_table(power_r_table_size[w], power_r_table[w]);
                nd = null;
                d = this.word.get((int)w).d;
                while (d != null) {
                    dx = d.next;
                    if (d.left != null && d.left.word == 251) {
                        d.next = free_later;
                        free_later = d;
                    } else {
                        d.next = nd;
                        nd = d;
                    }
                    d = dx;
                }
                this.word.get((int)w).d = nd;
            }
            if (opts.verbosity > 2) {
                opts.out.println("l->r pass changed " + N_changed + " and deleted " + N_deleted);
            }
            if (N_changed == 0) break;
            N_deleted = 0;
            N_changed = 0;
            for (w = this.word.size() - 1; w >= 0; --w) {
                d = this.word.get((int)w).d;
                while (d != null) {
                    if (d.right != null && this.right_connector_list_update(d.right, w, w, true) >= this.word.size()) {
                        c = d.right;
                        while (c != null) {
                            c.word = 251;
                            c = c.next;
                        }
                        c = d.left;
                        while (c != null) {
                            c.word = 251;
                            c = c.next;
                        }
                        ++N_deleted;
                        ++total_deleted;
                    }
                    d = d.next;
                }
                this.clean_table(power_l_table_size[w], power_l_table[w]);
                nd = null;
                d = this.word.get((int)w).d;
                while (d != null) {
                    dx = d.next;
                    if (d.right != null && d.right.word == 251) {
                        d.next = free_later;
                        free_later = d;
                    } else {
                        d.next = nd;
                        nd = d;
                    }
                    d = dx;
                }
                this.word.get((int)w).d = nd;
            }
            if (opts.verbosity > 2) {
                opts.out.println("r->l pass changed " + N_changed + " and deleted " + N_deleted);
            }
            if (N_changed == 0) break;
            N_deleted = 0;
            N_changed = 0;
        }
        if (opts.verbosity > 2) {
            opts.out.println("" + power_cost + " power prune cost:");
        }
        if (mode == 0) {
            opts.print_time("power pruned (ruthless)");
        } else {
            opts.print_time("power pruned (gentle)");
        }
        if (opts.verbosity > 2) {
            if (mode == 0) {
                opts.out.println("\nAfter power_pruning (ruthless):");
            } else {
                opts.out.println("\nAfter power_pruning (gentle):");
            }
            this.print_disjunct_counts(opts);
        }
        return total_deleted;
    }

    public void clean_table(int size, CList[] t) {
        for (int i = 0; i < size; ++i) {
            CList head = null;
            CList m = t[i];
            while (m != null) {
                CList xm = m.next;
                if (m.c.word != 251) {
                    m.next = head;
                    head = m;
                }
                m = xm;
            }
            t[i] = head;
        }
    }

    public int left_connector_list_update(Connector c, int word_c, int w, boolean shallow) {
        if (c == null) {
            return w;
        }
        int n = this.left_connector_list_update(c.next, word_c, w, false) - 1;
        if (c.word < n) {
            n = c.word;
        }
        boolean foundmatch = false;
        while (n >= 0 && w - n <= 250) {
            ++power_cost;
            if (this.right_table_search(n, c, shallow, word_c)) {
                foundmatch = true;
                break;
            }
            --n;
        }
        if (n < c.word) {
            c.word = n;
            ++N_changed;
        }
        return foundmatch ? n : -1;
    }

    public int right_connector_list_update(Connector c, int word_c, int w, boolean shallow) {
        if (c == null) {
            return w;
        }
        int n = this.right_connector_list_update(c.next, word_c, w, false) + 1;
        if (c.word > n) {
            n = c.word;
        }
        boolean foundmatch = false;
        while (n < this.word.size() && n - w <= 250) {
            ++power_cost;
            if (this.left_table_search(n, c, shallow, word_c)) {
                foundmatch = true;
                break;
            }
            ++n;
        }
        if (n > c.word) {
            c.word = n;
            ++N_changed;
        }
        return foundmatch ? n : this.word.size();
    }

    public void prune(ParseOptions opts) {
        s_table_size = MyRandom.next_power_of_two_up(this.count_disjuncts_in_sentence());
        table = new Connector[s_table_size];
        Sentence.zero_S();
        int N_deleted = 1;
        while (true) {
            Connector e;
            Disjunct d;
            int w;
            for (w = 0; w < this.word.size(); ++w) {
                d = this.word.get((int)w).d;
                while (d != null) {
                    e = d.left;
                    while (e != null && this.matches_S(e, 45)) {
                        e = e.next;
                    }
                    if (e != null) {
                        ++N_deleted;
                        d.right = null;
                        d.left = null;
                    }
                    d = d.next;
                }
                this.clean_up(w);
                d = this.word.get((int)w).d;
                while (d != null) {
                    e = d.right;
                    while (e != null) {
                        Sentence.insert_S(e);
                        e = e.next;
                    }
                    d = d.next;
                }
            }
            if (opts.verbosity > 2) {
                opts.out.println("l.r pass removed " + N_deleted);
                this.print_disjunct_counts(opts);
            }
            Sentence.free_S();
            if (N_deleted == 0) break;
            N_deleted = 0;
            for (w = this.word.size() - 1; w >= 0; --w) {
                d = this.word.get((int)w).d;
                while (d != null) {
                    e = d.right;
                    while (e != null && this.matches_S(e, 43)) {
                        e = e.next;
                    }
                    if (e != null) {
                        ++N_deleted;
                        d.right = null;
                        d.left = null;
                    }
                    d = d.next;
                }
                this.clean_up(w);
                d = this.word.get((int)w).d;
                while (d != null) {
                    e = d.left;
                    while (e != null) {
                        Sentence.insert_S(e);
                        e = e.next;
                    }
                    d = d.next;
                }
            }
            if (opts.verbosity > 2) {
                opts.out.println("r.l pass removed " + N_deleted);
                this.print_disjunct_counts(opts);
            }
            Sentence.free_S();
            if (N_deleted == 0) break;
            N_deleted = 0;
        }
    }

    public int set_dist_fields(Connector c, int w, int delta) {
        int i;
        if (c == null) {
            return w;
        }
        c.word = i = this.set_dist_fields(c.next, w, delta) + delta;
        return i;
    }

    public boolean possible_connection(Connector lc, Connector rc, boolean lshallow, boolean rshallow, int lword, int rword) {
        if (!lshallow && !rshallow) {
            return false;
        }
        if (lc.word > rword || rc.word < lword) {
            return false;
        }
        if (power_prune_mode == 0) {
            if (lword == rword - 1 ? lc.next != null || rc.next != null : !null_links && lc.next == null && rc.next == null && !lc.multi && !rc.multi) {
                return false;
            }
            return Connector.match(this, lc, rc, lword, rword);
        }
        if (lword == rword - 1 ? lc.next != null || rc.next != null : !null_links && lc.next == null && rc.next == null && !lc.multi && !rc.multi && !this.deletable[lword + 1][rword]) {
            return false;
        }
        return Connector.prune_match(this, lc, rc, lword, rword);
    }

    public boolean right_table_search(int w, Connector c, boolean shallow, int word_c) {
        int size = power_r_table_size[w];
        int h = this.power_hash(c) & size - 1;
        CList cl = power_r_table[w][h];
        while (cl != null) {
            if (this.possible_connection(cl.c, c, cl.shallow, shallow, w, word_c)) {
                return true;
            }
            cl = cl.next;
        }
        return false;
    }

    public boolean left_table_search(int w, Connector c, boolean shallow, int word_c) {
        int size = power_l_table_size[w];
        int h = this.power_hash(c) & size - 1;
        CList cl = power_l_table[w][h];
        while (cl != null) {
            if (this.possible_connection(c, cl.c, shallow, cl.shallow, word_c, w)) {
                return true;
            }
            cl = cl.next;
        }
        return false;
    }

    public void init_power() {
        Disjunct d;
        int w;
        for (w = 0; w < this.word.size(); ++w) {
            Disjunct head = null;
            d = this.word.get((int)w).d;
            while (d != null) {
                Disjunct xd = d.next;
                if (this.set_dist_fields(d.left, w, -1) < 0 || this.set_dist_fields(d.right, w, 1) >= this.word.size()) {
                    d.next = null;
                } else {
                    d.next = head;
                    head = d;
                }
                d = xd;
            }
            this.word.get((int)w).d = head;
        }
        for (w = 0; w < this.word.size(); ++w) {
            Connector c;
            int i;
            int size;
            int len = this.left_connector_count(this.word.get((int)w).d);
            Sentence.power_l_table_size[w] = size = MyRandom.next_power_of_two_up(len);
            Sentence.power_l_table[w] = new CList[size];
            CList[] t = Sentence.power_l_table[w];
            for (i = 0; i < size; ++i) {
                t[i] = null;
            }
            d = this.word.get((int)w).d;
            while (d != null) {
                c = d.left;
                if (c != null) {
                    this.put_into_power_table(size, t, c, true);
                    c = c.next;
                    while (c != null) {
                        this.put_into_power_table(size, t, c, false);
                        c = c.next;
                    }
                }
                d = d.next;
            }
            len = this.right_connector_count(this.word.get((int)w).d);
            Sentence.power_r_table_size[w] = size = MyRandom.next_power_of_two_up(len);
            Sentence.power_r_table[w] = new CList[size];
            t = Sentence.power_r_table[w];
            for (i = 0; i < size; ++i) {
                t[i] = null;
            }
            d = this.word.get((int)w).d;
            while (d != null) {
                c = d.right;
                if (c != null) {
                    this.put_into_power_table(size, t, c, true);
                    c = c.next;
                    while (c != null) {
                        this.put_into_power_table(size, t, c, false);
                        c = c.next;
                    }
                }
                d = d.next;
            }
        }
    }

    public int left_connector_count(Disjunct d) {
        int i = 0;
        while (d != null) {
            Connector c = d.left;
            while (c != null) {
                ++i;
                c = c.next;
            }
            d = d.next;
        }
        return i;
    }

    public int right_connector_count(Disjunct d) {
        int i = 0;
        while (d != null) {
            Connector c = d.right;
            while (c != null) {
                ++i;
                c = c.next;
            }
            d = d.next;
        }
        return i;
    }

    public int power_hash(Connector c) {
        int i = MyRandom.randtable[c.label & 0xFF];
        String s = c.string;
        for (int j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s.charAt(j) + i & 0xFF];
        }
        return i;
    }

    public void put_into_power_table(int size, CList[] t, Connector c, boolean shal) {
        int h = this.power_hash(c) & size - 1;
        CList m = new CList();
        m.next = t[h];
        t[h] = m;
        m.c = c;
        m.shallow = shal;
    }

    public void init_cms_table() {
        for (int i = 0; i < 2048; ++i) {
            Sentence.cms_table[i] = null;
        }
    }

    public int cms_hash(String s) {
        int i = 0;
        for (int j = 0; j < s.length() && Character.isUpperCase(s.charAt(j)); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s.charAt(j) + i & 0xFF];
        }
        return i & 0x7FF;
    }

    public boolean match_in_cms_table(String pp_match_name) {
        Cms cms = cms_table[this.cms_hash(pp_match_name)];
        while (cms != null) {
            if (Postprocessor.post_process_match(pp_match_name, cms.name)) {
                return true;
            }
            cms = cms.next;
        }
        return false;
    }

    public Cms lookup_in_cms_table(String str) {
        Cms cms = cms_table[this.cms_hash(str)];
        while (cms != null) {
            if (str.equals(cms.name)) {
                return cms;
            }
            cms = cms.next;
        }
        return null;
    }

    public void insert_in_cms_table(String str) {
        Cms cms = this.lookup_in_cms_table(str);
        if (cms != null) {
            ++cms.count;
        } else {
            cms = new Cms();
            cms.name = str;
            cms.count = 1;
            int h = this.cms_hash(str);
            cms.next = cms_table[h];
            Sentence.cms_table[h] = cms;
        }
    }

    public int delete_from_cms_table(String str) {
        Cms cms = this.lookup_in_cms_table(str);
        if (cms != null && cms.count > 0) {
            --cms.count;
            return cms.count == 0 ? 1 : 0;
        }
        return 0;
    }

    public boolean rule_satisfiable(PPLinkset ls) {
        StringBuffer name = new StringBuffer();
        for (int hashval = 0; hashval < ls.hash_table_size; ++hashval) {
            PPLinksetNode p = ls.hash_table[hashval];
            while (p != null) {
                int s;
                name.setLength(0);
                name.append(p.str);
                for (s = 0; s < name.length() && Character.isUpperCase(name.charAt(s)); ++s) {
                }
                while (s < name.length()) {
                    if (name.charAt(s) != '*') {
                        name.setCharAt(s, '#');
                    }
                    ++s;
                }
                int t = 0;
                for (s = 0; s < name.length() && Character.isUpperCase(name.charAt(s)); ++s) {
                    ++t;
                }
                int bad = 0;
                int n_subscripts = 0;
                while (s < name.length() && bad == 0) {
                    if (name.charAt(s) != '*') {
                        ++n_subscripts;
                        name.setCharAt(s, p.str.charAt(t));
                        if (!this.match_in_cms_table(name.toString())) {
                            ++bad;
                        }
                        name.setCharAt(s, '#');
                    }
                    ++s;
                    ++t;
                }
                if (n_subscripts == 0 && !this.match_in_cms_table(name.toString())) {
                    ++bad;
                }
                if (bad == 0) {
                    return true;
                }
                p = p.next;
            }
        }
        return false;
    }

    static {
        match_l_table_size = new int[250];
        match_r_table_size = new int[250];
        match_l_table = new MatchNode[250][];
        match_r_table = new MatchNode[250][];
        visited = new boolean[250];
        and_element_sizes = new int[250];
        and_element = new int[250];
        outside_word = new int[250];
        has_fat_down = new boolean[250];
        image_array = new ImageNode[250];
        power_l_table_size = new int[250];
        power_r_table_size = new int[250];
        power_l_table = new CList[250][];
        power_r_table = new CList[250][];
        cms_table = new Cms[2048];
    }
}

