/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.Date;
import net.sf.jlinkgrammar.ParseOptions;

public class Resources {
    private long startTime;
    private long lastTime;
    private long cumulativeTime;

    Resources() {
        this.startTime = this.lastTime = new Date().getTime();
        this.cumulativeTime = 0L;
    }

    void reset() {
        this.lastTime = this.startTime = new Date().getTime();
    }

    void printTime(ParseOptions opts, String s) {
        long currentTime = new Date().getTime();
        if (opts.verbosity > 1) {
            opts.out.print("++++");
            opts.left_print_string(s, "                                           ");
            opts.out.println("" + (double)(currentTime - this.lastTime) / 1000.0 + " seconds");
        }
        this.lastTime = currentTime;
    }

    void printTotalTime(ParseOptions opts) {
        long currentTime = new Date().getTime();
        this.cumulativeTime += currentTime - this.startTime;
        if (opts.verbosity > 0) {
            opts.out.print("++++");
            opts.left_print_string("Time", "                                           ");
            opts.out.println("" + (double)(currentTime - this.startTime) / 1000.0 + " seconds (" + (double)this.cumulativeTime / 1000.0 + " total)");
        }
        this.startTime = this.lastTime = currentTime;
    }
}

