/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.Arrays;
import java.util.Comparator;
import net.sf.jlinkgrammar.DTreeLeaf;
import net.sf.jlinkgrammar.DTypeList;
import net.sf.jlinkgrammar.Domain;
import net.sf.jlinkgrammar.ListOfLinks;
import net.sf.jlinkgrammar.PPData;
import net.sf.jlinkgrammar.PPKnowledge;
import net.sf.jlinkgrammar.PPLinkset;
import net.sf.jlinkgrammar.PPNode;
import net.sf.jlinkgrammar.PPRule;
import net.sf.jlinkgrammar.StartingLinkAndDomain;
import net.sf.jlinkgrammar.Sublinkage;

public class Postprocessor {
    PPKnowledge knowledge;
    int n_global_rules_firing;
    int n_local_rules_firing;
    PPLinkset set_of_links_of_sentence;
    PPLinkset set_of_links_in_an_active_rule;
    int[] relevant_contains_one_rules;
    int[] relevant_contains_none_rules;
    boolean[] visited = new boolean[250];
    PPNode pp_node;
    PPData pp_data;

    Postprocessor() {
    }

    static boolean post_process_match(String s, String t) {
        int i;
        for (i = 0; i < s.length() && i < t.length() && (Character.isUpperCase(s.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        while (i < s.length()) {
            if (s.charAt(i) != '#') {
                char c = i >= t.length() ? (char)'*' : (char)t.charAt(i);
                if (s.charAt(i) != c) {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    static void post_process_close_sentence(Postprocessor pp) {
        if (pp == null) {
            return;
        }
        PPLinkset.PPLinkset_clear(pp.set_of_links_of_sentence);
        PPLinkset.PPLinkset_clear(pp.set_of_links_in_an_active_rule);
        pp.n_local_rules_firing = 0;
        pp.n_global_rules_firing = 0;
        pp.relevant_contains_one_rules[0] = -1;
        pp.relevant_contains_none_rules[0] = -1;
        Postprocessor.free_pp_node(pp);
    }

    static int internal_process(Postprocessor pp, Sublinkage sublinkage, String[] msg) {
        if (!Postprocessor.apply_relevant_rules(pp, new ApplyContainsOneGlobally(), sublinkage, pp.knowledge.contains_one_rules, pp.relevant_contains_one_rules, msg)) {
            for (int i = 0; i < pp.pp_data.length; ++i) {
                pp.pp_data.word_links[i] = null;
            }
            pp.pp_data.N_domains = 0;
            return -1;
        }
        Postprocessor.build_graph(pp, sublinkage);
        Postprocessor.build_domains(pp, sublinkage);
        Postprocessor.build_domain_forest(pp, sublinkage);
        if (!Postprocessor.apply_relevant_rules(pp, new ApplyContainsOne(), sublinkage, pp.knowledge.contains_one_rules, pp.relevant_contains_one_rules, msg)) {
            return 1;
        }
        if (!Postprocessor.apply_relevant_rules(pp, new ApplyContainsNone(), sublinkage, pp.knowledge.contains_none_rules, pp.relevant_contains_none_rules, msg)) {
            return 1;
        }
        if (!Postprocessor.apply_rules(pp, new ApplyMustFormACycle(), sublinkage, pp.knowledge.form_a_cycle_rules, msg)) {
            return 1;
        }
        if (!Postprocessor.apply_rules(pp, new ApplyConnected(), sublinkage, pp.knowledge.connected_rules, msg)) {
            return 1;
        }
        if (!Postprocessor.apply_rules(pp, new ApplyBounded(), sublinkage, pp.knowledge.bounded_rules, msg)) {
            return 1;
        }
        return 0;
    }

    static boolean string_in_list(String s, String[] a) {
        int i = 0;
        while (a[i] != null) {
            if (Postprocessor.post_process_match(a[i], s)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static void mark_reachable_words(Postprocessor pp, int w) {
        if (pp.visited[w]) {
            return;
        }
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            Postprocessor.mark_reachable_words(pp, lol.word);
            lol = lol.next;
        }
    }

    static boolean is_connected(Postprocessor pp) {
        int i;
        for (i = 0; i < pp.pp_data.length; ++i) {
            pp.visited[i] = pp.pp_data.word_links[i] == null;
        }
        Postprocessor.mark_reachable_words(pp, 0);
        for (i = 0; i < pp.pp_data.length; ++i) {
            if (pp.visited[i]) continue;
            return false;
        }
        return true;
    }

    private static void build_graph(Postprocessor pp, Sublinkage sublinkage) {
        for (int i = 0; i < pp.pp_data.length; ++i) {
            pp.pp_data.word_links[i] = null;
        }
        for (int link = 0; link < sublinkage.num_links; ++link) {
            ListOfLinks lol;
            if (sublinkage.link[link].l == -1) continue;
            if (PPLinkset.PPLinkset_match(pp.knowledge.ignore_these_links, sublinkage.link[link].name)) {
                lol = new ListOfLinks();
                lol.next = pp.pp_data.links_to_ignore;
                pp.pp_data.links_to_ignore = lol;
                lol.link = link;
                lol.word = sublinkage.link[link].r;
                continue;
            }
            lol = new ListOfLinks();
            lol.next = pp.pp_data.word_links[sublinkage.link[link].l];
            pp.pp_data.word_links[sublinkage.link[link].l] = lol;
            lol.link = link;
            lol.word = sublinkage.link[link].r;
            lol = new ListOfLinks();
            lol.next = pp.pp_data.word_links[sublinkage.link[link].r];
            pp.pp_data.word_links[sublinkage.link[link].r] = lol;
            lol.link = link;
            lol.word = sublinkage.link[link].l;
        }
    }

    static void build_domains(Postprocessor pp, Sublinkage sublinkage) {
        pp.pp_data.N_domains = 0;
        for (int link = 0; link < sublinkage.num_links; ++link) {
            String s;
            if (sublinkage.link[link].l == -1 || PPLinkset.PPLinkset_match(pp.knowledge.ignore_these_links, s = sublinkage.link[link].name)) continue;
            if (PPLinkset.PPLinkset_match(pp.knowledge.domain_starter_links, s)) {
                Postprocessor.setup_domain_array(pp, pp.pp_data.N_domains, s, link);
                if (PPLinkset.PPLinkset_match(pp.knowledge.domain_contains_links, s)) {
                    Postprocessor.add_link_to_domain(pp, link);
                }
                Postprocessor.depth_first_search(pp, sublinkage, sublinkage.link[link].r, sublinkage.link[link].l, link);
                ++pp.pp_data.N_domains;
                if (pp.pp_data.N_domains < 128) continue;
                throw new RuntimeException("raise value of PP_MAX_DOMAINS");
            }
            if (PPLinkset.PPLinkset_match(pp.knowledge.urfl_domain_starter_links, s)) {
                Postprocessor.setup_domain_array(pp, pp.pp_data.N_domains, s, link);
                Postprocessor.add_link_to_domain(pp, link);
                Postprocessor.bad_depth_first_search(pp, sublinkage, sublinkage.link[link].r, sublinkage.link[link].l, link);
                ++pp.pp_data.N_domains;
                if (pp.pp_data.N_domains < 128) continue;
                throw new RuntimeException("raise PP_MAX_DOMAINS value");
            }
            if (PPLinkset.PPLinkset_match(pp.knowledge.urfl_only_domain_starter_links, s)) {
                Postprocessor.setup_domain_array(pp, pp.pp_data.N_domains, s, link);
                Postprocessor.d_depth_first_search(pp, sublinkage, sublinkage.link[link].l, sublinkage.link[link].l, sublinkage.link[link].r, link);
                ++pp.pp_data.N_domains;
                if (pp.pp_data.N_domains < 128) continue;
                throw new RuntimeException("raise PP_MAX_DOMAINS value");
            }
            if (!PPLinkset.PPLinkset_match(pp.knowledge.left_domain_starter_links, s)) continue;
            Postprocessor.setup_domain_array(pp, pp.pp_data.N_domains, s, link);
            Postprocessor.left_depth_first_search(pp, sublinkage, sublinkage.link[link].l, sublinkage.link[link].r, link);
            ++pp.pp_data.N_domains;
            if (pp.pp_data.N_domains < 128) continue;
            throw new RuntimeException("raise PP_MAX_DOMAINS value");
        }
        Arrays.sort(pp.pp_data.domain_array, 0, pp.pp_data.N_domains, new Comparator<Domain>(){

            @Override
            public int compare(Domain d1, Domain d2) {
                return d1.size - d2.size;
            }
        });
        for (int d = 0; d < pp.pp_data.N_domains; ++d) {
            int i = Postprocessor.find_domain_name(pp, pp.pp_data.domain_array[d].string);
            if (i == -1) {
                throw new RuntimeException("\tpost_process: Need an entry for " + pp.pp_data.domain_array[d].string + " in LINK_TYPE_TABLE");
            }
            pp.pp_data.domain_array[d].type = i;
        }
    }

    static void build_domain_forest(Postprocessor pp, Sublinkage sublinkage) {
        int d;
        if (pp.pp_data.N_domains > 0) {
            pp.pp_data.domain_array[pp.pp_data.N_domains - 1].parent = null;
        }
        for (d = 0; d < pp.pp_data.N_domains - 1; ++d) {
            int d1;
            for (d1 = d + 1; d1 < pp.pp_data.N_domains; ++d1) {
                if (!Postprocessor.contained_in(pp.pp_data.domain_array[d], pp.pp_data.domain_array[d1], sublinkage)) continue;
                pp.pp_data.domain_array[d].parent = pp.pp_data.domain_array[d1];
                break;
            }
            if (d1 != pp.pp_data.N_domains) continue;
            pp.pp_data.domain_array[d].parent = null;
        }
        for (d = 0; d < pp.pp_data.N_domains; ++d) {
            pp.pp_data.domain_array[d].child = null;
        }
        block3: for (int link = 0; link < sublinkage.num_links; ++link) {
            if (sublinkage.link[link].l == -1) continue;
            for (d = 0; d < pp.pp_data.N_domains; ++d) {
                if (!Postprocessor.link_in_domain(link, pp.pp_data.domain_array[d])) continue;
                DTreeLeaf dtl = new DTreeLeaf();
                dtl.link = link;
                dtl.parent = pp.pp_data.domain_array[d];
                dtl.next = pp.pp_data.domain_array[d].child;
                pp.pp_data.domain_array[d].child = dtl;
                continue block3;
            }
        }
    }

    static int find_domain_name(Postprocessor pp, String link) {
        StartingLinkAndDomain[] sllt = pp.knowledge.starting_link_lookup_table;
        int i = 0;
        int domain;
        while ((domain = sllt[i].domain) != -1) {
            if (Postprocessor.post_process_match(sllt[i].starting_link, link)) {
                return domain;
            }
            ++i;
        }
        return -1;
    }

    static boolean contained_in(Domain d1, Domain d2, Sublinkage sublinkage) {
        boolean[] mark = new boolean[497];
        Arrays.fill(mark, false);
        ListOfLinks lol = d2.lol;
        while (lol != null) {
            mark[lol.link] = true;
            lol = lol.next;
        }
        lol = d1.lol;
        while (lol != null) {
            if (!mark[lol.link]) {
                return false;
            }
            lol = lol.next;
        }
        return true;
    }

    static boolean link_in_domain(int link, Domain d) {
        ListOfLinks lol = d.lol;
        while (lol != null) {
            if (lol.link == link) {
                return true;
            }
            lol = lol.next;
        }
        return false;
    }

    static void connectivity_dfs(Postprocessor pp, Sublinkage sublinkage, int w, PPLinkset ls) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!pp.visited[lol.word] && !PPLinkset.PPLinkset_match(ls, sublinkage.link[lol.link].name)) {
                Postprocessor.connectivity_dfs(pp, sublinkage, lol.word, ls);
            }
            lol = lol.next;
        }
    }

    static void add_link_to_domain(Postprocessor pp, int link) {
        ListOfLinks lol = new ListOfLinks();
        lol.next = pp.pp_data.domain_array[pp.pp_data.N_domains].lol;
        pp.pp_data.domain_array[pp.pp_data.N_domains].lol = lol;
        ++pp.pp_data.domain_array[pp.pp_data.N_domains].size;
        lol.link = link;
    }

    static void depth_first_search(Postprocessor pp, Sublinkage sublinkage, int w, int root, int start_link) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (lol.word < w && lol.link != start_link) {
                Postprocessor.add_link_to_domain(pp, lol.link);
            }
            lol = lol.next;
        }
        lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!(pp.visited[lol.word] || lol.word == root || lol.word < root && lol.word < w && PPLinkset.PPLinkset_match(pp.knowledge.restricted_links, sublinkage.link[lol.link].name))) {
                Postprocessor.depth_first_search(pp, sublinkage, lol.word, root, start_link);
            }
            lol = lol.next;
        }
    }

    static void bad_depth_first_search(Postprocessor pp, Sublinkage sublinkage, int w, int root, int start_link) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (lol.word < w && lol.link != start_link && w != root) {
                Postprocessor.add_link_to_domain(pp, lol.link);
            }
            lol = lol.next;
        }
        lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!(pp.visited[lol.word] || w == root && lol.word < w || lol.word < root && lol.word < w && PPLinkset.PPLinkset_match(pp.knowledge.restricted_links, sublinkage.link[lol.link].name))) {
                Postprocessor.bad_depth_first_search(pp, sublinkage, lol.word, root, start_link);
            }
            lol = lol.next;
        }
    }

    static void d_depth_first_search(Postprocessor pp, Sublinkage sublinkage, int w, int root, int right, int start_link) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (lol.word < w && lol.link != start_link && w != root) {
                Postprocessor.add_link_to_domain(pp, lol.link);
            }
            lol = lol.next;
        }
        lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!(pp.visited[lol.word] || w == root && lol.word >= right || w == root && lol.word < root || lol.word < root && lol.word < w && PPLinkset.PPLinkset_match(pp.knowledge.restricted_links, sublinkage.link[lol.link].name))) {
                Postprocessor.d_depth_first_search(pp, sublinkage, lol.word, root, right, start_link);
            }
            lol = lol.next;
        }
    }

    static void left_depth_first_search(Postprocessor pp, Sublinkage sublinkage, int w, int right, int start_link) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (lol.word < w && lol.link != start_link) {
                Postprocessor.add_link_to_domain(pp, lol.link);
            }
            lol = lol.next;
        }
        lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!pp.visited[lol.word] && lol.word != right) {
                Postprocessor.depth_first_search(pp, sublinkage, lol.word, right, start_link);
            }
            lol = lol.next;
        }
    }

    static void setup_domain_array(Postprocessor pp, int n, String string, int start_link) {
        Arrays.fill(pp.visited, false);
        pp.pp_data.domain_array[n] = new Domain();
        pp.pp_data.domain_array[n].string = string;
        pp.pp_data.domain_array[n].lol = null;
        pp.pp_data.domain_array[n].size = 0;
        pp.pp_data.domain_array[n].start_link = start_link;
    }

    static void reachable_without_dfs(Postprocessor pp, Sublinkage sublinkage, int a, int b, int w) {
        pp.visited[w] = true;
        ListOfLinks lol = pp.pp_data.word_links[w];
        while (lol != null) {
            if (!(pp.visited[lol.word] || w == a && lol.word == b || w == b && lol.word == a)) {
                Postprocessor.reachable_without_dfs(pp, sublinkage, a, b, lol.word);
            }
            lol = lol.next;
        }
    }

    static boolean apply_rules(Postprocessor pp, ApplyFn applyfn, Sublinkage sublinkage, PPRule[] rule_array, String[] msg) {
        int i = 0;
        while ((msg[0] = rule_array[i].msg) != null) {
            if (!applyfn.applyfn(pp, sublinkage, rule_array[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static boolean apply_relevant_rules(Postprocessor pp, ApplyFn applyfn, Sublinkage sublinkage, PPRule[] rule_array, int[] relevant_rules, String[] msg) {
        int idx;
        if (PPLinkset.PPLinkset_population(pp.set_of_links_of_sentence) == 0) {
            return Postprocessor.apply_rules(pp, applyfn, sublinkage, rule_array, msg);
        }
        int i = 0;
        while ((idx = relevant_rules[i]) != -1) {
            msg[0] = rule_array[idx].msg;
            if (!applyfn.applyfn(pp, sublinkage, rule_array[idx])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static void free_pp_node(Postprocessor pp) {
        pp.pp_node = null;
    }

    static void alloc_pp_node(Postprocessor pp) {
        pp.pp_node = new PPNode();
        pp.pp_node.violation = null;
        for (int i = 0; i < 497; ++i) {
            pp.pp_node.d_type_array[i] = null;
        }
    }

    static void reset_pp_node(Postprocessor pp) {
        Postprocessor.free_pp_node(pp);
        Postprocessor.alloc_pp_node(pp);
    }

    static void post_process_free_data(PPData ppd) {
        ppd.links_to_ignore = null;
    }

    static void build_type_array(Postprocessor pp) {
        for (int d = 0; d < pp.pp_data.N_domains; ++d) {
            ListOfLinks lol = pp.pp_data.domain_array[d].lol;
            while (lol != null) {
                DTypeList dtl = new DTypeList();
                dtl.next = pp.pp_node.d_type_array[lol.link];
                pp.pp_node.d_type_array[lol.link] = dtl;
                dtl.type = pp.pp_data.domain_array[d].type;
                lol = lol.next;
            }
        }
    }

    static interface ApplyFn {
        public boolean applyfn(Postprocessor var1, Sublinkage var2, PPRule var3);
    }

    static class ApplyBounded
    implements ApplyFn {
        ApplyBounded() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            int d_type = rule.domain;
            for (int d = 0; d < pp.pp_data.N_domains; ++d) {
                if (pp.pp_data.domain_array[d].type != d_type) continue;
                int lw = sublinkage.link[pp.pp_data.domain_array[d].start_link].l;
                ListOfLinks lol = pp.pp_data.domain_array[d].lol;
                while (lol != null) {
                    if (sublinkage.link[lol.link].l < lw) {
                        return false;
                    }
                    lol = lol.next;
                }
            }
            return true;
        }
    }

    static class ApplyMustFormACycle
    implements ApplyFn {
        ApplyMustFormACycle() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            ListOfLinks lol;
            int w;
            for (w = 0; w < pp.pp_data.length; ++w) {
                lol = pp.pp_data.word_links[w];
                while (lol != null) {
                    if (w <= lol.word && PPLinkset.PPLinkset_match(rule.link_set, sublinkage.link[lol.link].name)) {
                        Arrays.fill(pp.visited, false);
                        Postprocessor.reachable_without_dfs(pp, sublinkage, w, lol.word, w);
                        if (!pp.visited[lol.word]) {
                            return false;
                        }
                    }
                    lol = lol.next;
                }
            }
            lol = pp.pp_data.links_to_ignore;
            while (lol != null) {
                w = sublinkage.link[lol.link].l;
                if (PPLinkset.PPLinkset_match(rule.link_set, sublinkage.link[lol.link].name)) {
                    Arrays.fill(pp.visited, false);
                    Postprocessor.reachable_without_dfs(pp, sublinkage, w, lol.word, w);
                    if (!pp.visited[lol.word]) {
                        return false;
                    }
                }
                lol = lol.next;
            }
            return true;
        }
    }

    static class ApplyConnected
    implements ApplyFn {
        ApplyConnected() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            return Postprocessor.is_connected(pp);
        }
    }

    static class ApplyContainsOneGlobally
    implements ApplyFn {
        ApplyContainsOneGlobally() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            int i;
            for (i = 0; !(i >= sublinkage.num_links || sublinkage.link[i].l != -1 && Postprocessor.post_process_match(rule.selector, sublinkage.link[i].name)); ++i) {
            }
            if (i == sublinkage.num_links) {
                return true;
            }
            boolean count = false;
            for (int j = 0; j < sublinkage.num_links && !count; ++j) {
                if (sublinkage.link[j].l == -1 || !Postprocessor.string_in_list(sublinkage.link[j].name, rule.link_array)) continue;
                count = true;
                break;
            }
            return count;
        }
    }

    static class ApplyContainsNone
    implements ApplyFn {
        ApplyContainsNone() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            for (int d = 0; d < pp.pp_data.N_domains; ++d) {
                DTreeLeaf dtl = pp.pp_data.domain_array[d].child;
                while (dtl != null && !Postprocessor.post_process_match(rule.selector, sublinkage.link[dtl.link].name)) {
                    dtl = dtl.next;
                }
                if (dtl == null) continue;
                dtl = pp.pp_data.domain_array[d].child;
                while (dtl != null) {
                    if (Postprocessor.string_in_list(sublinkage.link[dtl.link].name, rule.link_array)) {
                        return false;
                    }
                    dtl = dtl.next;
                }
            }
            return true;
        }
    }

    static class ApplyContainsOne
    implements ApplyFn {
        ApplyContainsOne() {
        }

        @Override
        public boolean applyfn(Postprocessor pp, Sublinkage sublinkage, PPRule rule) {
            for (int d = 0; d < pp.pp_data.N_domains; ++d) {
                DTreeLeaf dtl = pp.pp_data.domain_array[d].child;
                while (dtl != null && !Postprocessor.post_process_match(rule.selector, sublinkage.link[dtl.link].name)) {
                    dtl = dtl.next;
                }
                if (dtl == null) continue;
                boolean count = false;
                dtl = pp.pp_data.domain_array[d].child;
                while (dtl != null) {
                    if (Postprocessor.string_in_list(sublinkage.link[dtl.link].name, rule.link_array)) {
                        count = true;
                        break;
                    }
                    dtl = dtl.next;
                }
                if (count) continue;
                return false;
            }
            return true;
        }
    }
}

