/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import net.sf.jlinkgrammar.CNode;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.GlobalBean;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Sentence;

public class Parser {
    private static Dictionary dict;
    private static Sentence sent;
    private static String dictionary_file;
    private static String post_process_knowledge_file;
    private static String constituent_knowledge_file;
    private static String affix_file;
    private static boolean pp_on;
    private static boolean af_on;
    private static boolean cons_on;
    private static int num_linkages;
    private static StringBuffer input_string;
    private static int label;
    private static ParseOptions opts;

    public Parser() {
        String[] args = new String[]{new String("parseit")};
        Parser.InitializeVars(args);
    }

    public static void InitializeVars(String[] arg) {
        int i = 0;
        if (arg.length > 1 && arg[0].charAt(0) != '-') {
            dictionary_file = arg[0];
            ++i;
        }
        GlobalBean.opts = opts = new ParseOptions();
        opts.parse_options_set_max_sentence_length(70);
        opts.parse_options_set_linkage_limit(1000);
        opts.parse_options_set_short_length(10);
        while (i < arg.length) {
            if (arg[i].charAt(0) == '-') {
                if (arg[i].equals("-pp")) {
                    if (post_process_knowledge_file != null || i + 1 == arg.length) {
                        Parser.print_usage(arg[0]);
                    }
                    post_process_knowledge_file = arg[i + 1];
                    ++i;
                } else if (arg[i].equals("-c")) {
                    if (constituent_knowledge_file != null || i + 1 == arg.length) {
                        Parser.print_usage(arg[0]);
                    }
                    constituent_knowledge_file = arg[i + 1];
                    ++i;
                } else if (arg[i].equals("-a")) {
                    if (affix_file != null || i + 1 == arg.length) {
                        Parser.print_usage(arg[0]);
                    }
                    affix_file = arg[i + 1];
                    ++i;
                } else if (arg[i].equals("-ppoff")) {
                    pp_on = false;
                } else if (arg[i].equals("-coff")) {
                    cons_on = false;
                } else if (arg[i].equals("-aoff")) {
                    af_on = false;
                } else if (arg[i].equals("-batch")) {
                    if (Parser.opts.input != System.in || i + 1 == arg.length) {
                        Parser.print_usage(arg[0]);
                    }
                    try {
                        Parser.opts.input = new FileInputStream(arg[i + 1]);
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ++i;
                } else if (arg[i].equals("-out")) {
                    if (Parser.opts.out != System.out || i + 1 == arg.length) {
                        Parser.print_usage(arg[0]);
                    }
                    try {
                        Parser.opts.out = new PrintStream(new FileOutputStream(arg[i + 1]));
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    ++i;
                } else if (arg[i].charAt(1) != '!') {
                    Parser.print_usage(arg[0]);
                }
            }
            ++i;
        }
        if (!pp_on && post_process_knowledge_file != null) {
            Parser.print_usage(arg[0]);
        }
        if (dictionary_file == null) {
            dictionary_file = "4.0.dict";
            System.err.println("No dictionary file specified.  Using " + dictionary_file + ".");
        }
        if (af_on && affix_file == null) {
            affix_file = "4.0.affix";
            System.err.println("No affix file specified.  Using " + affix_file + ".");
        }
        if (pp_on && post_process_knowledge_file == null) {
            post_process_knowledge_file = "4.0.knowledge";
            System.err.println("No post process knowledge file specified.  Using " + post_process_knowledge_file + ".");
        }
        if (cons_on && constituent_knowledge_file == null) {
            constituent_knowledge_file = "4.0.constituent-knowledge";
            System.err.println("No constituent knowledge file specified.  Using " + constituent_knowledge_file + ".");
        }
        try {
            dict = new Dictionary(opts, dictionary_file, post_process_knowledge_file, constituent_knowledge_file, affix_file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (i = 1; i < arg.length; ++i) {
            if (!(arg[i].equals("-pp") || arg[i].equals("-c") || arg[i].equals("-a"))) {
                ++i;
                continue;
            }
            if (arg[i].charAt(0) != '-' || arg[i].equals("-ppoff") || arg[i].equals("-coff") || arg[i].equals("-aoff")) continue;
            opts.issue_special_command(arg[i].substring(1), dict);
        }
    }

    public static void doIt(String[] arg) throws IOException {
        Parser.InitializeVars(arg);
        String testString = "Which camera is small?";
        sent = new Sentence(testString, dict, opts);
        opts.parse_options_set_disjunct_cost(2);
        opts.parse_options_set_min_null_count(0);
        opts.parse_options_set_max_null_count(0);
        opts.parse_options_reset_resources();
        num_linkages = sent.sentence_parse(opts);
        if (num_linkages == 0) {
            opts.parse_options_set_min_null_count(1);
            opts.parse_options_set_max_null_count(sent.sentence_length());
            num_linkages = sent.sentence_parse(opts);
        }
        Linkage myLinkage = new Linkage(0, sent, opts);
        myLinkage.linkage_get_num_sublinkages();
        myLinkage.linkage_set_current_sublinkage(0);
        int numLinks = myLinkage.linkage_get_num_links();
        for (int linkIndex = 0; linkIndex < numLinks; ++linkIndex) {
            int rWordIndex = myLinkage.linkage_get_link_rword(linkIndex);
            int lWordIndex = myLinkage.linkage_get_link_lword(linkIndex);
            String rightWord = myLinkage.word.get(rWordIndex);
            String leftWord = myLinkage.word.get(lWordIndex);
            String linkLabel = myLinkage.linkage_get_link_label(linkIndex);
            Parser.opts.out.println(leftWord + "---" + linkLabel + "---" + rightWord);
        }
        while (GlobalBean.fget_input_string(input_string, Parser.opts.input, Parser.opts.out, opts)) {
            if (input_string.length() == 0) continue;
            if (input_string.equals("quit\n") || input_string.equals("exit\n")) break;
            if (GlobalBean.special_command(input_string, dict)) continue;
            if (opts.parse_options_get_echo_on()) {
                Parser.opts.out.println(input_string);
            }
            if (opts.parse_options_get_batch_mode()) {
                label = GlobalBean.strip_off_label(input_string);
            }
            if ((sent = new Sentence(input_string.toString(), dict, opts)).sentence_length() > opts.parse_options_get_max_sentence_length()) {
                if (Parser.opts.verbosity <= 0) continue;
                Parser.opts.out.println("Sentence length (" + sent.sentence_length() + " words) exceeds maximum allowable (" + opts.parse_options_get_max_sentence_length() + " words)");
                continue;
            }
            opts.parse_options_set_disjunct_cost(2);
            opts.parse_options_set_min_null_count(0);
            opts.parse_options_set_max_null_count(0);
            opts.parse_options_reset_resources();
            num_linkages = sent.sentence_parse(opts);
            if (num_linkages == 0 && !opts.parse_options_get_batch_mode()) {
                if (Parser.opts.verbosity > 0) {
                    Parser.opts.out.println("No complete linkages found.");
                }
                if (opts.parse_options_get_allow_null()) {
                    opts.parse_options_set_min_null_count(1);
                    opts.parse_options_set_max_null_count(sent.sentence_length());
                    num_linkages = sent.sentence_parse(opts);
                }
            }
            opts.print_total_time();
            if (opts.parse_options_get_batch_mode()) {
                GlobalBean.batch_process_some_linkages(label, sent, opts);
                continue;
            }
            GlobalBean.process_some_linkages(sent, opts);
        }
        if (opts.parse_options_get_batch_mode()) {
            opts.print_time("Total");
            Parser.opts.out.println("" + GlobalBean.batch_errors + " error" + (GlobalBean.batch_errors == 1 ? "" : "s") + ".");
        }
    }

    public void printWordsLabelsAndLinks(Sentence sent) {
        if (sent.sentence_num_linkages_found() > 0) {
            int num_to_query = Math.min(sent.sentence_num_linkages_post_processed(), 1000);
            for (int i = 0; i < num_to_query; ++i) {
                int first_sublinkage;
                if (sent.sentence_num_violations(i) > 0 && !opts.parse_options_get_display_bad()) continue;
                Linkage linkage = new Linkage(i, sent, opts);
                linkage.linkage_compute_union();
                int numLinkages = linkage.linkage_get_num_sublinkages();
                for (int j = first_sublinkage = numLinkages - 1; j < numLinkages; ++j) {
                    CNode root;
                    linkage.linkage_set_current_sublinkage(j);
                    CNode current = root = linkage.linkage_constituent_tree();
                    int w = 0;
                    do {
                        Parser.opts.out.println(linkage.word.get(w++).toString());
                        Parser.displayCNode(current);
                    } while (current.next != null);
                }
            }
        }
    }

    private static void print_usage(String arg) {
        System.out.println(arg);
    }

    private static void displayCNode(CNode current) {
        System.out.println(current.label);
    }

    static {
        dictionary_file = null;
        post_process_knowledge_file = null;
        constituent_knowledge_file = null;
        affix_file = null;
        pp_on = true;
        af_on = true;
        cons_on = true;
        input_string = new StringBuffer();
        label = -5;
    }
}

