/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.io.InputStream;
import java.io.PrintStream;
import java.util.Comparator;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Exp;
import net.sf.jlinkgrammar.ExpList;
import net.sf.jlinkgrammar.LinkageInfo;
import net.sf.jlinkgrammar.Resources;
import net.sf.jlinkgrammar.VDALCostModel;

public class ParseOptions {
    public int verbosity = 0;
    public int linkage_limit = 100;
    public int disjunct_cost = 10000;
    public int min_null_count = 0;
    public int max_null_count = 0;
    public int null_block = 1;
    public boolean islands_ok = false;
    public int twopass_length = 30;
    public int max_sentence_length = 70;
    public int short_length = 6;
    public boolean all_short = false;
    public Comparator<LinkageInfo> cost_model;
    public Resources resources;
    public boolean display_short = true;
    public boolean display_word_subscripts = true;
    public boolean display_link_subscripts = true;
    public boolean display_walls = false;
    public boolean display_union = false;
    public boolean allow_null = true;
    public boolean echo_on = false;
    public boolean batch_mode = false;
    public int screen_width = 79;
    public boolean display_on = true;
    public boolean display_postscript = false;
    public int display_constituents = 0;
    public boolean display_bad = false;
    public boolean display_links = false;
    public InputStream input;
    public PrintStream out;
    Switch[] default_switches = new Switch[]{new Switch("verbosity", false, "Level of detail in output", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.verbosity = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.verbosity;
        }
    }), new Switch("limit", false, "The maximum linkages processed", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.linkage_limit = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.linkage_limit;
        }
    }), new Switch("null-block", false, "Size of blocks with null cost true", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.null_block = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.null_block;
        }
    }), new Switch("islands-ok", true, "Use of null-linked islands", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.islands_ok = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.islands_ok;
        }
    }), new Switch("short", false, "Max length of short links", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.short_length = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.short_length;
        }
    }), new Switch("batch", true, "Batch mode", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.batch_mode = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.batch_mode;
        }
    }), new Switch("null", true, "Null links", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.allow_null = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.allow_null;
        }
    }), new Switch("width", false, "The width of the display", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.screen_width = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.screen_width;
        }
    }), new Switch("echo", true, "Echoing of input sentence", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.echo_on = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.echo_on;
        }
    }), new Switch("graphics", true, "Graphical display of linkage", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_on = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_on;
        }
    }), new Switch("postscript", true, "Generate postscript output", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_postscript = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_postscript;
        }
    }), new Switch("constituents", false, "Generate constituent output", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.display_constituents = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.display_constituents;
        }
    }), new Switch("max-length", false, "Maximum sentence length", new Setter(){

        @Override
        public void set(int value) {
            ParseOptions.this.max_sentence_length = value;
        }

        @Override
        public int get() {
            return ParseOptions.this.max_sentence_length;
        }
    }), new Switch("bad", true, "Display of bad linkages", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_bad = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_bad;
        }
    }), new Switch("links", true, "Showing of complete link data", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_links = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_links;
        }
    }), new Switch("walls", true, "Showing of wall words", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_walls = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_walls;
        }
    }), new Switch("union", true, "Showing of 'union' linkage", new BooleanSetter(){

        @Override
        public void set(boolean value) {
            ParseOptions.this.display_union = value;
        }

        @Override
        public boolean getBoolean() {
            return ParseOptions.this.display_union;
        }
    })};
    static UserCommand[] user_command = new UserCommand[]{new UserCommand("variables", "List user-settable variables and their functions"), new UserCommand("help", "List the commands and what they do")};

    public ParseOptions() {
        this.cost_model = new VDALCostModel();
        this.resources = new Resources();
        this.out = System.out;
        this.input = System.in;
    }

    public void parse_options_set_cost_model_type(ParseOptions opts, int cm) {
        switch (cm) {
            case 1: {
                this.cost_model = new VDALCostModel();
                break;
            }
            default: {
                throw new RuntimeException("Illegal cost model: " + cm);
            }
        }
    }

    public void parse_options_set_verbosity(int dummy) {
        this.verbosity = dummy;
    }

    public int parse_options_get_verbosity() {
        return this.verbosity;
    }

    public void parse_options_set_linkage_limit(int dummy) {
        this.linkage_limit = dummy;
    }

    public int parse_options_get_linkage_limit() {
        return this.linkage_limit;
    }

    public void parse_options_set_disjunct_cost(int dummy) {
        this.disjunct_cost = dummy;
    }

    public int parse_options_get_disjunct_cost() {
        return this.disjunct_cost;
    }

    public void parse_options_set_min_null_count(int val) {
        this.min_null_count = val;
    }

    public int parse_options_get_min_null_count() {
        return this.min_null_count;
    }

    public void parse_options_set_max_null_count(int val) {
        this.max_null_count = val;
    }

    public int parse_options_get_max_null_count() {
        return this.max_null_count;
    }

    public void parse_options_set_null_block(int dummy) {
        this.null_block = dummy;
    }

    public int parse_options_get_null_block() {
        return this.null_block;
    }

    public void parse_options_set_islands_ok(boolean dummy) {
        this.islands_ok = dummy;
    }

    public boolean parse_options_get_islands_ok() {
        return this.islands_ok;
    }

    public void parse_options_set_short_length(int short_length) {
        this.short_length = short_length;
    }

    public int parse_options_get_short_length() {
        return this.short_length;
    }

    public void parse_options_set_all_short_connectors(boolean val) {
        this.all_short = val;
    }

    boolean parse_options_get_all_short_connectors() {
        return this.all_short;
    }

    public void parse_options_set_max_sentence_length(int dummy) {
        this.max_sentence_length = dummy;
    }

    public int parse_options_get_max_sentence_length() {
        return this.max_sentence_length;
    }

    public void parse_options_set_echo_on(boolean dummy) {
        this.echo_on = dummy;
    }

    public boolean parse_options_get_echo_on() {
        return this.echo_on;
    }

    public void parse_options_set_batch_mode(boolean dummy) {
        this.batch_mode = dummy;
    }

    public boolean parse_options_get_batch_mode() {
        return this.batch_mode;
    }

    public void parse_options_set_allow_null(boolean dummy) {
        this.allow_null = dummy;
    }

    public boolean parse_options_get_allow_null() {
        return this.allow_null;
    }

    public void parse_options_set_screen_width(int dummy) {
        this.screen_width = dummy;
    }

    public int parse_options_get_screen_width() {
        return this.screen_width;
    }

    public void parse_options_set_display_on(boolean dummy) {
        this.display_on = dummy;
    }

    public boolean parse_options_get_display_on() {
        return this.display_on;
    }

    public void parse_options_set_display_postscript(boolean dummy) {
        this.display_postscript = dummy;
    }

    public boolean parse_options_get_display_postscript() {
        return this.display_postscript;
    }

    public void parse_options_set_display_constituents(ParseOptions opts, int dummy) {
        if (dummy < 0 || dummy > 2) {
            System.err.println("Possible values for constituents: ");
            System.err.println("   0 (no display) 1 (treebank style) or 2 (flat tree)");
            this.display_constituents = 0;
        } else {
            this.display_constituents = dummy;
        }
    }

    public int parse_options_get_display_constituents() {
        return this.display_constituents;
    }

    public void parse_options_set_display_bad(boolean dummy) {
        this.display_bad = dummy;
    }

    public boolean parse_options_get_display_bad() {
        return this.display_bad;
    }

    public void parse_options_set_display_links(boolean dummy) {
        this.display_links = dummy;
    }

    public boolean parse_options_get_display_links() {
        return this.display_links;
    }

    public void parse_options_set_display_walls(boolean dummy) {
        this.display_walls = dummy;
    }

    public boolean parse_options_get_display_walls() {
        return this.display_walls;
    }

    public void parse_options_set_display_union(boolean dummy) {
        this.display_union = dummy;
    }

    public boolean parse_options_get_display_union() {
        return this.display_union;
    }

    public void parse_options_reset_resources() {
        this.resources.reset();
    }

    public void clean_up_string(StringBuffer s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                s.deleteCharAt(i);
                continue;
            }
            ++i;
        }
    }

    public void issue_special_command(String line, Dictionary dict) {
        int i;
        StringBuffer myline = new StringBuffer(line);
        Switch[] as = this.default_switches;
        this.clean_up_string(myline);
        String s = myline.toString();
        int k = -1;
        int j = -1;
        int count = 0;
        for (i = 0; i < as.length; ++i) {
            if (!as[i].isboolean || !as[i].string.startsWith(s)) continue;
            ++count;
            j = i;
        }
        for (i = 0; i < user_command.length; ++i) {
            if (!ParseOptions.user_command[i].s.startsWith(s)) continue;
            ++count;
            k = i;
        }
        if (count > 1) {
            this.out.println("Ambiguous command.  Type \"!help\" or \"!variables\"");
            return;
        }
        if (count == 1) {
            if (j >= 0) {
                int b = as[j].p.get() == 0 ? 1 : 0;
                as[j].p.set(b);
                this.out.println(as[j].description + " turned " + (as[j].p.get() != 0 ? "on" : "off") + ".");
                return;
            }
            s = ParseOptions.user_command[k].s;
        }
        if (s.equals("variables")) {
            this.out.println(" Variable     Controls                                      Value");
            this.out.println(" --------     --------                                      -----");
            for (i = 0; i < as.length; ++i) {
                this.out.print(" ");
                this.left_print_string(as[i].string, "             ");
                this.left_print_string(as[i].description, "                                              ");
                if (as[i].isboolean) {
                    if (as[i].p.get() != 0) {
                        this.out.print(" (On)");
                    } else {
                        this.out.print(" (Off)");
                    }
                } else {
                    this.out.print(as[i].p.get());
                }
                this.out.println();
            }
            this.out.println();
            this.out.print("Toggle a boolean variable as in \"!batch\"; ");
            this.out.println("set a variable as in \"!width=100\".");
            return;
        }
        if (s.equals("help")) {
            this.out.println("Special commands always begin with \"!\".  Command and variable names");
            this.out.println("can be abbreviated.  Here is a list of the commands:");
            for (i = 0; i < user_command.length; ++i) {
                this.out.print(" !");
                this.left_print_string(ParseOptions.user_command[i].s, "                  ");
                this.left_print_string(ParseOptions.user_command[i].str, "                                                    ");
                this.out.println();
            }
            this.out.println(" !!<string>         Print all the dictionary words matching <string>.");
            this.out.println("                    Also print the number of disjuncts of each.");
            this.out.println();
            this.out.println(" !<var>             Toggle the specified boolean variable.");
            this.out.println(" !<var>=<val>       Assign that value to that variable.");
            return;
        }
        if (s.charAt(0) == '!') {
            dict.dict_display_word_info(s.substring(1));
            return;
        }
        int ix = s.indexOf(61);
        if (ix > 0) {
            String x = s.substring(0, ix);
            String y = s.substring(ix + 1);
            if (this.is_numerical_rhs(y)) {
                for (i = 0; i < as.length && !x.equals(as[i].string); ++i) {
                }
                if (as[i].string == null) {
                    this.out.println("There is no user variable called \"" + x + "\".");
                } else {
                    try {
                        as[i].p.set(Integer.parseInt(y));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Error parsing " + y);
                    }
                    this.out.println(x + " set to " + y);
                }
                return;
            }
        }
        this.out.println("I can't interpret \"" + myline + "\" as a command.  Try \"!help\".");
    }

    void print_time(String s) {
        this.resources.printTime(this, s);
    }

    void print_total_time() {
        this.resources.printTotalTime(this);
    }

    boolean is_numerical_rhs(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public void left_print_string(String s, String t) {
        int j = t.length();
        int k = s.length();
        for (int i = 0; i < j; ++i) {
            if (i < k) {
                this.out.print(s.charAt(i));
                continue;
            }
            this.out.print(t.charAt(i));
        }
    }

    public void print_expression(Exp n) {
        if (n == null) {
            this.out.print("null expression");
            return;
        }
        if (n.type == 2) {
            int i;
            for (i = 0; i < n.cost; ++i) {
                this.out.print("[");
            }
            this.out.print(n.string + n.dir);
            for (i = 0; i < n.cost; ++i) {
                this.out.print("]");
            }
        } else {
            int i;
            for (i = 0; i < n.cost; ++i) {
                this.out.print("[");
            }
            if (n.cost == 0) {
                this.out.print("(");
            }
            ExpList el = n.l;
            while (el != null) {
                this.print_expression(el.e);
                if (el.next != null) {
                    if (n.type == 1) {
                        this.out.print(" & ");
                    }
                    if (n.type == 0) {
                        this.out.print(" | ");
                    }
                }
                el = el.next;
            }
            for (i = 0; i < n.cost; ++i) {
                this.out.print("]");
            }
            if (n.cost == 0) {
                this.out.print(")");
            }
        }
    }

    static class UserCommand {
        String s;
        String str;

        UserCommand(String s, String str) {
            this.s = s;
            this.str = str;
        }
    }

    class Switch {
        String string;
        boolean isboolean;
        String description;
        Setter p;

        Switch(String string, boolean isboolean, String description, Setter p) {
            this.string = string;
            this.isboolean = isboolean;
            this.description = description;
            this.p = p;
        }
    }

    abstract class BooleanSetter
    implements Setter {
        BooleanSetter() {
        }

        @Override
        public void set(int value) {
            this.set(value != 0);
        }

        @Override
        public int get() {
            return this.getBoolean() ? 1 : 0;
        }

        abstract void set(boolean var1);

        abstract boolean getBoolean();
    }

    public static interface Setter {
        public void set(int var1);

        public int get();
    }
}

