/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.Arrays;
import net.sf.jlinkgrammar.PPLinksetNode;
import net.sf.jlinkgrammar.Postprocessor;

public class PPLinkset {
    int hash_table_size;
    int population;
    PPLinksetNode[] hash_table;

    static PPLinkset PPLinkset_open(int size) {
        if (size == 0) {
            return null;
        }
        PPLinkset ls = new PPLinkset();
        PPLinkset.initialize(ls, size);
        return ls;
    }

    static void initialize(PPLinkset ls, int size) {
        ls.hash_table_size = size * 2;
        ls.population = 0;
        ls.hash_table = new PPLinksetNode[ls.hash_table_size];
        PPLinkset.clear_hash_table(ls);
    }

    static int PPLinkset_add(PPLinkset ls, String str) {
        if (ls == null) {
            throw new RuntimeException("PPLinkset internal error: Trying to add to a null set");
        }
        if (PPLinkset.add_internal(ls, str) == null) {
            return 0;
        }
        ++ls.population;
        return 1;
    }

    static boolean PPLinkset_match(PPLinkset ls, String str) {
        if (ls == null) {
            return false;
        }
        int hashval = PPLinkset.compute_hash(ls, str);
        PPLinksetNode p = ls.hash_table[hashval];
        while (p != null) {
            if (Postprocessor.post_process_match(p.str, str)) {
                return true;
            }
            p = p.next;
        }
        return false;
    }

    static boolean PPLinkset_match_bw(PPLinkset ls, String str) {
        if (ls == null) {
            return false;
        }
        int hashval = PPLinkset.compute_hash(ls, str);
        PPLinksetNode p = ls.hash_table[hashval];
        while (p != null) {
            if (Postprocessor.post_process_match(str, p.str)) {
                return true;
            }
            p = p.next;
        }
        return false;
    }

    static int PPLinkset_population(PPLinkset ls) {
        return ls == null ? 0 : ls.population;
    }

    static PPLinksetNode add_internal(PPLinkset ls, String str) {
        int hashval = PPLinkset.compute_hash(ls, str);
        PPLinksetNode p = ls.hash_table[hashval];
        while (p != null) {
            if (p.str.equals(str)) {
                return null;
            }
            p = p.next;
        }
        PPLinksetNode n = new PPLinksetNode();
        n.next = ls.hash_table[hashval];
        n.str = str;
        ls.hash_table[hashval] = n;
        return n;
    }

    static int compute_hash(PPLinkset ls, String str) {
        int hashval = 37;
        for (int i = 0; i < str.length() && Character.isUpperCase(str.charAt(i)); ++i) {
            hashval = str.charAt(i) + 31 * hashval;
        }
        if ((hashval %= ls.hash_table_size) < 0) {
            hashval = -hashval;
        }
        return hashval;
    }

    static void PPLinkset_clear(PPLinkset ls) {
        if (ls == null) {
            return;
        }
        PPLinkset.clear_hash_table(ls);
        ls.population = 0;
    }

    static void clear_hash_table(PPLinkset ls) {
        Arrays.fill(ls.hash_table, null);
    }
}

