/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.xml.ElementProcessor;
import edu.northwestern.at.utils.xml.SchemaUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.contrib.schema.Schema;
import org.jdom2.contrib.schema.ValidationError;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDOMUtils {
    public static Document parse(File file) throws IOException, JDOMException, SAXException {
        SAXBuilder builder = new SAXBuilder();
        return builder.build(file);
    }

    public static Document parse(String path) throws IOException, JDOMException, SAXException {
        return JDOMUtils.parse(new File(path));
    }

    public static Document parse(URL url) throws IOException, JDOMException, SAXException {
        return new SAXBuilder().build(url.openStream());
    }

    public static Document parseText(String text) throws IOException, JDOMException, SAXException {
        return new SAXBuilder().build(new InputSource(new StringReader(text)));
    }

    public static Attribute getAttribute(Element element, String attributeName, boolean ignoreCase) {
        Attribute result = null;
        if (element != null) {
            List attributeList = element.getAttributes();
            String name = attributeName;
            if (ignoreCase) {
                name = name.toLowerCase();
            }
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                String attName = attribute.getQualifiedName();
                if (ignoreCase) {
                    attName = attName.toLowerCase();
                }
                if (!attName.equals(name)) continue;
                result = attribute;
                break;
            }
        }
        return result;
    }

    public static String getAttributeValue(Element element, String attributeName, boolean ignoreCase) {
        String result = null;
        Attribute attribute = JDOMUtils.getAttribute(element, attributeName, ignoreCase);
        if (attribute != null) {
            result = attribute.getValue();
        }
        return result;
    }

    public static String getAttributeValueIgnoreCase(Element element, String attributeName) {
        return JDOMUtils.getAttributeValue(element, attributeName, true);
    }

    public static Map<String, String> getAttributeValues(Element element) {
        Map<String, String> result = MapFactory.createNewMap();
        if (element != null) {
            List attributeList = element.getAttributes();
            for (int i = 0; i < attributeList.size(); ++i) {
                Attribute attribute = (Attribute)attributeList.get(i);
                result.put(attribute.getQualifiedName(), attribute.getValue());
            }
        }
        return result;
    }

    public static void setAttributeValue(Element element, String attributeName, String attributeValue) {
        Attribute attribute = JDOMUtils.getAttribute(element, attributeName, false);
        if (attribute != null) {
            attribute.setValue(attributeValue);
        } else {
            if (attributeName.indexOf(":") > 0) {
                String[] name = attributeName.split(":");
                attribute = new Attribute(name[1], attributeValue, Namespace.XML_NAMESPACE);
            } else {
                attribute = new Attribute(attributeName, attributeValue);
            }
            element.setAttribute(attribute);
        }
    }

    public static void removeAttribute(Element element, String attributeName) {
        if (element == null || attributeName == null) {
            return;
        }
        if (attributeName.indexOf(":") > 0) {
            String[] name = attributeName.split(":");
            element.removeAttribute(name[1], Namespace.XML_NAMESPACE);
        } else {
            element.removeAttribute(attributeName);
        }
    }

    public static void applyElementFilter(Document document, Filter<Element> filter, ElementProcessor processor) {
        List<Element> elements = ListFactory.createNewList();
        IteratorIterable iterator = document.getRootElement().getDescendants(filter);
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            elements.add(element);
        }
        for (int i = 0; i < elements.size(); ++i) {
            processor.processElement(document, (Element)elements.get(i));
        }
    }

    public static void save(Document document, String path, Format format) throws FileNotFoundException, IOException {
        XMLOutputter xmlOut = new XMLOutputter(format);
        FileOutputStream outputStream = new FileOutputStream(new File(path), false);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outputStream);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
        xmlOut.output(document, (Writer)writer);
        writer.close();
    }

    public static String saveToString(Document document, Format format) throws FileNotFoundException, IOException {
        XMLOutputter xmlOut = new XMLOutputter(format);
        StringWriter writer = new StringWriter();
        xmlOut.output(document, (Writer)writer);
        writer.close();
        return writer.toString();
    }

    public static void savePretty(Document document, String path) throws FileNotFoundException, IOException {
        JDOMUtils.save(document, path, Format.getPrettyFormat());
    }

    public static void saveRaw(Document document, String path) throws FileNotFoundException, IOException {
        JDOMUtils.save(document, path, Format.getRawFormat());
    }

    public static void saveRawCompressed(Document document, String path) throws FileNotFoundException, IOException {
        XMLOutputter xmlOut = new XMLOutputter(Format.getRawFormat());
        FileOutputStream outputStream = new FileOutputStream(new File(path), false);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(new GZIPOutputStream(outputStream));
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bufferedStream, "utf-8");
        xmlOut.output(document, (Writer)writer);
        writer.close();
    }

    public static List<ValidationError> validateDocument(Document document, String schemaURI) throws JDOMException, IOException {
        List<ValidationError> result = null;
        if (schemaURI != null && schemaURI.length() > 0) {
            Schema schema = SchemaUtils.parseSchema(schemaURI);
            result = JDOMUtils.validateDocument(document, schema);
        }
        return result;
    }

    public static List<ValidationError> validateDocument(Document document, Schema schema) throws JDOMException, IOException {
        return schema.validate(document);
    }

    protected JDOMUtils() {
    }
}

