/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JDOMFragmentParser {
    protected String _xml;
    protected SAXBuilder _builder;
    protected String _fragment = null;

    public JDOMFragmentParser(Namespace[] namespaces) {
        StringBuffer buf = new StringBuffer();
        buf.append("<!DOCTYPE root [<!ENTITY fragment  SYSTEM 'file:fragment.xml' >]><root ");
        for (int i = 0; i < namespaces.length; ++i) {
            buf.append("xmlns:");
            buf.append(namespaces[i].getPrefix());
            buf.append("=\"");
            buf.append(namespaces[i].getURI());
            buf.append("\" ");
        }
        buf.append(">&fragment;</root>");
        this._xml = buf.toString();
        this._builder = new SAXBuilder();
        this._builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (JDOMFragmentParser.this._fragment != null) {
                    return new InputSource(new StringReader(JDOMFragmentParser.this._fragment));
                }
                return null;
            }
        });
    }

    public List<Element> parseFragment(String fragment) throws Exception {
        try {
            this._fragment = fragment;
            Document doc = this._builder.build((Reader)new StringReader(this._xml));
            ArrayList<Element> list = new ArrayList<Element>(doc.getRootElement().getChildren());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                ((Element)i.next()).detach();
            }
            this._fragment = null;
            ArrayList<Element> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this._fragment = null;
        }
    }
}

