/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.servlets;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.TextFile;
import edu.northwestern.at.utils.UTF8Properties;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.List;

public class HtmlTemplate {
    protected TextFile template = null;

    public HtmlTemplate(String templateFileName, String encoding) {
        this.template = new TextFile(templateFileName, encoding);
    }

    public HtmlTemplate(URL templateURL, String encoding) {
        this.template = new TextFile(templateURL, encoding);
    }

    public synchronized void outputTemplate(PrintWriter writer, UTF8Properties templateProperties) throws IOException {
        if (!this.template.textLoaded()) {
            return;
        }
        String[] templateLines = this.template.toArray();
        for (int i = 0; i < templateLines.length; ++i) {
            String templateLine = templateLines[i];
            if (templateProperties != null) {
                List<String> properties = ListFactory.createNewList(templateProperties.getAllStrings());
                int propertyIndex = -1;
                String propertyName = "";
                String propertyValue = "";
                for (int j = 0; j < properties.size(); ++j) {
                    propertyName = properties.get(j);
                    propertyValue = templateProperties.getProperty(propertyName);
                    propertyIndex = templateLine.indexOf(propertyName);
                    while (propertyIndex >= 0) {
                        try {
                            templateLine = templateLine.substring(0, propertyIndex) + propertyValue + templateLine.substring(propertyIndex + propertyName.length());
                            propertyIndex = templateLine.indexOf(propertyName);
                        }
                        catch (Exception e) {
                            propertyIndex = -1;
                        }
                    }
                }
            }
            writer.println(templateLine);
        }
        writer.flush();
    }
}

