/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.rootfinders;

import edu.northwestern.at.utils.math.Constants;
import edu.northwestern.at.utils.math.MonadicFunction;
import edu.northwestern.at.utils.math.rootfinders.MonadicFunctionRootFinder;
import edu.northwestern.at.utils.math.rootfinders.RootFinderConvergenceTest;
import edu.northwestern.at.utils.math.rootfinders.RootFinderIterationInformation;
import edu.northwestern.at.utils.math.rootfinders.StandardRootFinderConvergenceTest;

public class NewtonRaphson
implements MonadicFunctionRootFinder {
    public static double newtonRaphson(double x0, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null");
        }
        if (derivativeFunction == null) {
            throw new IllegalArgumentException("Derivative function cannot be null");
        }
        double x = x0;
        for (int iter = 0; iter < maxIter; ++iter) {
            double xPrevious = x;
            double fx = function.f(xPrevious);
            double dfx = derivativeFunction.f(xPrevious);
            x = xPrevious - fx / dfx;
            if (iterationInformation != null) {
                iterationInformation.iterationInformation(x, fx, dfx, iter);
            }
            if (convergenceTest.converged(x, xPrevious, fx, tol, tol)) break;
        }
        return x;
    }

    public static double newtonRaphson(double x0, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction) throws IllegalArgumentException {
        return NewtonRaphson.newtonRaphson(x0, tol, maxIter, function, derivativeFunction, new StandardRootFinderConvergenceTest(), null);
    }

    public static double newtonRaphson(double x0, MonadicFunction function, MonadicFunction derivativeFunction) throws IllegalArgumentException {
        return NewtonRaphson.newtonRaphson(x0, Constants.MACHEPS, 100, function, derivativeFunction, new StandardRootFinderConvergenceTest(), null);
    }

    @Override
    public double findRoot(double x0, double x1, double tol, int maxIter, MonadicFunction function, MonadicFunction derivativeFunction, RootFinderConvergenceTest convergenceTest, RootFinderIterationInformation iterationInformation) throws IllegalArgumentException {
        return NewtonRaphson.newtonRaphson(x0, tol, maxIter, function, derivativeFunction, convergenceTest, iterationInformation);
    }
}

