/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.math.rootfinders;

import edu.northwestern.at.utils.math.MonadicFunction;

public class BracketRoot {
    public static boolean bracketRoot(double[] bracket, MonadicFunction function, int maxIter, double expansionFactor) {
        if (bracket == null || bracket.length < 2 || bracket[0] == bracket[1]) {
            throw new IllegalArgumentException("initial bracket bad");
        }
        double fLeft = function.f(bracket[0]);
        double fRight = function.f(bracket[1]);
        for (int iter = 1; iter <= maxIter; ++iter) {
            if (fLeft * fRight < 0.0) {
                return true;
            }
            if (Math.abs(fLeft) < Math.abs(fRight)) {
                bracket[0] = expansionFactor * (bracket[0] - bracket[1]);
                fLeft = function.f(bracket[0]);
                continue;
            }
            bracket[1] = expansionFactor * (bracket[1] - bracket[0]);
            fRight = function.f(bracket[1]);
        }
        return false;
    }
}

