/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.logger;

import edu.northwestern.at.utils.StringUtils;
import edu.northwestern.at.utils.logger.Logger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class LoggerUtils {
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd hh:mm:ss,SSS";
    public static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");

    public static void logByteArray(Logger logger, int logLevelTitle, int logLevelData, String arrayLabel, byte[] bytes, int nBytes, int pctPrintable) {
        int i;
        logger.log(logLevelTitle, "[" + arrayLabel + ", (" + nBytes + " bytes)]");
        StringBuffer sb = new StringBuffer(nBytes);
        StringBuffer pb = new StringBuffer(4 * nBytes);
        String hb = new String();
        String tb = new String();
        int column = 0;
        int charCount = 0;
        float binCharCount = 0.0f;
        for (i = 0; i < nBytes; ++i) {
            int value = bytes[i] & 0xFF;
            if (value == 13 || value == 10 || value == 9 || value >= 32 && value <= 126) {
                sb.append((char)value);
            } else {
                sb.append("[" + StringUtils.zeroPad(Integer.toHexString(value), 2) + "]");
                binCharCount += 1.0f;
            }
            tb = value >= 32 && value <= 126 ? tb + (char)value : tb + ".";
            hb = hb + StringUtils.zeroPad(Integer.toHexString(value), 2);
            if (column == 3 || column == 7 || column == 11) {
                hb = hb + " ";
                tb = tb + " ";
            }
            if (column == 15) {
                pb.append(StringUtils.zeroPad(Integer.toHexString(charCount), 4) + ":  " + hb + "    " + tb + "\n");
                column = 0;
                charCount += 16;
                hb = "";
                tb = "";
                continue;
            }
            ++column;
        }
        for (i = hb.length(); i < 35; ++i) {
            hb = hb + " ";
        }
        pb.append(StringUtils.zeroPad(Integer.toHexString(charCount), 4) + ":  " + hb + "    " + tb + "\n");
        if (binCharCount / (float)nBytes * 100.0f < (float)pctPrintable) {
            logger.log(logLevelTitle, sb.toString());
        } else {
            logger.log(logLevelData, pb.toString());
        }
    }

    public static <K, V> void logMap(Logger logger, int level, String mapLabel, Map<K, V> map) {
        if (map == null) {
            logger.log(level, mapLabel + " is null.");
        } else if (map.size() == 0) {
            logger.log(level, mapLabel + " is empty.");
        } else {
            logger.log(level, mapLabel);
            Iterator<K> iterator = map.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                K key = iterator.next();
                V value = map.get(key);
                if (key == null) {
                    if (value == null) {
                        logger.log(level, i + ": null=null");
                    } else {
                        logger.log(level, i + ": null=" + value.toString());
                    }
                } else if (value == null) {
                    logger.log(level, i + ": " + key.toString() + "=null");
                } else {
                    logger.log(level, i + ": " + key.toString() + "=" + value.toString());
                }
                ++i;
            }
        }
    }

    public static void logArray(Logger logger, int level, String arrayLabel, Object[] array) {
        if (array == null) {
            logger.log(level, arrayLabel + " is null.");
        } else if (array.length == 0) {
            logger.log(level, arrayLabel + " is empty.");
        } else {
            logger.log(level, arrayLabel);
            for (int i = 0; i < array.length; ++i) {
                Object value = array[i];
                if (value == null) {
                    logger.log(level, i + ": null");
                    continue;
                }
                logger.log(level, i + ": " + value.toString());
            }
        }
    }

    public static String getFormattedCurrentDateAndTime() {
        return DATE_TIME_FORMATTER.format(new Date());
    }

    protected LoggerUtils() {
    }
}

