/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.logger;

import edu.northwestern.at.utils.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;

public class BaseLogger
implements Logger {
    protected org.apache.log4j.Logger logger;
    protected boolean loggerEnabled = false;
    protected Object lock = new Object();

    public BaseLogger(String logClassName, String logPath, String logConfigFilePath) throws FileNotFoundException, IOException {
        this.logger = org.apache.log4j.Logger.getLogger((String)logClassName);
        Properties properties = new Properties();
        properties.load(new FileInputStream(logConfigFilePath));
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith("log4j.appender") || !key.endsWith(".File")) continue;
            String val = properties.getProperty(key);
            val = logPath + File.separatorChar + val;
            properties.setProperty(key, val);
        }
        PropertyConfigurator.configure((Properties)properties);
        this.loggerEnabled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.lock;
        synchronized (object) {
            if (this.loggerEnabled) {
                this.loggerEnabled = false;
                BaseLogger baseLogger = this;
                baseLogger.logger.shutdown();
            }
        }
    }

    protected static Priority mapLevel(int level) {
        switch (level) {
            case 0: {
                return Level.FATAL;
            }
            case 1: {
                return Level.ERROR;
            }
            case 2: {
                return Level.WARN;
            }
            case 3: {
                return Level.INFO;
            }
            case 4: {
                return Level.DEBUG;
            }
        }
        return Level.ERROR;
    }

    @Override
    public void logDebug(String str) {
        this.logger.log((Priority)Level.DEBUG, (Object)str);
    }

    @Override
    public void logInfo(String str) {
        this.logger.log((Priority)Level.INFO, (Object)str);
    }

    @Override
    public void logWarning(String str) {
        this.logger.log((Priority)Level.WARN, (Object)str);
    }

    @Override
    public void logError(String str) {
        this.logger.log((Priority)Level.ERROR, (Object)str);
    }

    @Override
    public void logError(String str, Throwable t) {
        this.logger.log((Priority)Level.ERROR, (Object)str, t);
    }

    @Override
    public void logFatal(String str) {
        this.logger.log((Priority)Level.FATAL, (Object)str);
    }

    @Override
    public void logFatal(String str, Throwable t) {
        this.logger.log((Priority)Level.FATAL, (Object)str, t);
    }

    @Override
    public void log(int level, String str) {
        this.logger.log(BaseLogger.mapLevel(level), (Object)str);
    }

    @Override
    public void log(int level, String str, Throwable t) {
        this.logger.log(BaseLogger.mapLevel(level), (Object)str, t);
    }

    @Override
    public boolean isDebuggingEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isLoggerEnabled() {
        return this.loggerEnabled;
    }
}

