/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.html;

import edu.northwestern.at.utils.StringUtils;

public class HTMLUtils {
    public static boolean isHTMLTaggedText(String text) {
        boolean result = false;
        if (text != null) {
            result = text.startsWith("<?xml ") || (text.indexOf("<html") != -1 || text.indexOf("<HTML") != -1) && (text.indexOf("</html") != -1 || text.indexOf("</HTML") != -1);
        }
        return result;
    }

    public static String stripHTMLTags(String taggedText) {
        if (taggedText == null) {
            return null;
        }
        taggedText = taggedText.replaceAll("(<script.+?</script>)+", "");
        taggedText = taggedText.replaceAll("(<style.+?</style>)+", "");
        taggedText = taggedText.replaceAll("(<applet.+?</applet>)+", "");
        taggedText = taggedText.replaceAll("(<object.+?</object>)+", "");
        StringBuffer strippedText = new StringBuffer("");
        int tagCount = 0;
        for (int i = 0; i < taggedText.length(); ++i) {
            if (taggedText.charAt(i) == '<') {
                ++tagCount;
                continue;
            }
            if (taggedText.charAt(i) == '>') {
                if (--tagCount >= 0) continue;
                tagCount = 0;
                continue;
            }
            if (tagCount != 0) continue;
            strippedText.append(taggedText.charAt(i));
        }
        return HTMLUtils.unescapeHTML(strippedText.toString());
    }

    public static String escapeHTML(String s) {
        s = StringUtils.replaceAll(s, "&", "&amp;");
        s = StringUtils.replaceAll(s, "<", "&lt;");
        s = StringUtils.replaceAll(s, ">", "&gt;");
        s = StringUtils.replaceAll(s, "\"", "&quot;");
        s = StringUtils.replaceAll(s, "'", "&apos;");
        return s;
    }

    public static String unescapeHTML(String s) {
        s = StringUtils.replaceAll(s, "&amp;", "&");
        s = StringUtils.replaceAll(s, "&lt;", "<");
        s = StringUtils.replaceAll(s, "&gt;", ">");
        s = StringUtils.replaceAll(s, "&quot;", "\"");
        s = StringUtils.replaceAll(s, "&apos;", "'");
        s = StringUtils.replaceAll(s, "&nbsp;", " ");
        return s;
    }

    protected HTMLUtils() {
    }
}

