/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.db.mysql;

import edu.northwestern.at.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class TableExporterImporter {
    private String tableName;
    private String columnNames;
    private String path;
    private PrintWriter writer;
    private boolean newLine = true;

    public TableExporterImporter(String tableName, String columnNames, String path, boolean append) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        this.tableName = tableName;
        this.columnNames = columnNames;
        File file = null;
        file = path == null ? File.createTempFile("TableExporterImporter", ".txt") : new File(path);
        this.path = file.getCanonicalPath();
        FileOutputStream fos = new FileOutputStream(this.path, append);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
        BufferedWriter bw = new BufferedWriter(osw);
        this.writer = new PrintWriter(bw);
    }

    public void print(String val) {
        if (!this.newLine) {
            this.writer.print('\t');
        }
        if (val == null) {
            this.writer.print("\\N");
        } else {
            val = val.replaceAll("\\\\", "\\\\\\\\");
            val = val.replaceAll("\n", "\\\\n");
            this.writer.print(val);
        }
        this.newLine = false;
    }

    public void print(long val) {
        this.print(Long.toString(val));
    }

    public void print(int val) {
        this.print(Integer.toString(val));
    }

    public void print(byte val) {
        this.print(Byte.toString(val));
    }

    public void printNull() {
        if (!this.newLine) {
            this.writer.print('\t');
        }
        this.writer.print("\\N");
        this.newLine = false;
    }

    public void print(Integer val) {
        if (!this.newLine) {
            this.writer.print('\t');
        }
        if (val == null) {
            this.writer.print("\\N");
        } else {
            this.writer.print(val);
        }
        this.newLine = false;
    }

    public void print(Long val) {
        if (!this.newLine) {
            this.writer.print('\t');
        }
        if (val == null) {
            this.writer.print("\\N");
        } else {
            this.writer.print(val);
        }
        this.newLine = false;
    }

    public void println() {
        this.writer.println();
        this.newLine = true;
    }

    public void close() {
        this.writer.close();
    }

    protected String fixPathSeparators(String path) {
        return path.replace('\\', '/');
    }

    public int importData(Connection c) throws SQLException {
        String lineTerm = StringUtils.escapeSpecialCharacters(System.getProperty("line.separator"));
        Statement s = c.createStatement();
        int ct = 0;
        ct = this.columnNames == null ? s.executeUpdate("load data infile '" + this.fixPathSeparators(this.path) + "' into table " + this.tableName + " lines terminated by '" + lineTerm + "'") : s.executeUpdate("load data infile '" + this.fixPathSeparators(this.path) + "' into table " + this.tableName + " lines terminated by '" + lineTerm + "'" + " (" + this.columnNames + ")");
        s.close();
        new File(this.path).delete();
        return ct;
    }
}

