/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils.cache;

import edu.northwestern.at.utils.cache.Cache;
import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SoftReferenceCache<K, V>
implements Cache<K, V> {
    protected Map<K, SoftReference<V>> cacheMap = null;

    public SoftReferenceCache() {
        this.clear();
    }

    @Override
    public void clear() {
        this.cacheMap = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public boolean containsKey(K key) {
        return this.cacheMap.containsKey(key);
    }

    @Override
    public V get(K key) {
        V result = null;
        SoftReference<V> softReference = this.cacheMap.get(key);
        if (softReference != null) {
            V object = softReference.get();
            if (object == null) {
                this.remove(key);
            }
            result = object;
        }
        return result;
    }

    @Override
    public V put(K key, V value) {
        V result = null;
        SoftReference<V> softReference = this.cacheMap.put(key, new SoftReference<V>(value));
        if (softReference != null) {
            result = softReference.get();
        }
        return result;
    }

    @Override
    public V remove(K key) {
        V result = null;
        SoftReference<V> softReference = this.cacheMap.remove(key);
        if (softReference != null) {
            result = softReference.get();
        }
        return result;
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }
}

