/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static void zipDirectoryTree(String inputDirectory, String outputZipFileName) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(outputZipFileName));
        final File outputZipFile = new File(outputZipFileName);
        ZipUtils.zipDirectoryTree(inputDirectory, "", new FilenameFilter(){

            @Override
            public boolean accept(File directory, String name) {
                File testFile = new File(directory, name);
                return !testFile.equals(outputZipFile);
            }
        }, zipOutputStream);
        zipOutputStream.close();
    }

    public static void zipDirectoryTree(String inputDirectory, String parentPath, FilenameFilter filenameFilter, ZipOutputStream zipOutputStream) throws IOException {
        File inputDir = new File(inputDirectory);
        File[] files = inputDir.listFiles();
        if (files != null) {
            byte[] readBuffer = new byte[65536];
            int bytesRead = 0;
            for (File file : files) {
                if (filenameFilter != null && !filenameFilter.accept(inputDir, file.getName())) continue;
                if (file.isDirectory()) {
                    String directoryPath = file.getName();
                    if (parentPath != null && parentPath.length() > 0) {
                        directoryPath = parentPath + "/" + directoryPath;
                    }
                    ZipUtils.zipDirectoryTree(file.getPath(), directoryPath, filenameFilter, zipOutputStream);
                    continue;
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                String entryName = file.getName();
                if (parentPath != null && parentPath.length() > 0) {
                    entryName = parentPath + "/" + entryName;
                }
                ZipEntry zipEntry = new ZipEntry(entryName);
                zipOutputStream.putNextEntry(zipEntry);
                while ((bytesRead = fileInputStream.read(readBuffer)) != -1) {
                    zipOutputStream.write(readBuffer, 0, bytesRead);
                }
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
        }
    }

    protected ZipUtils() {
    }
}

