/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class WhitespaceTrimmingBufferedReader
extends BufferedReader {
    protected char[] oneCharBuffer = new char[1];
    protected char[] lineBuffer = null;
    protected int lineOffset = 0;
    protected int lineLength = 0;

    public WhitespaceTrimmingBufferedReader(Reader reader) {
        super(reader);
    }

    @Override
    public int read() throws IOException {
        int result = this.read(this.oneCharBuffer, 0, 1);
        return result < 0 ? result : this.oneCharBuffer[0];
    }

    @Override
    public int read(char[] buffer, int offset, int length) throws IOException {
        if (this.lineLength <= 0) {
            String line = this.readLine();
            if (line == null) {
                return -1;
            }
            line = line + " ";
            this.lineBuffer = line.toCharArray();
            this.lineOffset = 0;
            this.lineLength = this.lineBuffer.length;
        }
        length = Math.min(length, this.lineLength);
        System.arraycopy(this.lineBuffer, this.lineOffset, buffer, offset, length);
        this.lineOffset += length;
        this.lineLength -= length;
        return length;
    }

    @Override
    public String readLine() throws IOException {
        String line = super.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }
}

