/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.TaggedStrings;
import java.util.Map;
import java.util.Set;

public class TaggedStringsMap
implements TaggedStrings {
    protected Map<String, String> wrappedMap;

    public TaggedStringsMap() {
        this.wrappedMap = MapFactory.createNewMap();
    }

    public TaggedStringsMap(Map<String, String> map) {
        this.wrappedMap = map;
    }

    @Override
    public boolean containsString(String string) {
        return this.wrappedMap.containsKey(string);
    }

    @Override
    public String getTag(String string) {
        String result = null;
        if (this.wrappedMap.containsKey(string)) {
            result = this.wrappedMap.get(string);
        }
        return result;
    }

    @Override
    public void putTag(String string, String tag) {
        this.wrappedMap.put(string, tag);
    }

    @Override
    public int getStringCount() {
        return this.wrappedMap.size();
    }

    @Override
    public Set<String> getAllTags() {
        Set<String> result = SetFactory.createNewSet();
        result.addAll(this.wrappedMap.values());
        return result;
    }

    @Override
    public Set<String> getAllStrings() {
        Set<String> result = SetFactory.createNewSet();
        result.addAll(this.wrappedMap.keySet());
        return result;
    }

    public Map<String, String> getMap() {
        return this.wrappedMap;
    }
}

