/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.ListFactory;
import java.lang.reflect.Array;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class StringUtils {
    public static final String[] asciiControlCharacterNames = new String[]{"<NUL>", "<SOH>", "<STX>", "<ETX>", "<EOT>", "<ENQ>", "<ACK>", "<BEL>", "<BS>", "<HT>", "<LF>", "<VT>", "<FF>", "<CR>", "<SO>", "<SI>", "<DLE", "<DC1>", "<DC2>", "<DC3>", "<DC4>", "<NAK>", "<SYN>", "<ETB>", "<CAN", "<EM>", "<SUB>", "<ESC>", "<FS>", "<GS>", "<RS>", "<US>"};
    private static final NumberFormat commaFormatter = NumberFormat.getInstance();

    public static String arrayToString(Object[] array) {
        String result = "";
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                Object value = array[i];
                if (i > 0) {
                    result = result + ", ";
                }
                result = value == null ? result + "null" : result + value.toString();
            }
        }
        return result;
    }

    public static int balPos(StringBuffer s, int start, char lChar, char rChar) {
        int count = 0;
        int ls = s.length();
        int saveStart = start;
        while (true) {
            if (s.charAt(start) == lChar) {
                count = lChar != rChar ? ++count : (start == saveStart ? ++count : --count);
            } else if (s.charAt(start) == rChar) {
                --count;
            }
            if (start >= ls || count == 0) break;
            ++start;
        }
        if (count == 0) {
            return start;
        }
        return -1;
    }

    public static int countChar(StringBuffer sb, char ch) {
        int result = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != ch) continue;
            ++result;
        }
        return result;
    }

    public static int countChar(String s, char ch) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != ch) continue;
            ++result;
        }
        return result;
    }

    public static int countOccurrences(String source, String searchString) {
        int result = 0;
        int searchLength = searchString.length();
        for (int i = 0; i < source.length() - searchLength; ++i) {
            if (!source.regionMatches(i, searchString, 0, searchLength)) continue;
            ++result;
        }
        return result;
    }

    public static String deleteChar(String str, char ch) {
        if (StringUtils.safeString(str).length() == 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str.length());
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ch) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String displayableString(String s) {
        StringBuffer sb = new StringBuffer();
        if (s != null) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c < ' ') {
                    sb.append(asciiControlCharacterNames[c]);
                    continue;
                }
                sb.append(c + "");
            }
        }
        return sb.toString();
    }

    public static String displayBooleanField(String name, boolean value) {
        return name + " = " + value;
    }

    public static String displayIntegerField(String name, int value) {
        return name + " = " + value;
    }

    public static String displayDoubleField(String name, double value) {
        return name + " = " + value;
    }

    public static String displayStringField(String name, String value) {
        StringBuffer buf = new StringBuffer();
        buf.append(name + " = ");
        if (value == null) {
            buf.append("null");
        } else {
            int indent = name.length() + 3;
            boolean firstLine = true;
            StringTokenizer tokenizer = new StringTokenizer(value, "\n");
            while (tokenizer.hasMoreTokens()) {
                if (!firstLine) {
                    buf.append("\n");
                    for (int i = 0; i < indent; ++i) {
                        buf.append(" ");
                    }
                }
                firstLine = false;
                buf.append(tokenizer.nextToken());
            }
        }
        return buf.toString();
    }

    public static String dupl(char ch, int n) {
        if (n > 0) {
            StringBuffer result = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                result.append(ch);
            }
            return result.toString();
        }
        return "";
    }

    public static String dupl(String s, int n) {
        if (n > 0) {
            StringBuffer result = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                result.append(s);
            }
            return result.toString();
        }
        return "";
    }

    public static byte[] getUTF8Bytes(String s) {
        byte[] result = null;
        try {
            result = s.getBytes("UTF-8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String getStringFromUTF8Bytes(byte[] bytes) {
        String result = null;
        if (bytes != null) {
            try {
                result = new String(bytes, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s2 == null ? false : s1.equals(s2);
    }

    public static boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s2 == null ? false : s1.equalsIgnoreCase(s2);
    }

    public static int compare(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        return s1 == null ? 1 : s1.compareTo(s2);
    }

    public static int compareIgnoreCase(String s1, String s2) {
        if (s1 == null) {
            return s2 == null ? 0 : -1;
        }
        return s1 == null ? 1 : s1.compareToIgnoreCase(s2);
    }

    public static int compare(Date d1, Date d2) {
        if (d1 == null) {
            return d2 == null ? 0 : -1;
        }
        return d1 == null ? 1 : d1.compareTo(d2);
    }

    public static int compare(int n1, int n2) {
        if (n1 < n2) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public static int compare(long n1, long n2) {
        if (n1 < n2) {
            return -1;
        }
        if (n1 > n2) {
            return 1;
        }
        return 0;
    }

    public static int indexOfIgnoreCase(String str1, String str2, int fromIndex) {
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int str1Len = str1.length();
        int str2Len = str2.length();
        int limit = str1Len - str2Len;
        while (fromIndex <= limit) {
            if (str1.regionMatches(true, fromIndex, str2, 0, str2Len)) {
                return fromIndex;
            }
            ++fromIndex;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String str1, String str2) {
        return StringUtils.indexOfIgnoreCase(str1, str2, 0);
    }

    public static int indexOfIgnoreCaseWholeWord(String str1, String str2, int fromIndex) {
        if (str1 == null) {
            return -1;
        }
        if (str2 == null) {
            return -1;
        }
        str1 = str1.toLowerCase();
        int str1len = str1.length();
        int str2len = str2.length();
        while (fromIndex >= 0) {
            if ((fromIndex = str1.indexOf(str2, fromIndex)) < 0) {
                return -1;
            }
            if (fromIndex > 0 && Character.isLetterOrDigit(str1.charAt(fromIndex - 1))) {
                ++fromIndex;
                continue;
            }
            int k = fromIndex + str2len;
            if (k < str1len && Character.isLetterOrDigit(str1.charAt(k))) {
                ++fromIndex;
                continue;
            }
            return fromIndex;
        }
        return -1;
    }

    public static boolean containsIgnoreCaseWholeWord(String str1, String str2) {
        return StringUtils.indexOfIgnoreCaseWholeWord(str1, str2.toLowerCase(), 0) >= 0;
    }

    public static int extractNumber(String str, int pos) throws ParseException {
        int end;
        int begin;
        int len = str.length();
        char c = str.charAt(pos);
        if (!Character.isLetterOrDigit(c) && pos > 0) {
            --pos;
        }
        for (begin = pos; begin >= 0 && (Character.isDigit(c = str.charAt(begin)) || c == ','); --begin) {
        }
        ++begin;
        for (end = pos; end < len && (Character.isDigit(c = str.charAt(end)) || c == ','); ++end) {
        }
        if (begin >= end) {
            throw new ParseException("Invalid number", 0);
        }
        return StringUtils.parseNumberWithCommas(str.substring(begin, end));
    }

    public static String getFirstTokenFromBytes(byte[] bytes, int nBytes) {
        int value;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nBytes && (value = bytes[i] & 0xFF) != 13 && value != 10 && value != 9 && value != 32; ++i) {
            sb.append((char)value);
        }
        return sb.toString();
    }

    public static String firstLine(String str) {
        if (str == null) {
            return null;
        }
        int i = str.indexOf(10);
        return i < 0 ? str : str.substring(0, i);
    }

    public static String formatNumberWithCommas(int n) {
        return commaFormatter.format(n);
    }

    public static String formatNumberWithCommas(long n) {
        return commaFormatter.format(n);
    }

    public static int parseNumberWithCommas(String str) throws ParseException {
        return commaFormatter.parse(str).intValue();
    }

    public static String safeString(String s) {
        String string = s;
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String replaceAll(String str, String s, String r) {
        int match;
        StringBuffer result = new StringBuffer();
        int sLen = s.length();
        int strLen = str.length();
        char[] strCharArray = str.toCharArray();
        int pos = 0;
        while ((match = str.indexOf(s, pos)) >= 0) {
            result.append(strCharArray, pos, match - pos);
            result.append(r);
            pos = match + sLen;
        }
        result.append(strCharArray, pos, strLen - pos);
        return result.toString();
    }

    public static String replaceFirst(String str, String s, String r) {
        StringBuffer result = new StringBuffer();
        int sLen = s.length();
        int strLen = str.length();
        char[] strCharArray = str.toCharArray();
        int pos = 0;
        int match = str.indexOf(s, pos);
        if (match >= 0) {
            result.append(strCharArray, pos, match - pos);
            result.append(r);
            pos = match + sLen;
            result.append(strCharArray, pos, strLen - pos);
        } else {
            result.append(strCharArray);
        }
        return result.toString();
    }

    public static boolean checkEmpty(String s) {
        return s == null || s == "";
    }

    public static String yesNo(boolean yesno) {
        String result = yesno ? "yes" : "no";
        return result;
    }

    public static String areOrAreNot(boolean bool) {
        return bool ? "are" : "are not";
    }

    public static String isOrIsNot(boolean bool) {
        return bool ? "is" : "is not";
    }

    public static String haveOrHaveNot(boolean bool) {
        return bool ? "have" : "have not";
    }

    public static int stringToInt(String strValue, int defaultValue) {
        String str = StringUtils.safeString(StringUtils.trim(strValue));
        if (str.length() == 0) {
            return defaultValue;
        }
        int result = defaultValue;
        try {
            result = Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    public static String stringToHexString(String s) {
        String result = "";
        String safeS = StringUtils.safeString(s);
        if (s.length() > 0) {
            for (int i = 0; i < safeS.length(); ++i) {
                if (i > 0) {
                    result = result + ",";
                }
                result = result + "0x" + Integer.toString(safeS.charAt(i), 16);
            }
        }
        return result;
    }

    public static String[] makeTokenArray(String source, String delim) {
        List<String> tokenArrayList = ListFactory.createNewList();
        StringTokenizer st = new StringTokenizer(source, delim);
        while (st.hasMoreTokens()) {
            tokenArrayList.add(st.nextToken());
        }
        int numTokens = tokenArrayList.size();
        String[] result = new String[numTokens];
        for (int i = 0; i < numTokens; ++i) {
            result[i] = (String)tokenArrayList.get(i);
        }
        return result;
    }

    public static String[] makeTokenArray(String source) {
        return StringUtils.makeTokenArray(source, " \t\n\r\f");
    }

    public static String objectToString(Object object) {
        String result = "";
        try {
            if (object == null) {
                result = "<null>";
            } else if (object.getClass().isArray()) {
                List<Object> list = ListFactory.createNewList();
                int arrayLength = Array.getLength(object);
                for (int j = 0; j < arrayLength; ++j) {
                    try {
                        Object arrayValue = Array.get(object, j);
                        list.add(arrayValue);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                result = list.toString();
            } else {
                result = object.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String pluralize(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }

    public static String pluralize(long count, String singular, String plural) {
        return count == 1L ? singular : plural;
    }

    public static String intToString(int intValue) {
        return new Integer(intValue).toString();
    }

    public static String intToStringWithZeroFill(int intValue, int width) {
        String s = new Integer(intValue).toString();
        if (s.length() < width) {
            s = StringUtils.dupl('0', width - s.length()) + s;
        }
        return s;
    }

    public static String longToString(long longValue) {
        return new Long(longValue).toString();
    }

    public static String longToStringWithZeroFill(long longValue, int width) {
        String s = new Long(longValue).toString();
        if (s.length() < width) {
            s = StringUtils.dupl('0', width - s.length()) + s;
        }
        return s;
    }

    public static String lpad(String s, int width) {
        if (s.length() < width) {
            return StringUtils.dupl(' ', width - s.length()) + s;
        }
        return s;
    }

    public static String rpad(String s, int width) {
        if (s.length() < width) {
            return s + StringUtils.dupl(' ', width - s.length());
        }
        return s;
    }

    public static int stringToInt(String strValue) throws NumberFormatException {
        String str = StringUtils.safeString(StringUtils.trim(strValue));
        if (str.length() == 0) {
            return 0;
        }
        return Integer.parseInt(strValue);
    }

    public static long stringToLong(String strValue) throws NumberFormatException {
        String str = StringUtils.trim(StringUtils.safeString(strValue));
        if (str.length() == 0) {
            return 0L;
        }
        return Long.parseLong(strValue);
    }

    public static long stringToLong(String strValue, long defValue) {
        long result;
        try {
            result = Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            result = defValue;
        }
        return result;
    }

    public static String startOfString(String str, int n) {
        String result = "";
        if (str != null) {
            result = n <= str.length() ? str.substring(0, n) : str;
        }
        return result;
    }

    public static String endOfString(String str, int n) {
        String result = "";
        if (str != null) {
            result = n <= str.length() ? str.substring(str.length() - n, str.length()) : str;
        }
        return result;
    }

    public static String substring(String str, int start, int end) {
        String result = "";
        if (str != null) {
            try {
                result = str.substring(start, end);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static String wrapLine(String line, String newline, int wrapColumn) {
        StringBuffer wrappedLine = new StringBuffer();
        while (line.length() > wrapColumn) {
            int spaceToWrapAt = line.lastIndexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            spaceToWrapAt = line.indexOf(32, wrapColumn);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(line.substring(0, spaceToWrapAt));
                wrappedLine.append(newline);
                line = line.substring(spaceToWrapAt + 1);
                continue;
            }
            wrappedLine.append(line);
            line = "";
        }
        wrappedLine.append(line);
        return wrappedLine.toString();
    }

    public static String wrapText(String inString, String newline, int wrapColumn) {
        StringTokenizer lineTokenizer = new StringTokenizer(inString, newline, true);
        StringBuffer stringBuffer = new StringBuffer();
        while (lineTokenizer.hasMoreTokens()) {
            try {
                String nextLine = lineTokenizer.nextToken();
                if (nextLine.length() > wrapColumn) {
                    nextLine = StringUtils.wrapLine(nextLine, newline, wrapColumn);
                }
                stringBuffer.append(nextLine);
            }
            catch (NoSuchElementException e) {
                break;
            }
        }
        return stringBuffer.toString();
    }

    public static String trim(String s) {
        if (s == null) {
            return null;
        }
        s = s.trim();
        return s;
    }

    public static String zeroPad(String s, int length) {
        for (int i = s.length(); i < length; ++i) {
            s = "0" + s;
        }
        return s;
    }

    public static String intersperseTextLines(String s1, String s2, String s1Prefix, String s1Suffix, String s2Prefix, String s2Suffix) {
        String[] s1Lines = s1.split("\n");
        String[] s2Lines = s2.split("\n");
        StringBuffer sb = new StringBuffer();
        int l1 = s1Lines.length;
        int l2 = s2Lines.length;
        int lMax = Math.max(l1, l2);
        for (int i = 0; i < lMax; ++i) {
            if (i < l1) {
                if (s1Prefix != null) {
                    sb = sb.append(s1Prefix);
                }
                sb = sb.append(s1Lines[i]);
                if (s1Suffix != null) {
                    sb = sb.append(s1Suffix);
                }
            }
            sb = sb.append("\n");
            if (i < l2) {
                if (s2Prefix != null) {
                    sb = sb.append(s2Prefix);
                }
                sb = sb.append(s2Lines[i]);
                if (s2Suffix != null) {
                    sb = sb.append(s2Suffix);
                }
            }
            sb = sb.append("\n");
        }
        return sb.toString();
    }

    public static String deleteParenthesizedText(String s) {
        StringBuffer sb = new StringBuffer(s);
        StringBuffer sbResult = new StringBuffer();
        int parenDepth = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '(') {
                ++parenDepth;
                continue;
            }
            if (sb.charAt(i) == ')') {
                if (--parenDepth >= 0) continue;
                parenDepth = 0;
                continue;
            }
            if (parenDepth != 0) continue;
            sbResult = sbResult.append(sb.charAt(i));
        }
        return sbResult.toString();
    }

    public static String stripChars(String s, String charsToStrip) {
        String result = "";
        for (int i = 0; i < s.length(); ++i) {
            if (charsToStrip.indexOf(s.charAt(i)) >= 0) continue;
            result = result + s.charAt(i);
        }
        return result;
    }

    public static String stripCharacterRuns(String s) {
        String result = "";
        char lastChar = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != lastChar) {
                result = result + s.charAt(i);
            }
            lastChar = s.charAt(i);
        }
        return result;
    }

    public static String deleteUnparenthesizedText(String s) {
        StringBuffer sb = new StringBuffer(s);
        StringBuffer sbResult = new StringBuffer();
        int parenDepth = 0;
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) == '(') {
                ++parenDepth;
                continue;
            }
            if (sb.charAt(i) == ')') {
                if (--parenDepth < 0) {
                    parenDepth = 0;
                }
                sbResult.append(' ');
                continue;
            }
            if (parenDepth <= 0) continue;
            sbResult = sbResult.append(sb.charAt(i));
        }
        return sbResult.toString().trim();
    }

    public static String compressMultipleOccurrences(String s, char c) {
        String cs = c + "";
        String cscs = cs + cs;
        String result = StringUtils.replaceAll(s, cscs, cs);
        while (result.indexOf(cscs) > 0) {
            result = StringUtils.replaceAll(result, cscs, cs);
        }
        return result;
    }

    public static boolean isRegularExpression(String s) {
        char[] regExpChars = new char[]{'*', '+', '-', '[', ']', '.', '^', '&', '\\', '$', '?', '{', '}', '='};
        boolean result = false;
        if (s != null && s.length() > 0) {
            for (int i = 0; i < regExpChars.length; ++i) {
                boolean bl = result = s.indexOf(regExpChars[i]) >= 0;
                if (result) break;
            }
        }
        return result;
    }

    public static int matchingInitialCharacters(String s1, String s2) {
        int result = 0;
        int l = Math.min(s1.length(), s2.length());
        for (int i = 0; i < l && s1.charAt(i) == s2.charAt(i); ++i) {
            ++result;
        }
        return result;
    }

    public static int matchingFinalCharacters(String s1, String s2) {
        int result = 0;
        int l = Math.min(s1.length(), s2.length());
        for (int i = l - 1; i > 0 && s1.charAt(i) == s2.charAt(i); --i) {
            ++result;
        }
        return result;
    }

    public static String reverseString(String s) {
        String result = s;
        if (result != null) {
            StringBuffer rs = new StringBuffer(s);
            result = rs.reverse().toString();
        }
        return result;
    }

    public static String truncate(String str, int n) {
        return str.length() < n ? str : str.substring(0, n) + "...";
    }

    public static String upperCaseFirstChar(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        char c = str.charAt(0);
        return Character.toUpperCase(c) + str.substring(1);
    }

    public static String escapeSpecialCharacters(String s) {
        String result = s;
        if (s != null) {
            StringBuffer sb = new StringBuffer();
            block8: for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block8;
                    }
                    case '\'': {
                        sb.append("\\'");
                        continue block8;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block8;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block8;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block8;
                    }
                    default: {
                        sb.append(ch);
                    }
                }
            }
            result = sb.toString();
        }
        return result;
    }

    public static String join(Iterable<? extends CharSequence> sequence, String delimeter) {
        Iterator<? extends CharSequence> iterator;
        String result = "";
        if (sequence != null && (iterator = sequence.iterator()).hasNext()) {
            StringBuilder buffer = new StringBuilder(iterator.next());
            String delim = "";
            if (delimeter != null) {
                delim = delimeter;
            }
            while (iterator.hasNext()) {
                buffer.append(delim);
                buffer.append(iterator.next());
            }
            result = buffer.toString();
        }
        return result;
    }

    public static String join(Object[] array, String delimeter) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimeter);
            }
            sb.append(array[i].toString());
        }
        return sb.toString();
    }

    public static String join(Iterable<? extends CharSequence> sequence) {
        return StringUtils.join(sequence, " ");
    }

    public static String ordinalize(int number, boolean addCommas) {
        String ext = "";
        int n = number % 100;
        if (n >= 11 && n <= 13) {
            ext = "th";
        } else {
            switch (number % 10) {
                case 1: {
                    ext = "st";
                    break;
                }
                case 2: {
                    ext = "nd";
                    break;
                }
                case 3: {
                    ext = "rd";
                    break;
                }
                default: {
                    ext = "th";
                }
            }
        }
        String result = "";
        result = addCommas ? Formatters.formatIntegerWithCommas(number) + ext : StringUtils.intToString(number) + ext;
        return result;
    }

    protected StringUtils() {
    }

    static {
        commaFormatter.setGroupingUsed(true);
    }
}

