/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;

public class SortedArrayList<E>
extends ArrayList<E> {
    protected Comparator<E> comparator = null;

    public SortedArrayList() {
    }

    public SortedArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    public SortedArrayList(Collection<? extends E> collection) {
        this.addAll(collection);
    }

    public SortedArrayList(E[] array) {
        this.addAll(Arrays.asList(array));
    }

    public SortedArrayList(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    public SortedArrayList(Collection<? extends E> collection, Comparator<E> comparator) {
        this.comparator = comparator;
        this.addAll(collection);
    }

    public SortedArrayList(E[] array, Comparator<E> comparator) {
        this.comparator = comparator;
        this.addAll(array);
    }

    public SortedArrayList(int initialCapacity, Comparator<E> comparator) {
        super(initialCapacity);
        this.comparator = comparator;
    }

    public void setComparator(Comparator<E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public boolean add(E object) {
        if (object == null) {
            return false;
        }
        int i = 0;
        int j = this.size() - 1;
        while (i <= j) {
            int k = (i + j) / 2;
            int c = this.compare(object, this.get(k));
            if (c < 0) {
                j = k - 1;
                continue;
            }
            if (c > 0) {
                i = k + 1;
                continue;
            }
            i = k;
            break;
        }
        super.add(i, object);
        return true;
    }

    @Override
    public void add(int index, E object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean result = false;
        if (collection != null) {
            super.addAll(collection);
            this.sort();
            result = true;
        }
        return result;
    }

    public boolean addAll(E[] array) {
        boolean result = false;
        if (array != null) {
            super.addAll(Arrays.asList(array));
            this.sort();
            result = true;
        }
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        int result = -1;
        if (object == null) {
            return result;
        }
        int i = 0;
        int j = this.size() - 1;
        while (i <= j) {
            int l;
            int k = (i + j) / 2;
            int c = this.compare(object, this.get(k));
            if (c < 0) {
                j = k - 1;
                continue;
            }
            if (c > 0) {
                i = k + 1;
                continue;
            }
            result = k;
            for (l = k - 1; l >= 0 && this.compare(object, this.get(l)) == 0; --l) {
            }
            if (l + 1 >= result) break;
            result = l + 1;
            break;
        }
        return result;
    }

    @Override
    public int lastIndexOf(Object object) {
        int result = -1;
        if (object == null) {
            return result;
        }
        int i = 0;
        int j = this.size() - 1;
        while (i <= j) {
            int l;
            int k = (i + j) / 2;
            int c = this.compare(object, this.get(k));
            if (c < 0) {
                j = k - 1;
                continue;
            }
            if (c > 0) {
                i = k + 1;
                continue;
            }
            result = k;
            for (l = k + 1; l < this.size() && this.compare(object, this.get(l)) == 0; ++l) {
            }
            if (l - 1 <= result) break;
            result = l - 1;
            break;
        }
        return result;
    }

    @Override
    public E set(int index, E object) {
        throw new UnsupportedOperationException();
    }

    protected int compare(Object object1, Object object2) {
        if (this.comparator != null) {
            return this.comparator.compare(object1, object2);
        }
        if (object1 instanceof Comparable && object2 instanceof Comparable) {
            return ((Comparable)object1).compareTo((Comparable)object2);
        }
        String s1 = null;
        String s2 = null;
        if (object1 != null) {
            s1 = object1.toString();
        }
        if (object2 != null) {
            s2 = object2.toString();
        }
        return StringUtils.compareIgnoreCase(s1, s2);
    }

    protected void sort() {
        Object[] eArray = this.toArray();
        this.clear();
        Arrays.sort(eArray);
        this.ensureCapacity(eArray.length);
        for (int i = 0; i < eArray.length; ++i) {
            super.add(eArray[i]);
        }
    }
}

