/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.SetFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;

public class SetUtils {
    public static Set<String> loadIntoSet(Set<String> set, URL setURL, String encoding) throws IOException, FileNotFoundException {
        if (set != null && setURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(setURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                set.add(inputLine);
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return set;
    }

    public static Set<String> loadSet(URL setURL, String encoding) throws IOException, FileNotFoundException {
        Set<String> set = SetFactory.createNewSet();
        SetUtils.loadIntoSet(set, setURL, encoding);
        return set;
    }

    public static Set<String> loadSortedSet(URL setURL, String encoding) throws IOException, FileNotFoundException {
        SortedSet<String> set = SetFactory.createNewSortedSet();
        SetUtils.loadIntoSet(set, setURL, encoding);
        return set;
    }

    public static Set<String> loadSet(File setFile, String encoding) throws IOException, FileNotFoundException {
        return SetUtils.loadSet(setFile.toURI().toURL(), encoding);
    }

    public static Set<String> loadSortedSet(File setFile, String encoding) throws IOException, FileNotFoundException {
        return SetUtils.loadSortedSet(setFile.toURI().toURL(), encoding);
    }

    public static Set<String> loadSet(String setFileName, String encoding) throws IOException, FileNotFoundException {
        return SetUtils.loadSet(new File(setFileName), encoding);
    }

    public static Set<String> loadSortedSet(String setFileName, String encoding) throws IOException, FileNotFoundException {
        return SetUtils.loadSortedSet(new File(setFileName), encoding);
    }

    public static void saveSet(Set<?> set, File setFile, String encoding) throws IOException, FileNotFoundException {
        if (set != null) {
            PrintWriter printWriter = new PrintWriter(setFile, "utf-8");
            Iterator<?> iterator = set.iterator();
            while (iterator.hasNext()) {
                String value = iterator.next().toString();
                printWriter.println(value);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveSortedSet(Set<?> set, File setFile, String encoding) throws IOException, FileNotFoundException {
        if (set != null) {
            if (set instanceof SortedSet) {
                SetUtils.saveSet(set, setFile, encoding);
            } else {
                SortedSet<?> sortedSet = SetFactory.createNewSortedSet();
                sortedSet.addAll(set);
                SetUtils.saveSet(sortedSet, setFile, encoding);
            }
        }
    }

    public static void saveSet(Set<?> set, String setFileName, String encoding) throws IOException, FileNotFoundException {
        SetUtils.saveSet(set, new File(setFileName), encoding);
    }

    public static void saveSortedSet(Set<?> set, String setFileName, String encoding) throws IOException, FileNotFoundException {
        SetUtils.saveSortedSet(set, new File(setFileName), encoding);
    }

    public static <T> void addAll(Set<T> set, T[] t) throws IOException, FileNotFoundException {
        set.addAll(Arrays.asList(t));
    }

    protected SetUtils() {
    }
}

