/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternReplacer
implements Serializable {
    protected String sourcePattern;
    protected Matcher sourcePatternMatcher;
    protected String replacementPattern;

    public PatternReplacer(String sourcePattern, String replacementPattern) {
        this.sourcePattern = sourcePattern;
        this.replacementPattern = replacementPattern;
        this.sourcePatternMatcher = Pattern.compile(sourcePattern).matcher("");
    }

    public String[] matchGroups(String s) {
        String[] result = null;
        if (this.sourcePatternMatcher.reset(s).find()) {
            int groupCount = this.sourcePatternMatcher.groupCount();
            result = new String[groupCount + 1];
            for (int i = 0; i <= groupCount; ++i) {
                result[i] = this.sourcePatternMatcher.group(i);
            }
        }
        return result;
    }

    public String replace(String s) {
        return this.sourcePatternMatcher.reset(s).replaceAll(this.replacementPattern);
    }

    public Matcher getMatcher() {
        return this.sourcePatternMatcher;
    }

    public String toString() {
        return this.sourcePattern + " -> " + this.replacementPattern;
    }
}

