/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.UnicodeReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.List;

public class ListUtils {
    public static List<String> loadList(List<String> list, URL setURL, String encoding) throws IOException, FileNotFoundException {
        if (list == null) {
            list = ListFactory.createNewList();
        }
        if (setURL != null) {
            BufferedReader bufferedReader = new BufferedReader(new UnicodeReader(setURL.openStream(), encoding));
            String inputLine = bufferedReader.readLine();
            while (inputLine != null) {
                list.add(inputLine);
                inputLine = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        return list;
    }

    public static List<String> loadList(URL setURL, String encoding) throws IOException, FileNotFoundException {
        List<String> list = ListFactory.createNewList();
        return ListUtils.loadList(list, setURL, encoding);
    }

    public static List<String> loadList(List<String> list, File listFile, String encoding) throws IOException, FileNotFoundException {
        return ListUtils.loadList(list, listFile.toURI().toURL(), encoding);
    }

    public static List<String> loadList(File listFile, String encoding) throws IOException, FileNotFoundException {
        List<String> list = ListFactory.createNewList();
        return ListUtils.loadList(list, listFile.toURI().toURL(), encoding);
    }

    public static List<String> loadList(List<String> list, String listFileName, String encoding) throws IOException, FileNotFoundException {
        return ListUtils.loadList(list, new File(listFileName), encoding);
    }

    public static List<String> loadList(String listFileName, String encoding) throws IOException, FileNotFoundException {
        List<String> list = ListFactory.createNewList();
        return ListUtils.loadList(list, new File(listFileName), encoding);
    }

    public static void saveList(List<?> list, File listFile, String encoding) throws IOException, FileNotFoundException {
        if (list != null) {
            PrintWriter printWriter = new PrintWriter(listFile, "utf-8");
            Iterator<?> iterator = list.iterator();
            while (iterator.hasNext()) {
                String value = iterator.next().toString();
                printWriter.println(value);
            }
            printWriter.flush();
            printWriter.close();
        }
    }

    public static void saveList(List<?> list, String listFileName, String encoding) throws IOException, FileNotFoundException {
        ListUtils.saveList(list, new File(listFileName), encoding);
    }

    public static <E> List<E> shallowClone(List<E> list) {
        List<E> result = ListFactory.createNewList();
        for (E data : list) {
            result.add(data);
        }
        return result;
    }

    protected ListUtils() {
    }
}

