/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.File;
import java.util.Date;

public class FileInfo {
    File file;
    String baseDirectory;

    public FileInfo(File file) {
        this.file = file;
    }

    public FileInfo(File file, File baseDirectory) {
        this.file = file;
        if (baseDirectory != null) {
            try {
                this.baseDirectory = baseDirectory.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getFileName() {
        return this.file == null ? "" : this.file.getName();
    }

    public String getFullFileName() {
        String result = "";
        if (this.file != null) {
            try {
                result = this.file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public String getRelativeFileName() {
        String result = "";
        if (this.file != null) {
            try {
                result = this.file.getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result.length() >= this.baseDirectory.length()) {
            result = result.substring(this.baseDirectory.length());
        }
        return result;
    }

    public long getLength() {
        return this.file == null ? 0L : this.file.length();
    }

    public long getLastModified() {
        return this.file == null ? 0L : this.file.lastModified();
    }

    public Date getLastModifiedDateTime() {
        return this.file == null ? new Date(0L) : new Date(this.file.lastModified());
    }

    public boolean getIsFile() {
        return this.file == null ? false : this.file.isFile();
    }

    public boolean getIsDirectory() {
        return this.file == null ? false : this.file.isDirectory();
    }

    public File getParentFile() {
        return this.file == null ? null : this.file.getParentFile();
    }

    public String getParentPath() {
        String result = "";
        if (this.file != null) {
            try {
                result = this.file.getParentFile().getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public String getRelativeParentPath() {
        String result = "";
        if (this.file != null) {
            try {
                result = this.file.getParentFile().getCanonicalPath();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result.length() >= this.baseDirectory.length()) {
                result = result.substring(this.baseDirectory.length());
            }
        }
        return result;
    }

    public String toString() {
        return this.getFullFileName();
    }
}

