/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.Env;
import edu.northwestern.at.utils.ListFactory;
import edu.northwestern.at.utils.StreamGrabber;
import java.io.IOException;
import java.util.List;

public class ExecUtils {
    public static List[] execAndWait(String command, boolean doWait) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        StreamGrabber outputGrabber = null;
        StreamGrabber errorGrabber = null;
        try {
            if (Env.MACOSX) {
                process = runtime.exec(new String[]{"open", command});
            } else if (Env.WINDOWSOS) {
                String shell = "cmd.exe";
                if (Env.OSNAME.indexOf("windows 9") > -1) {
                    shell = "command.exe";
                } else if (Env.OSNAME.indexOf("windows ME") > -1) {
                    shell = "command.exe";
                }
                process = runtime.exec(new String[]{shell, " /c " + command});
            } else {
                process = runtime.exec(command);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (process != null && doWait) {
            outputGrabber = new StreamGrabber(process.getInputStream());
            errorGrabber = new StreamGrabber(process.getErrorStream());
            outputGrabber.start();
            errorGrabber.start();
            try {
                process.waitFor();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (doWait) {
            return new List[]{outputGrabber.getGrabbedTextLines(), errorGrabber.getGrabbedTextLines()};
        }
        return new List[]{ListFactory.createNewList(), ListFactory.createNewList()};
    }

    protected ExecUtils() {
    }
}

