/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.FileInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class DirectoryTreeList {
    public static List<File> getFileListing(File startingDir, boolean recurse) throws FileNotFoundException {
        List<File> result = null;
        if (startingDir != null) {
            result = DirectoryTreeList.getFileListingUnsorted(startingDir, recurse);
            Collections.sort(result);
        }
        return result;
    }

    public static List<File> getFileListingUnsorted(File startingDir, boolean recurse) throws FileNotFoundException {
        ArrayList<File> result = new ArrayList<File>();
        File[] filesAndDirs = startingDir.listFiles();
        List<File> filesDirs = Arrays.asList(filesAndDirs);
        for (File file : filesDirs) {
            result.add(file);
            if (file.isFile() || !recurse) continue;
            List<File> deeperList = DirectoryTreeList.getFileListingUnsorted(file, recurse);
            result.addAll(deeperList);
        }
        return result;
    }

    public static List<FileInfo> getFiles(File startingDir, boolean recurse) {
        ArrayList<FileInfo> result = new ArrayList<FileInfo>();
        try {
            List<File> files = DirectoryTreeList.getFileListing(startingDir, recurse);
            if (files != null) {
                for (File file : files) {
                    result.add(new FileInfo(file, startingDir));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

