/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import java.io.File;

public class DirUtils {
    protected static int MAX_DIR_CREATE_TRIES = 10000;

    public static String getTemporaryFilesDirectory() {
        return System.getProperty("java.io.tmpdir");
    }

    public static File createTemporaryDirectory(String baseName) throws IllegalStateException {
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        if (baseName == null) {
            baseName = "";
        }
        baseName = baseName + System.currentTimeMillis() + "-";
        for (int i = 0; i < MAX_DIR_CREATE_TRIES; ++i) {
            File tempDir = new File(baseDir, baseName + i);
            if (!tempDir.mkdir()) continue;
            return tempDir;
        }
        throw new IllegalStateException("Could not create temporary directory.");
    }

    public static boolean deleteDirectory(File directory) {
        boolean result = true;
        if (directory != null && directory.exists() && directory.isDirectory()) {
            DirUtils.emptyOutDirectory(directory);
            result = directory.delete();
        }
        return result;
    }

    public static boolean deleteDirectory(String directory) {
        return DirUtils.deleteDirectory(new File(directory));
    }

    protected static void emptyOutDirectory(File directory) {
        if (directory != null && directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    file.delete();
                    continue;
                }
                DirUtils.emptyOutDirectory(file);
            }
        }
    }

    protected DirUtils() {
    }
}

