/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressedSerializer
implements Serializer {
    @Override
    public byte[] serializeToBytes(Object object) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = new GZIPOutputStream(byteStream);
        ObjectOutputStream objectStream = new ObjectOutputStream(gzipStream);
        objectStream.writeObject(object);
        objectStream.close();
        return byteStream.toByteArray();
    }

    @Override
    public Object deserializeFromBytes(byte[] serializedObject) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteStream = new ByteArrayInputStream(serializedObject);
        GZIPInputStream gzipStream = new GZIPInputStream(byteStream);
        ObjectInputStream objectStream = new ObjectInputStream(gzipStream);
        Object result = objectStream.readObject();
        objectStream.close();
        return result;
    }
}

