/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

import edu.northwestern.at.utils.CompressedSerializer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CompressedHashMap<K, V>
implements Map<K, V> {
    protected static CompressedSerializer serializer = new CompressedSerializer();
    protected HashMap<K, Object> delegateMap;

    public CompressedHashMap() {
        this.delegateMap = new HashMap();
    }

    public CompressedHashMap(int initialCapacity) {
        this.delegateMap = new HashMap(initialCapacity);
    }

    public CompressedHashMap(int initialCapacity, float loadFactor) {
        this.delegateMap = new HashMap(initialCapacity, loadFactor);
    }

    public CompressedHashMap(Map<? extends K, ? extends V> map) {
        this.delegateMap = new HashMap(map.size());
        this.putAll(map);
    }

    protected V decompress(Object o) {
        Object result = null;
        try {
            result = serializer.deserializeFromBytes((byte[])o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (V)result;
    }

    protected Object compress(Object o) {
        byte[] result = null;
        try {
            result = serializer.serializeToBytes(o);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        this.delegateMap.clear();
    }

    public Object clone() {
        return this.delegateMap.clone();
    }

    @Override
    public boolean containsKey(Object key) throws ClassCastException, NullPointerException {
        return this.delegateMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) throws ClassCastException, NullPointerException {
        return this.delegateMap.containsValue(this.compress(value));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> result = new HashSet<Map.Entry<K, V>>();
        for (Map.Entry<K, Object> entry : this.delegateMap.entrySet()) {
            AbstractMap.SimpleEntry<K, V> resultEntry = new AbstractMap.SimpleEntry<K, V>(entry.getKey(), this.decompress(entry.getValue()));
            result.add(resultEntry);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.delegateMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegateMap.keySet();
    }

    @Override
    public int size() {
        return this.delegateMap.size();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) throws UnsupportedOperationException, ClassCastException, NullPointerException, IllegalArgumentException {
        for (K key : m.keySet()) {
            V value = m.get(key);
            this.put(key, value);
        }
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> result = new ArrayList<V>();
        Iterator<Object> iterator = this.delegateMap.values().iterator();
        while (iterator.hasNext()) {
            result.add(this.decompress(iterator.next()));
        }
        return result;
    }

    @Override
    public V remove(Object key) throws UnsupportedOperationException, ClassCastException, NullPointerException {
        Object o = this.delegateMap.remove(key);
        V result = null;
        if (o != null) {
            result = this.decompress(o);
        }
        return result;
    }

    @Override
    public V get(Object key) throws ClassCastException, NullPointerException {
        Object o = this.delegateMap.get(key);
        V result = null;
        if (o != null) {
            result = this.decompress(o);
        }
        return result;
    }

    @Override
    public V put(K key, V value) throws UnsupportedOperationException, ClassCastException, NullPointerException, IllegalArgumentException {
        V result = this.get(key);
        this.delegateMap.put(key, this.compress(value));
        return result;
    }
}

