/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.utils;

public class ArgumentList {
    protected Class[] classes;
    protected Object[] arguments;
    protected int argumentCount;

    public ArgumentList() {
        this.argumentCount = 0;
        this.classes = new Class[0];
        this.arguments = new Object[0];
    }

    public ArgumentList(int argumentCount) {
        this.argumentCount = argumentCount;
        this.classes = new Class[argumentCount];
        this.arguments = new Object[argumentCount];
    }

    public Class[] getArgumentClasses() {
        return this.classes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public int setArgument(int argumentNumber, Object object, Class theClass) {
        if (argumentNumber >= this.arguments.length) {
            ++this.argumentCount;
            Class[] classesExpanded = new Class[this.argumentCount];
            Object[] argumentsExpanded = new Object[this.argumentCount];
            System.arraycopy(this.classes, 0, classesExpanded, 0, this.classes.length);
            System.arraycopy(this.arguments, 0, argumentsExpanded, 0, this.arguments.length);
            this.classes = classesExpanded;
            this.arguments = argumentsExpanded;
        }
        this.arguments[argumentNumber] = object;
        this.classes[argumentNumber] = theClass;
        return argumentNumber;
    }

    public int setArgument(boolean b) {
        return this.setArgument(this.argumentCount, new Boolean(b), Boolean.TYPE);
    }

    public int setArgument(int argumentNumber, boolean b) {
        return this.setArgument(argumentNumber, new Boolean(b), Boolean.TYPE);
    }

    public int setArgument(byte b) {
        return this.setArgument(this.argumentCount, new Byte(b), Byte.TYPE);
    }

    public int setArgument(int argumentNumber, byte b) {
        return this.setArgument(argumentNumber, new Byte(b), Byte.TYPE);
    }

    public int setArgument(char c) {
        return this.setArgument(this.argumentCount, new Character(c), Character.TYPE);
    }

    public int setArgument(int argumentNumber, char c) {
        return this.setArgument(argumentNumber, new Character(c), Character.TYPE);
    }

    public int setArgument(int i) {
        return this.setArgument(this.argumentCount, new Integer(i), Integer.TYPE);
    }

    public int setArgument(int argumentNumber, int i) {
        return this.setArgument(argumentNumber, new Integer(i), Integer.TYPE);
    }

    public int setArgument(short s) {
        return this.setArgument(this.argumentCount, new Short(s), Short.TYPE);
    }

    public int setArgument(int argumentNumber, short s) {
        return this.setArgument(argumentNumber, new Short(s), Short.TYPE);
    }

    public int setArgument(long l) {
        return this.setArgument(this.argumentCount, new Long(l), Long.TYPE);
    }

    public int setArgument(int argumentNumber, long l) {
        return this.setArgument(argumentNumber, new Long(l), Long.TYPE);
    }

    public int setArgument(float f) {
        return this.setArgument(this.argumentCount, new Float(f), Float.TYPE);
    }

    public int setArgument(int argumentNumber, float f) {
        return this.setArgument(argumentNumber, new Float(f), Float.TYPE);
    }

    public int setArgument(double d) {
        return this.setArgument(this.argumentCount, new Double(d), Double.TYPE);
    }

    public int setArgument(int argumentNumber, double d) {
        return this.setArgument(argumentNumber, new Double(d), Double.TYPE);
    }

    public int setArgument(Object object) {
        if (object == null) {
            return this.setArgument(this.argumentCount, object, Object.class);
        }
        return this.setArgument(this.argumentCount, object, object.getClass());
    }

    public int setArgument(int argumentNumber, Object object) {
        if (object == null) {
            return this.setArgument(argumentNumber, object, Object.class);
        }
        return this.setArgument(argumentNumber, object, object.getClass());
    }

    public int setArgument(Object object, Class theClass) {
        return this.setArgument(this.argumentCount, object, theClass);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ArgumentList:\n");
        for (int i = 0; i < this.argumentCount; ++i) {
            buf.append("   " + this.classes[i].getName() + " " + this.arguments[i] + "\n");
        }
        return buf.toString();
    }
}

