/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.unadorn;

import edu.northwestern.at.morphadorner.StripAllWordElementsFilter;
import edu.northwestern.at.morphadorner.tools.AdornedXMLWriter;
import edu.northwestern.at.morphadorner.tools.FilterAdornedFile;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.Formatters;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.xml.sax.helpers.XMLReaderFactory;

public class Unadorn {
    protected static final int INITPARAMS = 1;
    protected static int docsToProcess = 0;
    protected static int currentDocNumber = 0;
    protected static String outputDirectoryName = "";

    public static void main(String[] args) {
        try {
            if (!Unadorn.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            int filesProcessed = Unadorn.processFiles(args);
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            Unadorn.terminate(filesProcessed, processingTime);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected static boolean initialize(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Not enough parameters.");
            return false;
        }
        outputDirectoryName = args[0];
        return true;
    }

    protected static void processOneFile(String xmlFileName) {
        try {
            System.out.println("(" + ++currentDocNumber + "/" + docsToProcess + ") " + "processing " + xmlFileName);
            StripAllWordElementsFilter filter = new StripAllWordElementsFilter(XMLReaderFactory.createXMLReader());
            String strippedFileName = FileNameUtils.stripPathName(xmlFileName);
            strippedFileName = FileNameUtils.changeFileExtension(strippedFileName, "");
            String xmlOutputFileName = new File(outputDirectoryName, strippedFileName + ".xml").getAbsolutePath();
            FileUtils.createPathForFile(xmlOutputFileName);
            new FilterAdornedFile(xmlFileName, xmlOutputFileName, filter);
            String fixedXML = FileUtils.readTextFile(xmlOutputFileName, "utf-8");
            fixedXML = fixedXML.replaceAll("(\\s+)", " ");
            fixedXML = fixedXML.replaceAll(" ([\\.?!,;:\\)])", "$1");
            fixedXML = fixedXML.replaceAll("\\( ", "(");
            fixedXML = fixedXML.replaceAll("\u00b6 ", "\u00b6");
            fixedXML = fixedXML.replaceAll("__NS1:", "");
            fixedXML = fixedXML.replaceAll("__NS1", "");
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((Reader)new StringReader(fixedXML));
            new AdornedXMLWriter(document, xmlOutputFileName);
        }
        catch (Exception e) {
            System.out.println("   Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected static int processFiles(String[] args) {
        boolean result = false;
        String[] wildCards = new String[args.length - 1];
        for (int i = 1; i < args.length; ++i) {
            wildCards[i - 1] = args[i];
        }
        String[] fileNames = FileNameUtils.expandFileNameWildcards(wildCards);
        docsToProcess = fileNames.length;
        System.out.println("There are " + Formatters.formatIntegerWithCommas(docsToProcess) + " documents to process.");
        for (int i = 0; i < fileNames.length; ++i) {
            Unadorn.processOneFile(fileNames[i]);
        }
        return fileNames.length;
    }

    protected static void terminate(int filesProcessed, long processingTime) {
        System.out.println("Processed " + Formatters.formatIntegerWithCommas(filesProcessed) + " files in " + Formatters.formatLongWithCommas(processingTime) + " seconds.");
    }
}

