/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tcp;

import edu.northwestern.at.utils.FileBatchProcessor;
import edu.northwestern.at.utils.FileNameUtils;
import edu.northwestern.at.utils.FileUtils;
import edu.northwestern.at.utils.PatternReplacer;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class SuperFixer {
    protected static Namespace teiNamespace = Namespace.getNamespace((String)"http://www.tei-c.org/ns/1.0");
    protected static Namespace teiNamespace2 = Namespace.getNamespace((String)"tei", (String)"http://www.tei-c.org/ns/1.0");
    protected static PatternReplacer replacer1 = new PatternReplacer("(\\w)(\\^)([1|2|3|4|5|6|7|8|9|0])(\\.|\\?|!)", "<zzzzlj>$1</zzzzlj> <ref rend=\"superscript\">$3</ref> $4");
    protected static PatternReplacer replacer2 = new PatternReplacer("(\\w)(\\^)([1|2|3|4|5|6|7|8|9|0])(\\W)", "$1 <ref rend=\"superscript\"><zzzzlj>$3</zzzzlj></ref><zzzzbl/> $4");
    protected static Pattern pattern = Pattern.compile("((\\^<hi>.+</hi>)+|(\\^.)+)");
    protected static Matcher matcher = pattern.matcher("");

    public static void main(String[] args) {
        try {
            SuperFixer.superFixer(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void superFixer(String[] args) throws Exception {
        FileBatchProcessor processor = new FileBatchProcessor(){

            @Override
            public void processOneFile(String inputFileName) throws Exception {
                String xml = FileUtils.readTextFile(inputFileName);
                matcher.reset(xml);
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String rep = matcher.group(1);
                    rep = "<zzzzlj>" + rep + "</zzzzlj>";
                    matcher.appendReplacement(sb, rep);
                }
                matcher.appendTail(sb);
                xml = sb.toString();
                String strippedFileName = FileNameUtils.stripPathName(inputFileName);
                strippedFileName = FileNameUtils.changeFileExtension(strippedFileName, "");
                String xmlOutputFileName = new File(this.outputDirectoryName, strippedFileName + ".xml").getAbsolutePath();
                FileUtils.createPathForFile(xmlOutputFileName);
                FileUtils.writeTextFile(xmlOutputFileName, false, xml, "utf-8");
            }

            public Element createElement(String name) {
                Element element = new Element(name, teiNamespace);
                return element;
            }
        };
        processor.setOutputDirectoryName(args[0]);
        processor.setInputFileNames(args, 1);
        processor.run();
    }
}

