/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.tcp;

import edu.northwestern.at.utils.Formatters;
import edu.northwestern.at.utils.MapFactory;
import edu.northwestern.at.utils.MapUtils;
import edu.northwestern.at.utils.StringUtils;
import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;

public class ExtractSoftHyphens {
    protected static PrintStream printStream;
    protected static String dividedWordsFileName;
    protected static String filteredDividedWordsFileName;
    protected static Map<String, String> dividedWords;
    protected static Map<String, Number> filteredDividedWords;

    public static void main(String[] args) {
        try {
            if (!ExtractSoftHyphens.initialize(args)) {
                System.exit(1);
            }
            long startTime = System.currentTimeMillis();
            Map<String, String> filteredDividedWords = ExtractSoftHyphens.processWords();
            MapUtils.saveMap(filteredDividedWords, filteredDividedWordsFileName, "\t", "", "utf-8");
            long processingTime = (System.currentTimeMillis() - startTime + 999L) / 1000L;
            ExtractSoftHyphens.terminate(filteredDividedWords.size(), processingTime);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.getMessage());
        }
    }

    protected static boolean initialize(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Not enough parameters.");
            return false;
        }
        printStream = new PrintStream((OutputStream)new BufferedOutputStream(System.out), true, "utf-8");
        dividedWordsFileName = args[0];
        dividedWords = MapUtils.loadMap(dividedWordsFileName);
        System.err.println("Loaded " + Formatters.formatIntegerWithCommas(dividedWords.size()) + " divided words.");
        filteredDividedWordsFileName = args[1];
        return true;
    }

    protected static Map<String, String> processWords() {
        Map<String, String> filteredDividedWords = MapFactory.createNewSortedMap();
        for (String dividedWord : dividedWords.keySet()) {
            String fixedWord = dividedWords.get(dividedWord);
            String fixedDividedWord = StringUtils.replaceAll(dividedWord, "|", "");
            if (fixedDividedWord.equals(fixedWord)) continue;
            filteredDividedWords.put(dividedWord, fixedWord);
        }
        return filteredDividedWords;
    }

    protected static void terminate(int wordsProcessed, long processingTime) {
        System.err.println("Emitted " + Formatters.formatIntegerWithCommas(wordsProcessed) + " filtered divided words in " + Formatters.formatLongWithCommas(processingTime) + " seconds.");
    }
}

