/*
 * Decompiled with CFR 0.152.
 */
package edu.northwestern.at.morphadorner.tools.taggertrainer;

import edu.northwestern.at.utils.Compare;
import java.util.List;

public class TagError
implements Comparable {
    public final String correctTag;
    public final String incorrectTag;
    public final List<Integer> errorPositions;
    public final int incorrectTagCount;
    protected final int hashCode;

    public TagError(String correctTag, String incorrectTag, List<Integer> errorPositions) {
        this.correctTag = correctTag;
        this.incorrectTag = incorrectTag;
        this.errorPositions = errorPositions;
        this.incorrectTagCount = this.errorPositions.size();
        this.hashCode = this.correctTag.hashCode() ^ this.incorrectTag.hashCode() ^ new Integer(this.incorrectTagCount).hashCode();
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (object != null && object instanceof TagError) {
            TagError otherTagError = (TagError)object;
            result = this.correctTag.equals(otherTagError.correctTag) && this.incorrectTag.equals(otherTagError.incorrectTag) && this.incorrectTagCount == otherTagError.incorrectTagCount;
        }
        return result;
    }

    public int compareTo(Object object) {
        int result = 0;
        if (object == null || !(object instanceof TagError)) {
            result = Integer.MIN_VALUE;
        } else {
            TagError otherTagError = (TagError)object;
            if (this.incorrectTagCount > otherTagError.incorrectTagCount) {
                result = -1;
            } else if (this.incorrectTagCount < otherTagError.incorrectTagCount) {
                result = 1;
            }
            if (result == 0) {
                result = Compare.compare(this.incorrectTag, otherTagError.incorrectTag);
            }
            if (result == 0) {
                result = Compare.compare(this.correctTag, otherTagError.correctTag);
            }
        }
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.incorrectTagCount + " " + this.incorrectTag + " should be " + this.correctTag;
    }
}

